/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.CategoryUtils;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.index.DocLink;
import com.mathworks.helpsearch.index.DocumentBooster;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.IndexDocumentBuilder;
import com.mathworks.helpsearch.index.PagePopularities;
import com.mathworks.helpsearch.index.example.Example;
import com.mathworks.helpsearch.product.DocCenterItemResolver;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.SearchField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocCenterIndexDocumentBuilder
implements IndexDocumentBuilder<DocumentationSearchField> {
    private static final Pattern PAGE_NAME_PATTERN = Pattern.compile("([^/]+)\\.html[^/]*$");
    private static final Map<String, RefEntityType> INFO_TYPE_REFENTITY_MAP = new HashMap<String, RefEntityType>();
    private final PagePopularities fPopularities;
    private final DocumentBooster fBooster;

    public DocCenterIndexDocumentBuilder(PagePopularities popularities, DocumentBooster booster) {
        this.fPopularities = popularities;
        this.fBooster = booster;
    }

    @Override
    public List<IndexDocument<DocumentationSearchField>> createIndexDocuments(DocumentationDocument doc) {
        int numDocs = doc.getNestedReferenceData().size() + 1;
        ArrayList<IndexDocument<DocumentationSearchField>> indexDocs = new ArrayList<IndexDocument<DocumentationSearchField>>(numDocs);
        indexDocs.add(this.createMainIndexDocument(doc));
        for (ReferenceData refData : doc.getNestedReferenceData()) {
            indexDocs.add(this.createNestedRefDataDocument(refData));
        }
        return indexDocs;
    }

    private IndexDocument<DocumentationSearchField> createMainIndexDocument(DocumentationDocument doc) {
        List<Example> examples;
        List<DocLink> seeAlsoLinks;
        ResultCategory parentCategory;
        InformationType type = doc.getType();
        IndexDocument indexDoc = new IndexDocument();
        List<ResultCategory> breadCrumbs = doc.getBreadCrumbs();
        String ancestorIds = CategoryUtils.buildAncestorIdsString(breadCrumbs);
        if (type == InformationType.CATEGORY_PAGE) {
            String nodeId = CategoryUtils.createIdFromFilePath(doc.getDocSetItem(), doc.getRelativePath());
            ancestorIds = ancestorIds + " " + nodeId;
            indexDoc.addFieldValue((SearchField)DocumentationSearchField.NODE_ID, nodeId);
        }
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.ANCESTOR_ID, ancestorIds);
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.ANCESTOR_LABEL, CategoryUtils.buildSearchIndexString(breadCrumbs));
        if (!breadCrumbs.isEmpty() && (parentCategory = breadCrumbs.get(0)) != null) {
            indexDoc.addFieldValue((SearchField)DocumentationSearchField.PARENT_ID, parentCategory.getNodeId());
        }
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.BODY, doc.getBody());
        if (doc.getPageSummary() != null) {
            indexDoc.addFieldValue((SearchField)DocumentationSearchField.SUMMARY, doc.getPageSummary());
        }
        if (doc.getDescription() != null) {
            indexDoc.addFieldValue((SearchField)DocumentationSearchField.DESCRIPTION, doc.getDescription());
        }
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.RELATIVE_PATH, doc.getRelativePath());
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.RESULT_TYPE, doc.getType().getIndexString());
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.TITLE_DISPLAY, doc.getTitle());
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.TITLE_SEARCH, doc.getTitle());
        String prodFieldValue = DocCenterItemResolver.toIndexString(doc.getDocSetItem());
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.PRODUCT, prodFieldValue);
        int popularity = this.getPopularity(doc.getRelativePath());
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.POPULARITY, String.valueOf(popularity));
        DocCenterIndexDocumentBuilder.populateReferenceFields(doc, (IndexDocument<DocumentationSearchField>)indexDoc);
        List<String> syntaxLines = doc.getSyntaxLines();
        if (!syntaxLines.isEmpty()) {
            indexDoc.addFieldValue((SearchField)DocumentationSearchField.SYNTAX_LINES, DocCenterIndexDocumentBuilder.formatSyntaxLines(syntaxLines));
        }
        if (!(seeAlsoLinks = doc.getSeeAlsoLinks()).isEmpty()) {
            indexDoc.addFieldValue((SearchField)DocumentationSearchField.SEE_ALSO_LINK, DocCenterIndexDocumentBuilder.formatSeeAlsoLinks(seeAlsoLinks));
        }
        if (!(examples = doc.getExamples()).isEmpty()) {
            indexDoc.addFieldValue((SearchField)DocumentationSearchField.EXAMPLE_ID, DocCenterIndexDocumentBuilder.getExampleIds(examples));
            indexDoc.addFieldValue((SearchField)DocumentationSearchField.HAS_EXAMPLES, "1");
        }
        if (doc.getIgnoreForCategoryFacet()) {
            indexDoc.addFieldValue((SearchField)DocumentationSearchField.UNFACETED_CATEGORY, "1");
        }
        if (this.fBooster != null) {
            indexDoc.setBoost(this.fBooster.getDocumentBoost(doc));
            indexDoc.setFieldBoosts(this.fBooster.getFieldBoosts(doc));
        }
        return indexDoc;
    }

    private IndexDocument<DocumentationSearchField> createNestedRefDataDocument(ReferenceData refData) {
        IndexDocument indexDoc = new IndexDocument();
        String prodFieldValue = DocCenterItemResolver.toIndexString(refData.getDocSetItem());
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.PRODUCT, prodFieldValue);
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.RELATIVE_PATH, refData.getRelativePath());
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.REFPAGE_SUMMARY, refData.getPurposeLine());
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.REFPAGE_DESCRIPTION, refData.getDescription());
        ReferenceEntity refEntity = new ReferenceEntity(refData.getType(), refData.getTopic());
        DocCenterIndexDocumentBuilder.populateRefEntityData(Arrays.asList(refEntity), (IndexDocument<DocumentationSearchField>)indexDoc);
        List<String> syntaxLines = refData.getSyntaxLines();
        if (!syntaxLines.isEmpty()) {
            indexDoc.addFieldValue((SearchField)DocumentationSearchField.SYNTAX_LINES, DocCenterIndexDocumentBuilder.formatSyntaxLines(syntaxLines));
        }
        return indexDoc;
    }

    static void populateReferenceFields(DocumentationDocument doc, IndexDocument<DocumentationSearchField> indexDoc) {
        LinkedHashSet<ReferenceEntity> referenceEntities = new LinkedHashSet<ReferenceEntity>(doc.getReferenceEntities());
        referenceEntities.addAll(DocCenterIndexDocumentBuilder.getBackwardsCompatibleRefEntities(doc));
        if (!referenceEntities.isEmpty()) {
            DocCenterIndexDocumentBuilder.populateRefEntityData(referenceEntities, indexDoc);
        }
    }

    private static Collection<ReferenceEntity> getBackwardsCompatibleRefEntities(DocumentationDocument doc) {
        if (doc.isReferencePage()) {
            String fromPageTitle = doc.getTitle();
            String fromPageName = DocCenterIndexDocumentBuilder.getEntityNameFromPageName(doc.getRelativePath());
            RefEntityType refEntityType = DocCenterIndexDocumentBuilder.inferRefEntityType(doc);
            if (refEntityType != null) {
                return Arrays.asList(new ReferenceEntity(refEntityType, fromPageTitle), new ReferenceEntity(refEntityType, fromPageName));
            }
        }
        return Collections.emptyList();
    }

    private static String getEntityNameFromPageName(String relPath) {
        Matcher m = PAGE_NAME_PATTERN.matcher(relPath);
        return m.find() ? m.group(1) : null;
    }

    private static RefEntityType inferRefEntityType(DocumentationDocument doc) {
        List<String> infoTypeStrings = doc.getInfoTypeStrings();
        for (String typeStr : infoTypeStrings) {
            if (!INFO_TYPE_REFENTITY_MAP.containsKey(typeStr)) continue;
            return INFO_TYPE_REFENTITY_MAP.get(typeStr);
        }
        InformationType type = doc.getType();
        if (type != null) {
            switch (type) {
                case BLOCKS: {
                    return RefEntityType.BLOCK;
                }
                case FUNCTIONS: {
                    return RefEntityType.FUNCTION;
                }
                case SYSTEM_OBJECTS: {
                    return RefEntityType.SYSTEM_OBJECT;
                }
            }
        }
        return null;
    }

    private static void populateRefEntityData(Collection<ReferenceEntity> referenceEntities, IndexDocument<DocumentationSearchField> indexDoc) {
        StringBuilder refEntityString = new StringBuilder();
        StringBuilder refEntityNamesString = new StringBuilder();
        EnumSet<RefEntityType> uniqueTypes = EnumSet.noneOf(RefEntityType.class);
        for (ReferenceEntity entity : referenceEntities) {
            refEntityString.append(entity.getFullIndexString()).append('\n');
            refEntityNamesString.append(entity.getIndexStringForEntityName()).append('\n');
            RefEntityType type = entity.getType();
            if (type == null) continue;
            uniqueTypes.add(type);
        }
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.REFPAGE_FLAG, "1");
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.REFPAGE_ENTITY_INFO, refEntityString.toString().trim());
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.REFPAGE_ENTITY_INFO_CASE, refEntityString.toString().trim());
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.REFPAGE_ENTITY_NAME, refEntityNamesString.toString().trim());
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.REFPAGE_ENTITY_NAME_CASE, refEntityNamesString.toString().trim());
        StringBuilder typesStr = new StringBuilder();
        for (RefEntityType uniqueType : uniqueTypes) {
            typesStr.append(uniqueType.getIndexValue()).append('\n');
        }
        indexDoc.addFieldValue((SearchField)DocumentationSearchField.REFPAGE_ENTITY_TYPE, typesStr.toString().trim());
    }

    private int getPopularity(String relativePath) {
        if (this.fPopularities != null && this.fPopularities.getPopularities().containsKey(relativePath)) {
            return this.fPopularities.getPopularities().get(relativePath);
        }
        return 0;
    }

    private static String formatSyntaxLines(List<String> syntaxLines) {
        StringBuilder builder = new StringBuilder();
        for (String line : syntaxLines) {
            builder.append(line).append('\n');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private static String formatSeeAlsoLinks(List<DocLink> seeAlsoLinks) {
        StringBuilder builder = new StringBuilder();
        for (DocLink link : seeAlsoLinks) {
            builder.append(link.toIndexString()).append('\n');
        }
        return builder.toString().trim();
    }

    private static String getExampleIds(List<Example> examples) {
        StringBuilder sb = new StringBuilder();
        for (Example example : examples) {
            sb.append(example.getId()).append(' ');
        }
        return sb.toString().trim();
    }

    static {
        INFO_TYPE_REFENTITY_MAP.put("ref/function", RefEntityType.FUNCTION);
        INFO_TYPE_REFENTITY_MAP.put("mlref/sysobj", RefEntityType.SYSTEM_OBJECT);
        INFO_TYPE_REFENTITY_MAP.put("mlref/class", RefEntityType.CLASS);
        INFO_TYPE_REFENTITY_MAP.put("mlref/function", RefEntityType.METHOD);
        INFO_TYPE_REFENTITY_MAP.put("mlref/property", RefEntityType.PROPERTY);
        INFO_TYPE_REFENTITY_MAP.put("ref/block", RefEntityType.BLOCK);
    }
}

