/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.index.DocumentTracker;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.HtmlParser;
import com.mathworks.helpsearch.index.HtmlParserFactory;
import com.mathworks.helpsearch.index.microdata.MicrodataDocumentBuilder;
import com.mathworks.helpsearch.index.microdata.MicrodataItem;
import com.mathworks.helpsearch.index.microdata.MicrodataParser;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;

public class DocumentParser {
    private final ContentFormat fFormat;
    private final HtmlParserFactory fParserFactory;

    public DocumentParser(ContentFormat format, HtmlParserFactory factory) {
        this.fFormat = format;
        this.fParserFactory = factory;
    }

    protected void parseDocument(DocumentTracker tracker, Document domDoc, ParserType ... types) throws Exception {
        DocumentPopulationStrategy[] strategies = this.getPopulationStrategies(types);
        this.parseDocument(tracker, domDoc, strategies);
    }

    protected void parseDocument(DocumentTracker tracker, Document domDoc, DocumentPopulationStrategy ... strategies) throws Exception {
        if (strategies == null || strategies.length == 0) {
            throw new IllegalArgumentException("Cannot parse document without using microdata, DOM parsing, or both");
        }
        for (DocumentPopulationStrategy strategy : strategies) {
            strategy.populateDocument(tracker, domDoc);
        }
    }

    private DocumentPopulationStrategy[] getPopulationStrategies(ParserType ... types) {
        DocumentPopulationStrategy[] strategies = new DocumentPopulationStrategy[types.length];
        for (int i = 0; i < types.length; ++i) {
            strategies[i] = this.getParserStrategy(types[i]);
        }
        return strategies;
    }

    private DocumentPopulationStrategy getParserStrategy(ParserType type) {
        switch (type) {
            case MICRODATA: {
                return new MicrodataPopulationStrategy();
            }
            case DOM: {
                return new DomParserPopulationStrategy();
            }
        }
        return null;
    }

    private class MicrodataPopulationStrategy
    implements DocumentPopulationStrategy {
        private MicrodataPopulationStrategy() {
        }

        @Override
        public void populateDocument(DocumentTracker tracker, Document domDoc) throws Exception {
            MicrodataParser parser = new MicrodataParser(domDoc);
            parser.parseDocument();
            List<MicrodataItem> items = parser.getTopLevelItems();
            tracker.setMicrodataItems(items == null ? Collections.emptyList() : items);
            if (items != null && !items.isEmpty()) {
                for (MicrodataItem topLevelItem : items) {
                    MicrodataDocumentBuilder docBuilder = new MicrodataDocumentBuilder(DocumentParser.this.fFormat);
                    docBuilder.populateDocument(tracker.getDocumentationDocument(), topLevelItem);
                }
            }
        }
    }

    private class DomParserPopulationStrategy
    implements DocumentPopulationStrategy {
        private DomParserPopulationStrategy() {
        }

        @Override
        public void populateDocument(DocumentTracker tracker, Document domDoc) throws Exception {
            DocumentationDocument doc = tracker.getDocumentationDocument();
            String relativePath = doc.getRelativePath();
            HtmlParser parser = DocumentParser.this.fParserFactory.createParserForDocument(domDoc, relativePath);
            parser.parseDocument(doc, relativePath);
        }
    }

    public static interface DocumentPopulationStrategy {
        public void populateDocument(DocumentTracker var1, Document var2) throws Exception;
    }

    public static enum ParserType {
        MICRODATA,
        DOM;

    }
}

