/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.doccenter;

import com.mathworks.helpsearch.InformationType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class InfoTypeMap {
    private static final Map<String, InformationType> INFO_TYPE_MAP;
    private static final Set<String> EXCLUDED_TYPE_STRINGS;

    public static InformationType mapInfoType(Collection<String> infoTypes) {
        if (infoTypes == null || infoTypes.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, InformationType> entry : INFO_TYPE_MAP.entrySet()) {
            if (!infoTypes.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        if (InfoTypeMap.isUnfacetedIndexedType(infoTypes)) {
            return InformationType.OTHER_VALID_TYPE;
        }
        return null;
    }

    private static boolean isUnfacetedIndexedType(Collection<String> infoTypes) {
        for (String type : infoTypes) {
            if (type == null || type.trim().length() <= 0 || EXCLUDED_TYPE_STRINGS.contains(type)) continue;
            return true;
        }
        return false;
    }

    static {
        EXCLUDED_TYPE_STRINGS = new HashSet<String>(Arrays.asList("ug"));
        INFO_TYPE_MAP = new LinkedHashMap<String, InformationType>();
        INFO_TYPE_MAP.put("mlref/sysobj", InformationType.SYSTEM_OBJECTS);
        INFO_TYPE_MAP.put("ref/function", InformationType.FUNCTIONS);
        INFO_TYPE_MAP.put("mlref/function", InformationType.FUNCTIONS);
        INFO_TYPE_MAP.put("ref/block", InformationType.BLOCKS);
        INFO_TYPE_MAP.put("ex", InformationType.EXAMPLES_HOWTO);
        INFO_TYPE_MAP.put("con", InformationType.MORE_ABOUT);
        INFO_TYPE_MAP.put("cat", InformationType.CATEGORY_PAGE);
        INFO_TYPE_MAP.put("rn", InformationType.RELEASE_NOTES);
    }
}

