/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.microdata;

import com.mathworks.helpsearch.CategoryUtils;
import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.index.DocLink;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.IndexUtils;
import com.mathworks.helpsearch.index.classic.TocTypeMap;
import com.mathworks.helpsearch.index.doccenter.InfoTypeMap;
import com.mathworks.helpsearch.index.example.Example;
import com.mathworks.helpsearch.index.microdata.MicrodataItem;
import com.mathworks.helpsearch.index.microdata.ReferenceDataParser;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class MicrodataDocumentBuilder {
    private final ContentFormat fFormat;

    public MicrodataDocumentBuilder(ContentFormat format) {
        this.fFormat = format;
    }

    public void populateDocument(DocumentationDocument doc, MicrodataItem item) {
        String thumbnail;
        List<Example> examples;
        String content;
        List<String> syntaxLines;
        String description;
        String purpose;
        String title = MicrodataDocumentBuilder.getStringProperty(item, "title");
        if (title != null && title.trim().length() > 0) {
            doc.setTitle(title);
        }
        if ((purpose = MicrodataDocumentBuilder.getStringProperty(item, "purpose")) != null && purpose.trim().length() > 0) {
            doc.setPageSummary(MicrodataDocumentBuilder.fixWhitespace(purpose));
        }
        if ((description = MicrodataDocumentBuilder.getStringProperty(item, "description")) != null && description.trim().length() > 0) {
            doc.setDescription(MicrodataDocumentBuilder.fixWhitespace(description));
        }
        if ((syntaxLines = item.getStringProperties().get("syntax")) != null && !syntaxLines.isEmpty()) {
            doc.addSyntaxLines(MicrodataDocumentBuilder.fixWhitespace(syntaxLines));
        }
        if ((content = MicrodataDocumentBuilder.getStringProperty(item, "content")) != null && content.trim().length() > 0) {
            doc.setBody(content);
        }
        this.determineInfoType(item, doc);
        List<ResultCategory> breadCrumbs = this.getBreadCrumbs(doc.getDocSetItem(), doc.getRelativePath(), item);
        if (breadCrumbs != null && !breadCrumbs.isEmpty()) {
            doc.setBreadCrumbs(breadCrumbs);
        }
        if ((examples = this.getExamples(item, doc)) != null & !examples.isEmpty()) {
            doc.addExamples(examples);
        }
        ReferenceDataParser refParser = new ReferenceDataParser(doc);
        List<ReferenceEntity> refEntities = refParser.getTopLevelReferenceEntities(item);
        doc.addReferenceEntities(refEntities);
        List<ReferenceData> nestedReferenceItems = refParser.getAllNestedReferenceItems(item);
        doc.addNestedReferenceData(nestedReferenceItems);
        List<DocLink> seeAlsoLinks = this.getSeeAlsoLinks(item, doc);
        if (seeAlsoLinks != null) {
            doc.addSeeAlsoLinks(seeAlsoLinks);
        }
        if ((thumbnail = MicrodataDocumentBuilder.getStringProperty(item, "thumbnailUrl")) != null) {
            DocLink link = doc.resolveRelativeLink(thumbnail, "");
            doc.setThumbnail(link.getPath());
        }
    }

    private void determineInfoType(MicrodataItem item, DocumentationDocument doc) {
        switch (this.fFormat) {
            case DOC_CENTER_DOC: {
                MicrodataDocumentBuilder.determineDocCenterInfoType(item, doc);
                break;
            }
            case CLASSIC_DOC: {
                doc.setType(MicrodataDocumentBuilder.determineClassicDocInfoType(item));
            }
        }
    }

    private static void determineDocCenterInfoType(MicrodataItem item, DocumentationDocument doc) {
        List<String> typeStrings = item.getStringProperties().get("infotype");
        String pageType = MicrodataDocumentBuilder.getStringProperty(item, "pagetype");
        if (MicrodataDocumentBuilder.isFeaturedExample(doc.getRelativePath(), typeStrings, pageType)) {
            doc.setIgnoreForCategoryFacet(true);
            doc.setType(InformationType.EXAMPLES_HOWTO);
            return;
        }
        if (typeStrings == null) {
            return;
        }
        typeStrings = MicrodataDocumentBuilder.expandSpaceDelimitedTypes(typeStrings);
        doc.setInfoTypeStrings(typeStrings);
        InformationType infoType = InfoTypeMap.mapInfoType(typeStrings);
        doc.setType(infoType);
    }

    private static boolean isFeaturedExample(String relPath, List<String> infoTypeStrings, String pageType) {
        return MicrodataDocumentBuilder.isFeaturedExamplePageType(pageType) && (relPath.matches("^/?examples/index.html.*$") || MicrodataDocumentBuilder.isFeaturedExampleInfoType(infoTypeStrings));
    }

    private static boolean isFeaturedExamplePageType(String pageType) {
        return pageType != null && pageType.equals("fe");
    }

    private static boolean isFeaturedExampleInfoType(List<String> infoTypeStrings) {
        return infoTypeStrings != null && infoTypeStrings.contains("ug");
    }

    private static List<String> expandSpaceDelimitedTypes(List<String> typeStrings) {
        LinkedList<String> allInfoTypes = new LinkedList<String>();
        for (String typeString : typeStrings) {
            allInfoTypes.addAll(Arrays.asList(typeString.split("\\s+")));
        }
        return allInfoTypes;
    }

    private static InformationType determineClassicDocInfoType(MicrodataItem item) {
        String pageType = MicrodataDocumentBuilder.getStringProperty(item, "pagetype");
        return TocTypeMap.mapTocType(pageType);
    }

    private List<ResultCategory> getBreadCrumbs(DocSetItem docSetItem, String docPath, MicrodataItem item) {
        String[] docDirs = docPath == null ? new String[]{} : IndexUtils.getDirectoriesForFilePath(docPath);
        List<MicrodataItem> breadcrumbItems = item.getItemProperties().get("breadcrumb");
        if (breadcrumbItems != null) {
            ResultCategory current = null;
            for (MicrodataItem breadcrumb : breadcrumbItems) {
                String title = MicrodataDocumentBuilder.getStringProperty(breadcrumb, "title");
                String url = MicrodataDocumentBuilder.getStringProperty(breadcrumb, "url");
                url = IndexUtils.resolveRelativePath(url, docDirs);
                if (title == null || title.trim().length() <= 0 || !IndexUtils.includeLinkInBreadCrumb(url)) continue;
                String id = CategoryUtils.createIdFromFilePath(docSetItem, url);
                current = new ResultCategory(current, title, url, id);
            }
            if (current != null) {
                LinkedList<ResultCategory> breadCrumbs = new LinkedList<ResultCategory>();
                breadCrumbs.add(current);
                return breadCrumbs;
            }
        }
        return null;
    }

    static String getStringProperty(MicrodataItem item, String property) {
        List<String> values = item.getStringProperties().get(property);
        if (values != null) {
            StringBuilder stringValue = new StringBuilder();
            for (String value : values) {
                stringValue.append('\n').append(value);
            }
            if (stringValue.length() > 0) {
                stringValue.deleteCharAt(0);
            }
            return stringValue.toString();
        }
        return null;
    }

    private List<DocLink> getSeeAlsoLinks(MicrodataItem item, DocumentationDocument doc) {
        LinkedList<DocLink> links = new LinkedList<DocLink>();
        List<MicrodataItem> seeAlsoItems = item.getItemProperties().get("seealso");
        if (seeAlsoItems != null) {
            for (MicrodataItem seeAlsoItem : seeAlsoItems) {
                DocLink resolvedUrl;
                String url = MicrodataDocumentBuilder.getStringProperty(seeAlsoItem, "url");
                String name = MicrodataDocumentBuilder.getStringProperty(seeAlsoItem, "name");
                if (url == null || name == null || (resolvedUrl = doc.resolveRelativeLink(url, name)) == null) continue;
                links.add(resolvedUrl);
            }
        }
        return links;
    }

    private List<Example> getExamples(MicrodataItem item, DocumentationDocument doc) {
        LinkedList<Example> examples = new LinkedList<Example>();
        List<MicrodataItem> exampleItems = item.getItemProperties().get("example");
        String pageType = MicrodataDocumentBuilder.getStringProperty(item, "pagetype");
        List<String> typeStrings = item.getStringProperties().get("infotype");
        if (exampleItems != null) {
            for (MicrodataItem exampleItem : exampleItems) {
                String exampleId = MicrodataDocumentBuilder.getStringProperty(exampleItem, "exampleid");
                String exampleTitle = MicrodataDocumentBuilder.getStringProperty(exampleItem, "exampletitle");
                if (exampleId == null) continue;
                if (MicrodataDocumentBuilder.isFeaturedExamplePageType(pageType)) {
                    examples.add(new Example(Example.ExampleType.FEATURED, exampleId, exampleTitle, doc.getRelativePath()));
                    continue;
                }
                examples.add(new Example(Example.ExampleType.EM, exampleId, exampleTitle, doc.getRelativePath()));
            }
        }
        return examples;
    }

    private static List<String> fixWhitespace(List<String> values) {
        LinkedList<String> fixed = new LinkedList<String>();
        for (String value : values) {
            String fixedValue = value == null ? null : MicrodataDocumentBuilder.fixWhitespace(value);
            fixed.add(fixedValue);
        }
        return fixed;
    }

    private static String fixWhitespace(String value) {
        return value.replaceAll("\\s+", " ");
    }
}

