/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.report;

import com.mathworks.helpsearch.index.report.ReportPart;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class IndexReport {
    private final List<ReportPart> fReportParts = new LinkedList<ReportPart>();

    void addParts(ReportPart ... parts) {
        this.addParts(Arrays.asList(parts));
    }

    void addParts(Collection<ReportPart> parts) {
        this.fReportParts.addAll(parts);
    }

    public String toString() {
        return this.toHtml();
    }

    public String toHtml() {
        StringBuilder report = new StringBuilder("<html>\n<head>\n");
        report.append(this.buildStyles());
        report.append("</head>\n<body>");
        for (ReportPart part : this.fReportParts) {
            part.appendToReport(report);
        }
        report.append("\n</body>\n</html>");
        return report.toString();
    }

    private String buildStyles() {
        StringBuilder styles = new StringBuilder("<style>\n");
        Map<String, String> stylesMap = this.buildStyleMap();
        for (Map.Entry<String, String> style : stylesMap.entrySet()) {
            String key = style.getKey();
            String value = style.getValue();
            styles.append("    ").append(key).append(" {");
            styles.append(value).append("}\n");
        }
        styles.append("</style>\n");
        return styles.toString();
    }

    private Map<String, String> buildStyleMap() {
        LinkedHashMap<String, String> allStyles = new LinkedHashMap<String, String>();
        for (ReportPart part : this.fReportParts) {
            allStyles.putAll(part.getCssRules());
        }
        return allStyles;
    }
}

