/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.report;

import com.mathworks.helpsearch.index.report.ReportPart;
import com.mathworks.helpsearch.index.report.StringReportPart;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class TableReportPart
extends ReportPart {
    private final Map<String, ReportPart> fTableParts = new LinkedHashMap<String, ReportPart>();

    public void addPart(String key, ReportPart value) {
        this.fTableParts.put(key, value);
    }

    public void addStringPart(String key, String value) {
        this.addPart(key, new StringReportPart(value));
    }

    @Override
    public void appendToReport(StringBuilder builder) {
        builder.append("<table class=\"reporttable\">\n");
        for (Map.Entry<String, ReportPart> parts : this.fTableParts.entrySet()) {
            builder.append("<tr class=\"reporttablerow\">\n");
            builder.append("<td class=\"reporttablekey\">").append(TableReportPart.escapeHtml(parts.getKey())).append("</td>");
            builder.append("\n<td class=\"reporttablevalue\">");
            parts.getValue().appendToReport(builder);
            builder.append("</td>\n</tr>");
        }
        builder.append("</table>");
    }

    @Override
    protected Map<String, String> getCssRules() {
        LinkedHashMap<String, String> rules = new LinkedHashMap<String, String>();
        String borders = "border:1px solid black;";
        rules.put("table.reporttable", borders + " border-collapse:collapse");
        rules.put("tr.reporttablerow", borders);
        rules.put("td.reporttablekey", borders);
        rules.put("td.reporttablevalue", borders);
        return Collections.unmodifiableMap(rules);
    }
}

