/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product.validation;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.validation.DocSetValidationCheck;
import com.mathworks.helpsearch.product.validation.ValidationResponse;
import com.mathworks.search.SearchField;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneIndexUtils;
import java.util.HashMap;
import java.util.Map;

public class IndexedProductsCheck
extends DocSetValidationCheck {
    private final Map<String, Integer> fProductStats;

    public IndexedProductsCheck(DocumentationSet docSet, Map<String, Integer> productStats) {
        super(docSet);
        this.fProductStats = new HashMap<String, Integer>(productStats);
    }

    public IndexedProductsCheck(DocumentationSet docSet, IndexLocation location) {
        super(docSet);
        Map productStats = null;
        try {
            productStats = LuceneIndexUtils.getSearchFieldStatistics((IndexLocation)location, (SearchField)DocumentationSearchField.PRODUCT);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fProductStats = productStats;
    }

    @Override
    public ValidationResponse validate(DocumentationSet docSet) {
        ValidationResponse response = new ValidationResponse();
        if (this.fProductStats == null) {
            response.addMessage(ValidationResponse.Status.ERROR, "Failed to load product data from the search index.");
            response.addTroubleshootingStep("Check that this documentation set has a valid search index.");
            return response;
        }
        boolean missingProduct = false;
        for (DocProduct product : docSet.getAllProducts()) {
            String shortName = product.getShortName();
            int numResults = this.fProductStats.containsKey(shortName) ? this.fProductStats.get(shortName) : 0;
            response.addMessage(numResults > 0 ? ValidationResponse.Status.OK : ValidationResponse.Status.ERROR, product.getDisplayName() + " : " + numResults);
            missingProduct = missingProduct || numResults == 0;
        }
        if (missingProduct) {
            response.addTroubleshootingStep("The search index may not have been updated after new products were added to the documentation set.  Rebuilding the search index will typically solve this issue");
            response.addTroubleshootingStep("It is possible that a product in the documentation set is misconfigured, preventing the search indexer from finding that product's documentation.  Please check that each product in the documentation set points to a valid help location.");
        }
        return response;
    }

    @Override
    public String getName() {
        return "Products Found in Search Index";
    }

    @Override
    public String getDescription() {
        return "Validates that each product listed in the documentation set is represented in the search index by at least one document.  This validation typically fails when the search index is not updated after a product is added to the documentation set.";
    }
}

