/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SimpleSearchExpression;

public class FilePathReferenceRequest
extends ReferenceRequest {
    private final String fRelPath;

    public FilePathReferenceRequest(DocProduct product, String relPath) {
        this.fRelPath = FilePathReferenceRequest.cleanUpPath(relPath);
        this.addProducts(product);
    }

    @Override
    protected SearchExpression getBaseExpression() {
        SimpleSearchExpression expr = new SimpleSearchExpression(this.fRelPath, BooleanSearchOperator.MUST_OCCUR);
        expr.addSearchField((SearchField)DocumentationSearchField.RELATIVE_PATH);
        return expr;
    }

    private static String cleanUpPath(String relPath) {
        if ((relPath = relPath.replace('\\', '/')).charAt(0) == '/') {
            relPath = relPath.substring(1);
        }
        int qsIndex = relPath.contains("?") ? relPath.indexOf(63) : relPath.length();
        int anchorIndex = relPath.contains("#") ? relPath.indexOf(35) : relPath.length();
        relPath = relPath.substring(0, Math.min(qsIndex, anchorIndex));
        return relPath;
    }
}

