/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.SeeAlsoLink;
import com.mathworks.helpsearch.index.DocLink;
import com.mathworks.helpsearch.product.DocCenterItemResolver;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import com.mathworks.search.SearchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ReferenceData {
    private final DocSetItem fDocSetItem;
    private final String fRelativePath;
    private final String fTopic;
    private final String fPurposeLine;
    private final String fDescription;
    private final RefEntityType fType;
    private final List<String> fSyntaxLines;
    private final List<SeeAlsoLink> fSeeAlsoLinks;

    public ReferenceData(DocSetItem docSetItem, String topic, String relativePath, String purposeLine, String description, RefEntityType type, List<String> syntaxLines, List<SeeAlsoLink> seeAlsoLinks) {
        this.fDocSetItem = docSetItem;
        this.fTopic = topic;
        this.fRelativePath = relativePath;
        this.fPurposeLine = purposeLine;
        this.fDescription = description;
        this.fType = type;
        if (syntaxLines == null) {
            syntaxLines = Collections.emptyList();
        }
        this.fSyntaxLines = new ArrayList<String>(syntaxLines);
        if (seeAlsoLinks == null) {
            seeAlsoLinks = Collections.emptyList();
        }
        this.fSeeAlsoLinks = new ArrayList<SeeAlsoLink>(seeAlsoLinks);
    }

    public static List<ReferenceData> fromSearchResult(DocumentationSet docSet, SearchResult result) {
        String prodName = result.getFieldValue(DocumentationSearchField.PRODUCT.getFieldName());
        DocProduct product = new DocCenterItemResolver(docSet).getDocProductByIndexString(prodName);
        LinkedList<ReferenceData> refDataItems = new LinkedList<ReferenceData>();
        String refEntityString = result.getFieldValue(DocumentationSearchField.REFPAGE_ENTITY_INFO.getFieldName());
        if (refEntityString != null) {
            List<ReferenceEntity> entities = ReferenceEntity.fromIndexString(refEntityString.trim());
            for (ReferenceEntity entity : entities) {
                ReferenceData item = ReferenceData.fromSearchResult(docSet, product, entity, result);
                if (item.getType() == null) continue;
                refDataItems.add(item);
            }
        }
        return Collections.unmodifiableList(refDataItems);
    }

    private static ReferenceData fromSearchResult(DocumentationSet docSet, DocProduct product, ReferenceEntity refEntity, SearchResult result) {
        String topic = refEntity.getName();
        if (topic == null) {
            topic = result.getFieldValue(DocumentationSearchField.TITLE_DISPLAY.getFieldName());
        }
        String relPath = result.getFieldValue(DocumentationSearchField.RELATIVE_PATH.getFieldName());
        String purposeLine = ReferenceData.getFieldValue(result, DocumentationSearchField.REFPAGE_SUMMARY, DocumentationSearchField.SUMMARY);
        String description = ReferenceData.getFieldValue(result, DocumentationSearchField.REFPAGE_DESCRIPTION, DocumentationSearchField.DESCRIPTION);
        String rawSyntaxLines = result.getFieldValue(DocumentationSearchField.SYNTAX_LINES.getFieldName());
        List<Object> syntaxLines = rawSyntaxLines == null ? Collections.emptyList() : Arrays.asList(rawSyntaxLines.split("\\n"));
        String rawSeeAlsoLines = result.getFieldValue(DocumentationSearchField.SEE_ALSO_LINK.getFieldName());
        List<SeeAlsoLink> seeAlsoLinks = ReferenceData.parseSeeAlsoLinks(rawSeeAlsoLines, docSet, product);
        return new ReferenceData(product, topic, relPath, purposeLine, description, refEntity.getType(), syntaxLines, seeAlsoLinks);
    }

    private static String getFieldValue(SearchResult result, DocumentationSearchField ... possibleFields) {
        for (DocumentationSearchField field : possibleFields) {
            String value = result.getFieldValue(field.getFieldName());
            if (value == null || value.isEmpty()) continue;
            return value;
        }
        return "";
    }

    private static List<SeeAlsoLink> parseSeeAlsoLinks(String rawSeeAlsoLines, DocumentationSet docSet, DocProduct product) {
        if (rawSeeAlsoLines == null) {
            return Collections.emptyList();
        }
        LinkedList<SeeAlsoLink> seeAlsoLinks = new LinkedList<SeeAlsoLink>();
        List<DocLink> prodLinks = DocLink.fromIndexString(docSet, rawSeeAlsoLines);
        for (DocLink prodLink : prodLinks) {
            SeeAlsoLink seeAlsoLink = SeeAlsoLink.fromProductLink(docSet, product, prodLink);
            if (seeAlsoLink == null) continue;
            seeAlsoLinks.add(seeAlsoLink);
        }
        return seeAlsoLinks;
    }

    public String getTopic() {
        return this.fTopic;
    }

    public String getPurposeLine() {
        return this.fPurposeLine;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public DocSetItem getDocSetItem() {
        return this.fDocSetItem;
    }

    public String getRelativePath() {
        return this.fRelativePath;
    }

    public RefEntityType getType() {
        return this.fType;
    }

    public List<String> getSyntaxLines() {
        return Collections.unmodifiableList(this.fSyntaxLines);
    }

    public List<SeeAlsoLink> getSeeAlsoLinks() {
        return Collections.unmodifiableList(this.fSeeAlsoLinks);
    }
}

