/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference.map;

class RefMappingPart
implements Comparable<RefMappingPart> {
    private final int fWildcardPosition;
    private final String fLiteralValue;

    RefMappingPart(int wildcardPosition) {
        this.fWildcardPosition = wildcardPosition;
        this.fLiteralValue = null;
    }

    RefMappingPart(String literalValue) {
        this.fLiteralValue = literalValue;
        this.fWildcardPosition = -1;
    }

    String getPartValue(String[] srcPathParts) {
        if (this.fWildcardPosition >= 0) {
            return srcPathParts[this.fWildcardPosition];
        }
        return this.fLiteralValue;
    }

    @Override
    public int compareTo(RefMappingPart o) {
        if (this.fLiteralValue == null) {
            return o.fWildcardPosition - this.fWildcardPosition;
        }
        if (o.fLiteralValue == null) {
            return 1;
        }
        return this.fLiteralValue.compareTo(o.fLiteralValue);
    }

    public int hashCode() {
        return this.fLiteralValue != null ? this.fLiteralValue.hashCode() : this.fWildcardPosition;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RefMappingPart) {
            RefMappingPart other = (RefMappingPart)obj;
            if (this.fLiteralValue == null) {
                return this.fWildcardPosition == other.fWildcardPosition && other.fLiteralValue == null;
            }
            return this.fLiteralValue.equals(other.fLiteralValue) && this.fWildcardPosition == other.fWildcardPosition;
        }
        return false;
    }

    public String toString() {
        return this.fLiteralValue == null ? "[" + this.fWildcardPosition + "]" : this.fLiteralValue;
    }
}

