/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.suggestion;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.SearchExpressionFilter;
import com.mathworks.helpsearch.product.DocSetItemResolver;
import com.mathworks.helpsearch.suggestion.DocumentationSuggestionProvider;
import com.mathworks.helpsearch.suggestion.PageSuggestion;
import com.mathworks.helpsearch.suggestion.PageSuggestionAdapter;
import com.mathworks.helpsearch.suggestion.SuggestionComparator;
import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.CompoundSearchExpression;
import com.mathworks.search.ListSearchResultCollector;
import com.mathworks.search.PartialWordSearchExpression;
import com.mathworks.search.SearchCriteria;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchKeywordsVisitor;
import com.mathworks.search.SearchResultAdapter;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SearchSuggestions;
import com.mathworks.search.SimpleSearchExpression;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class SearchEngineSuggestionProvider
implements DocumentationSuggestionProvider {
    private final SearchEngine fEngine;
    private final SearchField fWordSuggestionField;
    private final DocSetItemResolver fResolver;
    private final SearchExpressionFilter fFilter;

    public SearchEngineSuggestionProvider(SearchEngine engine, SearchField wordSuggestionField, DocSetItemResolver resolver) throws IOException {
        this(engine, wordSuggestionField, resolver, null);
    }

    public SearchEngineSuggestionProvider(SearchEngine engine, SearchField wordSuggestionField, DocSetItemResolver resolver, SearchExpressionFilter filter) throws IOException {
        this.fEngine = engine;
        this.fEngine.openIndex();
        this.fWordSuggestionField = wordSuggestionField;
        this.fResolver = resolver;
        this.fFilter = filter;
    }

    @Override
    public SearchResults<PageSuggestion> findSuggestions(InformationType type, String[] words, int start, int num) throws SearchException {
        ListSearchResultCollector<PageSuggestion> collector = this.findSuggestions(type, words);
        return collector.getResults(start, num);
    }

    @Override
    public SearchResults<PageSuggestion> findSuggestions(InformationType type, String[] words, int start) throws SearchException {
        ListSearchResultCollector<PageSuggestion> collector = this.findSuggestions(type, words);
        return collector.getResults(start, collector.getNumResults() - start);
    }

    @Override
    public SearchSuggestions findWordSuggestions(String partialText, int max) throws SearchException {
        return this.fEngine.suggest(this.fWordSuggestionField, partialText, max);
    }

    @Override
    public void cleanup() throws IOException {
        this.fEngine.closeIndex();
    }

    private ListSearchResultCollector<PageSuggestion> findSuggestions(InformationType type, String[] words) throws SearchException {
        List<SearchExpression> exprs = this.buildExpressions(type, words);
        CompoundSearchExpression fullExpr = new CompoundSearchExpression(exprs);
        if (this.fFilter != null) {
            fullExpr = this.fFilter.addFilterToExpression((SearchExpression)fullExpr);
        }
        SearchCriteria criteria = new SearchCriteria((SearchExpression)fullExpr);
        Collection keywords = SearchKeywordsVisitor.getSearchKeywords((SearchExpression)fullExpr);
        PageSuggestionAdapter adapter = new PageSuggestionAdapter(this.fResolver, keywords);
        SuggestionComparator comparator = new SuggestionComparator(words[0]);
        ListSearchResultCollector collector = ListSearchResultCollector.createCollector((SearchResultAdapter)adapter, (Comparator)comparator);
        this.fEngine.search(criteria, new SearchResultCollector[]{collector});
        return collector;
    }

    private List<SearchExpression> buildExpressions(InformationType type, String[] words) {
        ArrayList<SearchExpression> exprs = new ArrayList<SearchExpression>();
        for (String word : words) {
            SimpleSearchExpression exact = new SimpleSearchExpression(word);
            exact.addSearchField((SearchField)DocumentationSearchField.TITLE_SEARCH);
            exact.addSearchField((SearchField)DocumentationSearchField.SUMMARY);
            exact.setBooleanOperator(BooleanSearchOperator.SHOULD_OCCUR);
            PartialWordSearchExpression partial = new PartialWordSearchExpression(word);
            partial.addSearchField((SearchField)DocumentationSearchField.TITLE_SEARCH);
            partial.addSearchField((SearchField)DocumentationSearchField.SUMMARY);
            partial.setBooleanOperator(BooleanSearchOperator.SHOULD_OCCUR);
            CompoundSearchExpression compound = new CompoundSearchExpression(new SearchExpression[]{exact, partial});
            compound.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
            exprs.add((SearchExpression)compound);
        }
        SimpleSearchExpression typeExpr = new SimpleSearchExpression(type.getIndexString(), BooleanSearchOperator.MUST_OCCUR);
        typeExpr.addSearchField((SearchField)DocumentationSearchField.RESULT_TYPE);
        exprs.add((SearchExpression)typeExpr);
        return exprs;
    }
}

