/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.tasks;

import com.mathworks.toolbox.shared.computils.tasks.TerminationClient;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventBroadcastingTerminationClient
implements TerminationClient {
    private final TerminationClient fDelegate;
    private final Collection<Listener> fListeners = new CopyOnWriteArrayList<Listener>();

    public EventBroadcastingTerminationClient(TerminationClient terminationClient) {
        this.fDelegate = terminationClient;
    }

    public void add(Listener listener) {
        this.fListeners.add(listener);
    }

    @Override
    public void cancel() {
        this.fDelegate.cancel();
        this.broadcastOnListener(new Interactor(){

            @Override
            public void interact(Listener listener) {
                listener.cancel();
            }
        });
    }

    @Override
    public void reset() {
        this.fDelegate.reset();
        this.broadcastOnListener(new Interactor(){

            @Override
            public void interact(Listener listener) {
                listener.reset();
            }
        });
    }

    private void broadcastOnListener(Interactor interactor) {
        for (Listener listener : this.fListeners) {
            interactor.interact(listener);
        }
    }

    public static interface Listener
    extends TerminationClient {
    }

    private static interface Interactor {
        public void interact(Listener var1);
    }
}

