/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.widgets;

import com.mathworks.mlwidgets.explorer.util.ExplicitColorAndFontProvider;
import com.mathworks.mwswing.MJEditorPane;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.Disposable;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.tree.ComponentTree;
import com.mathworks.util.tree.Tree;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.util.tree.VisitStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;

public class ComponentPreferenceUtils {
    private static final Predicate<Component> MANAGED = new ManagedPredicate();
    private static final Predicate<Component> NOT_EXCLUDED = new NotExcludedPredicate();
    private static final Collection<Class<?>> MANAGED_COMPONENT_TYPES = new CopyOnWriteArrayList();

    public static void addManagedComponentType(Class<? extends Component> clazz) {
        MANAGED_COMPONENT_TYPES.add(clazz);
    }

    private ComponentPreferenceUtils() {
    }

    public static Disposable manage(Container container) {
        ParameterRunnable<Component> parameterRunnable = new ParameterRunnable<Component>(){

            public void run(Component component) {
                Color color = ColorPrefs.getBackgroundColor();
                Color color2 = ColorPrefs.getTextColor();
                component.setBackground(color);
                component.setForeground(color2);
                if (component instanceof MJEditorPane) {
                    ((MJEditorPane)component).setBackgroundColor(color);
                    ((MJEditorPane)component).setFontColor(color2);
                }
            }
        };
        final PreferenceListener preferenceListener = new PreferenceListener(container, (ParameterRunnable)parameterRunnable);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)preferenceListener);
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)preferenceListener);
        ComponentPreferenceUtils.manage(container, parameterRunnable);
        return new Disposable(){

            public void dispose() {
                ColorPrefs.removeColorListener((String)"ColorsBackground", (PrefListener)preferenceListener);
                ColorPrefs.removeColorListener((String)"ColorsText", (PrefListener)preferenceListener);
            }
        };
    }

    private static void manage(Container container, final ParameterRunnable<Component> parameterRunnable) {
        ContainerListener containerListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                for (Container container : ComponentPreferenceUtils.findContainers(containerEvent.getChild())) {
                    container.removeContainerListener(this);
                    container.addContainerListener(this);
                }
                ComponentPreferenceUtils.runRecursively((Container)containerEvent.getChild(), (ParameterRunnable<Component>)parameterRunnable);
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                for (Container container : ComponentPreferenceUtils.findContainers(containerEvent.getChild())) {
                    container.removeContainerListener(this);
                }
            }
        };
        for (Container container2 : ComponentPreferenceUtils.findContainers(container)) {
            container2.addContainerListener(containerListener);
        }
        ComponentPreferenceUtils.runRecursively(container, parameterRunnable);
    }

    private static void runRecursively(Container container, ParameterRunnable<Component> parameterRunnable) {
        Collection<Component> collection = ComponentPreferenceUtils.hasManagedAncestor(container) ? ComponentPreferenceUtils.findAllChildren(container) : ComponentPreferenceUtils.findComponents(container);
        for (Component component : collection) {
            parameterRunnable.run((Object)component);
        }
    }

    private static boolean hasManagedAncestor(Component component) {
        while (component != null) {
            if (component instanceof ManagedComponent) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    private static Collection<Container> findContainers(Component component) {
        Tree tree = TreeUtils.subtree((Tree)ComponentTree.getInstance((Component)component), (Object)component);
        return TreeUtils.find((Tree)tree, (VisitStrategy)new VisitStrategy(NOT_EXCLUDED, TreeUtils.instanceOf(Container.class)), new HashSet());
    }

    private static Collection<Component> findAllChildren(Component component) {
        Tree tree = TreeUtils.subtree((Tree)ComponentTree.getInstance((Component)component), (Object)component);
        return TreeUtils.find((Tree)tree, (VisitStrategy)new VisitStrategy(NOT_EXCLUDED, NOT_EXCLUDED), new HashSet());
    }

    private static Collection<Component> findComponents(Container container) {
        Tree tree = TreeUtils.subtree((Tree)ComponentTree.getInstance((Component)container), (Object)container);
        final HashSet hashSet = new HashSet();
        return TreeUtils.find((Tree)tree, (VisitStrategy)new VisitStrategy((Predicate)new Predicate<Component>(){

            public boolean accept(Component component) {
                if (component instanceof ManagedComponent) {
                    hashSet.addAll(ComponentPreferenceUtils.findAllChildren(component));
                    return false;
                }
                return NOT_EXCLUDED.accept((Object)component);
            }
        }, TreeUtils.and((Predicate[])new Predicate[]{MANAGED, NOT_EXCLUDED})), hashSet);
    }

    static {
        MANAGED_COMPONENT_TYPES.add(JTextComponent.class);
        MANAGED_COMPONENT_TYPES.add(JList.class);
        MANAGED_COMPONENT_TYPES.add(JTable.class);
        MANAGED_COMPONENT_TYPES.add(JTree.class);
        MANAGED_COMPONENT_TYPES.add(ManagedComponent.class);
    }

    public static interface ManagedComponent {
    }

    private static class PreferenceListener
    implements PrefListener {
        private final Container fParent;
        private final ParameterRunnable<Component> fCode;

        private PreferenceListener(Container container, ParameterRunnable<Component> parameterRunnable) {
            this.fParent = container;
            this.fCode = parameterRunnable;
        }

        public void prefChanged(PrefEvent prefEvent) {
            ComponentPreferenceUtils.runRecursively(this.fParent, (ParameterRunnable<Component>)this.fCode);
        }
    }

    private static class ManagedPredicate
    implements Predicate<Component> {
        private ManagedPredicate() {
        }

        public boolean accept(Component component) {
            Class clazz;
            Class<?> clazz2 = component.getClass();
            boolean bl = false;
            Iterator iterator = MANAGED_COMPONENT_TYPES.iterator();
            while (iterator.hasNext() && !(bl = (clazz = (Class)iterator.next()).isAssignableFrom(clazz2))) {
            }
            return bl && !(component instanceof MJMultilineLabel);
        }
    }

    private static class NotExcludedPredicate
    implements Predicate<Component> {
        private NotExcludedPredicate() {
        }

        public boolean accept(Component component) {
            return !(component instanceof JButton) && !(component instanceof JScrollBar) && !(component.getParent() instanceof JTable) && !(component instanceof JTableHeader) && !(component.getParent() instanceof JList) && !(component instanceof JToolBar) && !(component instanceof JComboBox) && !(component instanceof JProgressBar) && !(component instanceof ExplicitColorAndFontProvider);
        }
    }
}

