/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.accessibility.fo;

import java.util.Locale;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.fo.flow.Wrapper;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class StructureTreeEventTrigger
extends FOEventHandler {
    private StructureTreeEventHandler structureTreeEventHandler;

    public StructureTreeEventTrigger(StructureTreeEventHandler structureTreeEventHandler) {
        this.structureTreeEventHandler = structureTreeEventHandler;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPageSequence(PageSequence pageSequence) {
        Locale locale = null;
        if (pageSequence.getLanguage() != null) {
            locale = pageSequence.getCountry() != null ? new Locale(pageSequence.getLanguage(), pageSequence.getCountry()) : new Locale(pageSequence.getLanguage());
        }
        String string = pageSequence.getCommonAccessibility().getRole();
        this.structureTreeEventHandler.startPageSequence(locale, string);
    }

    public void endPageSequence(PageSequence pageSequence) {
        this.structureTreeEventHandler.endPageSequence();
    }

    public void startPageNumber(PageNumber pageNumber) {
        this.startElementWithID(pageNumber);
    }

    public void endPageNumber(PageNumber pageNumber) {
        this.endElement(pageNumber);
    }

    public void startPageNumberCitation(PageNumberCitation pageNumberCitation) {
        this.startElementWithID(pageNumberCitation);
    }

    public void endPageNumberCitation(PageNumberCitation pageNumberCitation) {
        this.endElement(pageNumberCitation);
    }

    public void startPageNumberCitationLast(PageNumberCitationLast pageNumberCitationLast) {
        this.startElementWithID(pageNumberCitationLast);
    }

    public void endPageNumberCitationLast(PageNumberCitationLast pageNumberCitationLast) {
        this.endElement(pageNumberCitationLast);
    }

    public void startFlow(Flow flow) {
        this.startElement(flow);
    }

    public void endFlow(Flow flow) {
        this.endElement(flow);
    }

    public void startBlock(Block block) {
        this.startElement(block);
    }

    public void endBlock(Block block) {
        this.endElement(block);
    }

    public void startBlockContainer(BlockContainer blockContainer) {
        this.startElement(blockContainer);
    }

    public void endBlockContainer(BlockContainer blockContainer) {
        this.endElement(blockContainer);
    }

    public void startInline(Inline inline) {
        this.startElement(inline);
    }

    public void endInline(Inline inline) {
        this.endElement(inline);
    }

    public void startTable(Table table) {
        this.startElement(table);
    }

    public void endTable(Table table) {
        this.endElement(table);
    }

    public void startHeader(TableHeader tableHeader) {
        this.startElement(tableHeader);
    }

    public void endHeader(TableHeader tableHeader) {
        this.endElement(tableHeader);
    }

    public void startFooter(TableFooter tableFooter) {
        this.startElement(tableFooter);
    }

    public void endFooter(TableFooter tableFooter) {
        this.endElement(tableFooter);
    }

    public void startBody(TableBody tableBody) {
        this.startElement(tableBody);
    }

    public void endBody(TableBody tableBody) {
        this.endElement(tableBody);
    }

    public void startRow(TableRow tableRow) {
        this.startElement(tableRow);
    }

    public void endRow(TableRow tableRow) {
        this.endElement(tableRow);
    }

    public void startCell(TableCell tableCell) {
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = tableCell.getNumberColumnsSpanned();
        if (n > 1) {
            this.addNoNamespaceAttribute(attributesImpl, "number-columns-spanned", Integer.toString(n));
        }
        this.startElement(tableCell, attributesImpl);
    }

    public void endCell(TableCell tableCell) {
        this.endElement(tableCell);
    }

    public void startList(ListBlock listBlock) {
        this.startElement(listBlock);
    }

    public void endList(ListBlock listBlock) {
        this.endElement(listBlock);
    }

    public void startListItem(ListItem listItem) {
        this.startElement(listItem);
    }

    public void endListItem(ListItem listItem) {
        this.endElement(listItem);
    }

    public void startListLabel(ListItemLabel listItemLabel) {
        this.startElement(listItemLabel);
    }

    public void endListLabel(ListItemLabel listItemLabel) {
        this.endElement(listItemLabel);
    }

    public void startListBody(ListItemBody listItemBody) {
        this.startElement(listItemBody);
    }

    public void endListBody(ListItemBody listItemBody) {
        this.endElement(listItemBody);
    }

    public void startStatic(StaticContent staticContent) {
        this.startElement(staticContent);
    }

    public void endStatic(StaticContent staticContent) {
        this.endElement(staticContent);
    }

    public void startLink(BasicLink basicLink) {
        this.startElementWithID(basicLink);
    }

    public void endLink(BasicLink basicLink) {
        this.endElement(basicLink);
    }

    public void image(ExternalGraphic externalGraphic) {
        this.startElementWithIDAndAltText(externalGraphic);
        this.endElement(externalGraphic);
    }

    public void startInstreamForeignObject(InstreamForeignObject instreamForeignObject) {
        this.startElementWithIDAndAltText(instreamForeignObject);
    }

    public void endInstreamForeignObject(InstreamForeignObject instreamForeignObject) {
        this.endElement(instreamForeignObject);
    }

    public void startFootnote(Footnote footnote) {
        this.startElement(footnote);
    }

    public void endFootnote(Footnote footnote) {
        this.endElement(footnote);
    }

    public void startFootnoteBody(FootnoteBody footnoteBody) {
        this.startElement(footnoteBody);
    }

    public void endFootnoteBody(FootnoteBody footnoteBody) {
        this.endElement(footnoteBody);
    }

    public void startWrapper(Wrapper wrapper) {
        this.startElement(wrapper);
    }

    public void endWrapper(Wrapper wrapper) {
        this.endElement(wrapper);
    }

    public void character(Character character) {
        this.startElementWithID(character);
        this.endElement(character);
    }

    public void characters(FOText fOText) {
        this.startElementWithID(fOText);
        this.endElement(fOText);
    }

    private void startElement(FONode fONode) {
        this.startElement(fONode, new AttributesImpl());
    }

    private void startElementWithID(FONode fONode) {
        AttributesImpl attributesImpl = new AttributesImpl();
        String string = fONode.getLocalName();
        if (fONode instanceof CommonAccessibilityHolder) {
            this.addRole((CommonAccessibilityHolder)((Object)fONode), attributesImpl);
        }
        fONode.setStructureTreeElement(this.structureTreeEventHandler.startReferencedNode(string, attributesImpl));
    }

    private void startElementWithIDAndAltText(AbstractGraphics abstractGraphics) {
        AttributesImpl attributesImpl = new AttributesImpl();
        String string = abstractGraphics.getLocalName();
        this.addRole(abstractGraphics, attributesImpl);
        this.addAttribute(attributesImpl, "http://xmlgraphics.apache.org/fop/extensions", "alt-text", "fox", abstractGraphics.getAltText());
        abstractGraphics.setStructureTreeElement(this.structureTreeEventHandler.startImageNode(string, attributesImpl));
    }

    private StructureTreeElement startElement(FONode fONode, AttributesImpl attributesImpl) {
        String string = fONode.getLocalName();
        if (fONode instanceof CommonAccessibilityHolder) {
            this.addRole((CommonAccessibilityHolder)((Object)fONode), attributesImpl);
        }
        return this.structureTreeEventHandler.startNode(string, attributesImpl);
    }

    private void addNoNamespaceAttribute(AttributesImpl attributesImpl, String string, String string2) {
        attributesImpl.addAttribute("", string, string, "CDATA", string2);
    }

    private void addAttribute(AttributesImpl attributesImpl, String string, String string2, String string3, String string4) {
        assert (string.length() > 0 && string3.length() > 0);
        String string5 = string3 + ":" + string2;
        attributesImpl.addAttribute(string, string2, string5, "CDATA", string4);
    }

    private void addRole(CommonAccessibilityHolder commonAccessibilityHolder, AttributesImpl attributesImpl) {
        String string = commonAccessibilityHolder.getCommonAccessibility().getRole();
        if (string != null) {
            this.addNoNamespaceAttribute(attributesImpl, "role", string);
        }
    }

    private void endElement(FONode fONode) {
        String string = fONode.getLocalName();
        this.structureTreeEventHandler.endNode(string);
    }
}

