/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.awt.Point;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.afp.GrayScaleColorConverter;
import org.apache.fop.afp.fonts.AFPPageFonts;
import org.apache.fop.util.AbstractPaintingState;
import org.apache.xmlgraphics.java2d.color.ColorConverter;
import org.apache.xmlgraphics.java2d.color.DefaultColorConverter;

public class AFPPaintingState
extends AbstractPaintingState
implements Cloneable {
    private static final long serialVersionUID = 8206711712452344473L;
    private static Log log = LogFactory.getLog((String)"org.apache.xmlgraphics.afp");
    private int portraitRotation = 0;
    private int landscapeRotation = 270;
    private boolean colorImages = false;
    private float ditheringQuality;
    private float bitmapEncodingQuality;
    private ColorConverter colorConverter = GrayScaleColorConverter.getInstance();
    private boolean nativeImagesSupported = false;
    private boolean canEmbedJpeg = false;
    private boolean cmykImagesSupported;
    private int bitsPerPixel = 8;
    private int resolution = 240;
    private float lineWidthCorrection = 2.5f;
    private boolean gocaEnabled = true;
    private boolean strokeGocaText = false;
    private boolean pSeg;
    private boolean fs45;
    private transient AFPPagePaintingState pagePaintingState = new AFPPagePaintingState();
    private final transient AFPUnitConverter unitConv = new AFPUnitConverter(this);

    public void setPortraitRotation(int n) {
        if (n != 0 && n != 90 && n != 180 && n != 270) {
            throw new IllegalArgumentException("The portrait rotation must be one of the values 0, 90, 180, 270");
        }
        this.portraitRotation = n;
    }

    protected int getPortraitRotation() {
        return this.portraitRotation;
    }

    public void setLandscapeRotation(int n) {
        if (n != 0 && n != 90 && n != 180 && n != 270) {
            throw new IllegalArgumentException("The landscape rotation must be one of the values 0, 90, 180, 270");
        }
        this.landscapeRotation = n;
    }

    protected int getLandscapeRotation() {
        return this.landscapeRotation;
    }

    public void setBitsPerPixel(int n) {
        switch (n) {
            case 1: 
            case 4: 
            case 8: {
                this.bitsPerPixel = n;
                break;
            }
            default: {
                log.warn((Object)"Invalid bits_per_pixel value, must be 1, 4 or 8.");
                this.bitsPerPixel = 8;
            }
        }
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public void setColorImages(boolean bl) {
        this.colorImages = bl;
        if (bl) {
            this.colorConverter = DefaultColorConverter.getInstance();
        }
    }

    public boolean isColorImages() {
        return this.colorImages;
    }

    public ColorConverter getColorConverter() {
        return this.colorConverter;
    }

    public void setNativeImagesSupported(boolean bl) {
        this.nativeImagesSupported = bl;
    }

    public boolean isNativeImagesSupported() {
        return this.nativeImagesSupported;
    }

    public void setCanEmbedJpeg(boolean bl) {
        this.canEmbedJpeg = bl;
    }

    public boolean canEmbedJpeg() {
        return this.canEmbedJpeg;
    }

    public void setCMYKImagesSupported(boolean bl) {
        this.cmykImagesSupported = bl;
    }

    public boolean isCMYKImagesSupported() {
        return this.cmykImagesSupported;
    }

    public float getDitheringQuality() {
        return this.ditheringQuality;
    }

    public void setDitheringQuality(float f) {
        f = Math.max(f, 0.0f);
        this.ditheringQuality = f = Math.min(f, 1.0f);
    }

    public float getBitmapEncodingQuality() {
        return this.bitmapEncodingQuality;
    }

    public void setBitmapEncodingQuality(float f) {
        f = Math.max(f, 0.0f);
        this.bitmapEncodingQuality = f = Math.min(f, 1.0f);
    }

    public void setResolution(int n) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("renderer-resolution set to: " + n + "dpi"));
        }
        this.resolution = n;
    }

    public void setLineWidthCorrection(float f) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("line width correction set to: " + f));
        }
        this.lineWidthCorrection = f;
    }

    public int getResolution() {
        return this.resolution;
    }

    public float getLineWidthCorrection() {
        return this.lineWidthCorrection;
    }

    public void setGOCAEnabled(boolean bl) {
        this.gocaEnabled = bl;
    }

    public boolean isGOCAEnabled() {
        return this.gocaEnabled;
    }

    public void setStrokeGOCAText(boolean bl) {
        this.strokeGocaText = bl;
    }

    public boolean isStrokeGOCAText() {
        return this.strokeGocaText;
    }

    public boolean getWrapPSeg() {
        return this.pSeg;
    }

    public void setWrapPSeg(boolean bl) {
        this.pSeg = bl;
    }

    public boolean getFS45() {
        return this.fs45;
    }

    public void setFS45(boolean bl) {
        this.fs45 = bl;
    }

    protected AbstractPaintingState.AbstractData instantiateData() {
        return new AFPData();
    }

    protected AbstractPaintingState instantiate() {
        return new AFPPaintingState();
    }

    protected AFPPagePaintingState getPagePaintingState() {
        return this.pagePaintingState;
    }

    public AFPPageFonts getPageFonts() {
        return this.pagePaintingState.getFonts();
    }

    public void setPageWidth(int n) {
        this.pagePaintingState.setWidth(n);
    }

    public int getPageWidth() {
        return this.pagePaintingState.getWidth();
    }

    public void setPageHeight(int n) {
        this.pagePaintingState.setHeight(n);
    }

    public int getPageHeight() {
        return this.pagePaintingState.getHeight();
    }

    public int getPageRotation() {
        return this.pagePaintingState.getOrientation();
    }

    public void setImageUri(String string) {
        ((AFPData)this.getData()).imageUri = string;
    }

    public String getImageUri() {
        return ((AFPData)this.getData()).imageUri;
    }

    public int getRotation() {
        return this.getData().getDerivedRotation();
    }

    public AFPUnitConverter getUnitConverter() {
        return this.unitConv;
    }

    public Point getPoint(int n, int n2) {
        Point point = new Point();
        int n3 = this.getRotation();
        switch (n3) {
            case 90: {
                point.x = n2;
                point.y = this.getPageWidth() - n;
                break;
            }
            case 180: {
                point.x = this.getPageWidth() - n;
                point.y = this.getPageHeight() - n2;
                break;
            }
            case 270: {
                point.x = this.getPageHeight() - n2;
                point.y = n;
                break;
            }
            default: {
                point.x = n;
                point.y = n2;
            }
        }
        return point;
    }

    public Object clone() {
        AFPPaintingState aFPPaintingState = (AFPPaintingState)super.clone();
        aFPPaintingState.pagePaintingState = (AFPPagePaintingState)this.pagePaintingState.clone();
        aFPPaintingState.portraitRotation = this.portraitRotation;
        aFPPaintingState.landscapeRotation = this.landscapeRotation;
        aFPPaintingState.bitsPerPixel = this.bitsPerPixel;
        aFPPaintingState.colorImages = this.colorImages;
        aFPPaintingState.colorConverter = this.colorConverter;
        aFPPaintingState.resolution = this.resolution;
        return aFPPaintingState;
    }

    public String toString() {
        return "AFPPaintingState{portraitRotation=" + this.portraitRotation + ", landscapeRotation=" + this.landscapeRotation + ", colorImages=" + this.colorImages + ", bitsPerPixel=" + this.bitsPerPixel + ", resolution=" + this.resolution + ", pageState=" + this.pagePaintingState + super.toString() + "}";
    }

    private class AFPData
    extends AbstractPaintingState.AbstractData {
        private static final long serialVersionUID = -1789481244175275686L;
        private boolean filled;
        private String imageUri;

        private AFPData() {
            super(AFPPaintingState.this);
            this.filled = false;
            this.imageUri = null;
        }

        public Object clone() {
            AFPData aFPData = (AFPData)super.clone();
            aFPData.filled = this.filled;
            aFPData.imageUri = this.imageUri;
            return aFPData;
        }

        public String toString() {
            return "AFPData{" + super.toString() + ", filled=" + this.filled + ", imageUri=" + this.imageUri + "}";
        }

        protected AbstractPaintingState.AbstractData instantiate() {
            return new AFPData();
        }
    }

    private class AFPPagePaintingState
    implements Cloneable {
        private int width = 0;
        private int height = 0;
        private AFPPageFonts fonts = new AFPPageFonts();
        private int fontCount = 0;
        private int orientation = 0;

        private AFPPagePaintingState() {
        }

        protected int getWidth() {
            return this.width;
        }

        protected void setWidth(int n) {
            this.width = n;
        }

        protected int getHeight() {
            return this.height;
        }

        protected void setHeight(int n) {
            this.height = n;
        }

        protected AFPPageFonts getFonts() {
            return this.fonts;
        }

        protected void setFonts(AFPPageFonts aFPPageFonts) {
            this.fonts = aFPPageFonts;
        }

        protected int incrementFontCount() {
            return ++this.fontCount;
        }

        protected int getOrientation() {
            return this.orientation;
        }

        protected void setOrientation(int n) {
            this.orientation = n;
        }

        public Object clone() {
            AFPPagePaintingState aFPPagePaintingState = new AFPPagePaintingState();
            aFPPagePaintingState.width = this.width;
            aFPPagePaintingState.height = this.height;
            aFPPagePaintingState.orientation = this.orientation;
            aFPPagePaintingState.fonts = new AFPPageFonts(this.fonts);
            aFPPagePaintingState.fontCount = this.fontCount;
            return aFPPagePaintingState;
        }

        public String toString() {
            return "AFPPagePaintingState{width=" + this.width + ", height=" + this.height + ", orientation=" + this.orientation + ", fonts=" + this.fonts + ", fontCount=" + this.fontCount + "}";
        }
    }
}

