/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.awt.geom.AffineTransform;
import org.apache.fop.afp.AFPLineDataInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.afp.AbstractAFPPainter;
import org.apache.fop.afp.DataStream;
import org.apache.fop.afp.PaintingInfo;
import org.apache.fop.afp.RectanglePaintingInfo;

public class AFPRectanglePainter
extends AbstractAFPPainter {
    public AFPRectanglePainter(AFPPaintingState aFPPaintingState, DataStream dataStream) {
        super(aFPPaintingState, dataStream);
    }

    public void paint(PaintingInfo paintingInfo) {
        RectanglePaintingInfo rectanglePaintingInfo = (RectanglePaintingInfo)paintingInfo;
        int n = this.dataStream.getCurrentPage().getWidth();
        int n2 = this.dataStream.getCurrentPage().getHeight();
        AFPUnitConverter aFPUnitConverter = this.paintingState.getUnitConverter();
        float f = aFPUnitConverter.pt2units(rectanglePaintingInfo.getWidth());
        float f2 = aFPUnitConverter.pt2units(rectanglePaintingInfo.getHeight());
        float f3 = aFPUnitConverter.pt2units(rectanglePaintingInfo.getX());
        float f4 = aFPUnitConverter.pt2units(rectanglePaintingInfo.getY());
        AffineTransform affineTransform = this.paintingState.getData().getTransform();
        AFPLineDataInfo aFPLineDataInfo = new AFPLineDataInfo();
        aFPLineDataInfo.setColor(this.paintingState.getColor());
        aFPLineDataInfo.setRotation(this.paintingState.getRotation());
        aFPLineDataInfo.setThickness(Math.round(f2));
        switch (aFPLineDataInfo.getRotation()) {
            case 90: {
                aFPLineDataInfo.setX1(Math.round((float)affineTransform.getTranslateY() + f3));
                int n3 = n - Math.round((float)affineTransform.getTranslateX()) + Math.round(f4);
                aFPLineDataInfo.setY1(n3);
                aFPLineDataInfo.setY2(n3);
                aFPLineDataInfo.setX2(Math.round(f + (float)affineTransform.getTranslateY() + f3));
                break;
            }
            case 180: {
                aFPLineDataInfo.setX1(n - Math.round((float)affineTransform.getTranslateX() - f3));
                int n4 = n2 - Math.round((float)affineTransform.getTranslateY() - f4);
                aFPLineDataInfo.setY1(n4);
                aFPLineDataInfo.setY2(n4);
                aFPLineDataInfo.setX2(n - Math.round((float)affineTransform.getTranslateX() - f3 - f));
                break;
            }
            case 270: {
                aFPLineDataInfo.setX1(n2 - Math.round((float)affineTransform.getTranslateY() - f3));
                int n5 = Math.round((float)affineTransform.getTranslateX() + f4);
                aFPLineDataInfo.setY1(n5);
                aFPLineDataInfo.setY2(n5);
                aFPLineDataInfo.setX2(n2 - Math.round((float)affineTransform.getTranslateY() - f3 - f));
                break;
            }
            default: {
                aFPLineDataInfo.setX1(Math.round((float)affineTransform.getTranslateX() + f3));
                int n6 = Math.round((float)affineTransform.getTranslateY() + f4);
                aFPLineDataInfo.setY1(n6);
                aFPLineDataInfo.setY2(n6);
                aFPLineDataInfo.setX2(Math.round((float)affineTransform.getTranslateX() + f3 + f));
            }
        }
        this.dataStream.createLine(aFPLineDataInfo);
    }
}

