/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

public class AFPResourceLevel {
    public static final int INLINE = 0;
    public static final int PAGE = 1;
    public static final int PAGE_GROUP = 2;
    public static final int DOCUMENT = 3;
    public static final int PRINT_FILE = 4;
    public static final int EXTERNAL = 5;
    private static final String NAME_INLINE = "inline";
    private static final String NAME_PAGE = "page";
    private static final String NAME_PAGE_GROUP = "page-group";
    private static final String NAME_DOCUMENT = "document";
    private static final String NAME_PRINT_FILE = "print-file";
    private static final String NAME_EXTERNAL = "external";
    private static final String[] NAMES = new String[]{"inline", "page", "page-group", "document", "print-file", "external"};
    private int level = 4;
    private String extFilePath = null;

    public static AFPResourceLevel valueOf(String string) {
        if (string != null) {
            string = string.toLowerCase();
            AFPResourceLevel aFPResourceLevel = null;
            for (int i = 0; i < NAMES.length; ++i) {
                if (!NAMES[i].equals(string)) continue;
                aFPResourceLevel = new AFPResourceLevel(i);
                break;
            }
            return aFPResourceLevel;
        }
        return null;
    }

    public AFPResourceLevel(int n) {
        this.setLevel(n);
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public boolean isPage() {
        return this.level == 1;
    }

    public boolean isPageGroup() {
        return this.level == 2;
    }

    public boolean isDocument() {
        return this.level == 3;
    }

    public boolean isExternal() {
        return this.level == 5;
    }

    public boolean isPrintFile() {
        return this.level == 4;
    }

    public boolean isInline() {
        return this.level == 0;
    }

    public String getExternalFilePath() {
        return this.extFilePath;
    }

    public void setExternalFilePath(String string) {
        this.extFilePath = string;
    }

    public String toString() {
        return NAMES[this.level] + (this.isExternal() ? ", file=" + this.extFilePath : "");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AFPResourceLevel)) {
            return false;
        }
        AFPResourceLevel aFPResourceLevel = (AFPResourceLevel)object;
        return this.level == aFPResourceLevel.level && (this.extFilePath == aFPResourceLevel.extFilePath || this.extFilePath != null && this.extFilePath.equals(aFPResourceLevel.extFilePath));
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + this.level;
        n = 31 * n + (null == this.extFilePath ? 0 : this.extFilePath.hashCode());
        return n;
    }
}

