/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.awt.geom.AffineTransform;
import org.apache.fop.afp.AFPPaintingState;

public class AFPUnitConverter {
    private final AFPPaintingState paintingState;

    public AFPUnitConverter(AFPPaintingState aFPPaintingState) {
        this.paintingState = aFPPaintingState;
    }

    public int[] mpts2units(float[] fArray, float[] fArray2) {
        return this.transformPoints(fArray, fArray2, true);
    }

    public int[] pts2units(float[] fArray, float[] fArray2) {
        return this.transformPoints(fArray, fArray2, false);
    }

    public int[] mpts2units(float[] fArray) {
        return this.transformPoints(fArray, null, true);
    }

    public int[] pts2units(float[] fArray) {
        return this.transformPoints(fArray, null, false);
    }

    public float pt2units(float f) {
        return f / (72.0f / (float)this.paintingState.getResolution());
    }

    public float mpt2units(float f) {
        return f / (72000.0f / (float)this.paintingState.getResolution());
    }

    private int[] transformPoints(float[] fArray, float[] fArray2, boolean bl) {
        if (fArray2 == null) {
            fArray2 = new float[fArray.length];
        }
        AffineTransform affineTransform = this.paintingState.getData().getTransform();
        affineTransform.transform(fArray, 0, fArray2, 0, fArray.length / 2);
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            if (!bl) {
                int n = i;
                fArray2[n] = fArray2[n] * 1000.0f;
            }
            nArray[i] = Math.round(fArray2[i]);
        }
        return nArray;
    }
}

