/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPLineDataInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.AFPTextDataInfo;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.AFPFontAttributes;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.modca.AbstractPageObject;
import org.apache.fop.afp.modca.Document;
import org.apache.fop.afp.modca.InterchangeSet;
import org.apache.fop.afp.modca.Overlay;
import org.apache.fop.afp.modca.PageGroup;
import org.apache.fop.afp.modca.PageObject;
import org.apache.fop.afp.modca.ResourceGroup;
import org.apache.fop.afp.modca.TagLogicalElementBean;
import org.apache.fop.afp.ptoca.PtocaBuilder;
import org.apache.fop.afp.ptoca.PtocaProducer;
import org.apache.fop.fonts.Font;
import org.apache.fop.util.CharUtilities;

public class DataStream {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.xmlgraphics.afp");
    private boolean complete = false;
    private Document document = null;
    private PageGroup currentPageGroup = null;
    private PageObject currentPageObject = null;
    private Overlay currentOverlay = null;
    private AbstractPageObject currentPage = null;
    private int tleSequence = 0;
    private InterchangeSet interchangeSet = InterchangeSet.valueOf("MO:DCA-P IS/2");
    private final Factory factory;
    private OutputStream outputStream;
    private final AFPPaintingState paintingState;

    public DataStream(Factory factory, AFPPaintingState aFPPaintingState, OutputStream outputStream) {
        this.paintingState = aFPPaintingState;
        this.factory = factory;
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private Document getDocument() {
        return this.document;
    }

    public AbstractPageObject getCurrentPage() {
        return this.currentPage;
    }

    public void setDocumentName(String string) {
        if (string != null) {
            this.getDocument().setFullyQualifiedName((byte)-125, (byte)0, string);
        }
    }

    public void endDocument() throws IOException {
        if (this.complete) {
            String string = "Invalid state - document already ended.";
            LOG.warn((Object)("endDocument():: " + string));
            throw new IllegalStateException(string);
        }
        if (this.currentPageObject != null) {
            this.endPage();
        }
        if (this.currentPageGroup != null) {
            this.endPageGroup();
        }
        if (this.document != null) {
            this.document.endDocument();
            this.document.writeToStream(this.outputStream);
        }
        this.outputStream.flush();
        this.complete = true;
        this.document = null;
        this.outputStream = null;
    }

    public void startPage(int n, int n2, int n3, int n4, int n5) {
        this.currentPageObject = this.factory.createPage(n, n2, n3, n4, n5);
        this.currentPage = this.currentPageObject;
        this.currentOverlay = null;
    }

    public void startOverlay(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.currentOverlay = this.factory.createOverlay(n3, n4, n5, n6, n7);
        String string = this.currentOverlay.getName();
        this.currentPageObject.createIncludePageOverlay(string, n, n2, 0);
        this.currentPage = this.currentOverlay;
    }

    public void endOverlay() throws IOException {
        if (this.currentOverlay != null) {
            this.currentOverlay.endPage();
            this.currentOverlay = null;
            this.currentPage = this.currentPageObject;
        }
    }

    public PageObject savePage() {
        PageObject pageObject = this.currentPageObject;
        if (this.currentPageGroup != null) {
            this.currentPageGroup.addPage(this.currentPageObject);
        } else {
            this.document.addPage(this.currentPageObject);
        }
        this.currentPageObject = null;
        this.currentPage = null;
        return pageObject;
    }

    public void restorePage(PageObject pageObject) {
        this.currentPageObject = pageObject;
        this.currentPage = pageObject;
    }

    public void endPage() throws IOException {
        if (this.currentPageObject != null) {
            this.currentPageObject.endPage();
            if (this.currentPageGroup != null) {
                this.currentPageGroup.addPage(this.currentPageObject);
                this.currentPageGroup.writeToStream(this.outputStream);
            } else {
                this.document.addPage(this.currentPageObject);
                this.document.writeToStream(this.outputStream);
            }
            this.currentPageObject = null;
            this.currentPage = null;
        }
    }

    public void addFontsToCurrentPage(Map map) {
        for (AFPFontAttributes aFPFontAttributes : map.values()) {
            this.createFont(aFPFontAttributes.getFontReference(), aFPFontAttributes.getFont(), aFPFontAttributes.getPointSize());
        }
    }

    public void createFont(int n, AFPFont aFPFont, int n2) {
        this.currentPage.createFont(n, aFPFont, n2);
    }

    private Point getPoint(int n, int n2) {
        return this.paintingState.getPoint(n, n2);
    }

    public void createText(final AFPTextDataInfo aFPTextDataInfo, final int n, final int n2, final Font font, final CharacterSet characterSet) throws UnsupportedEncodingException {
        Object object;
        int n3 = this.paintingState.getRotation();
        if (n3 != 0) {
            aFPTextDataInfo.setRotation(n3);
            object = this.getPoint(aFPTextDataInfo.getX(), aFPTextDataInfo.getY());
            aFPTextDataInfo.setX(((Point)object).x);
            aFPTextDataInfo.setY(((Point)object).y);
        }
        object = new PtocaProducer(){

            public void produce(PtocaBuilder ptocaBuilder) throws IOException {
                int n8;
                ptocaBuilder.setTextOrientation(aFPTextDataInfo.getRotation());
                ptocaBuilder.absoluteMoveBaseline(aFPTextDataInfo.getY());
                ptocaBuilder.absoluteMoveInline(aFPTextDataInfo.getX());
                ptocaBuilder.setExtendedTextColor(aFPTextDataInfo.getColor());
                ptocaBuilder.setCodedFont((byte)aFPTextDataInfo.getFontReference());
                int n22 = aFPTextDataInfo.getString().length();
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                AFPUnitConverter aFPUnitConverter = DataStream.this.paintingState.getUnitConverter();
                if (n != 0) {
                    n3 = Math.round(aFPUnitConverter.mpt2units(n));
                }
                ptocaBuilder.setInterCharacterAdjustment(n3);
                int n4 = font.getCharWidth(' ');
                int n5 = n4 + n;
                int n6 = n8 = Math.round(aFPUnitConverter.mpt2units(n5));
                if (n2 != 0) {
                    n6 = Math.round(aFPUnitConverter.mpt2units(n4 + n2 + n));
                }
                ptocaBuilder.setVariableSpaceCharacterIncrement(n6);
                boolean bl = false;
                for (int i = 0; i < n22; ++i) {
                    int n7;
                    char c = aFPTextDataInfo.getString().charAt(i);
                    float f = 0.0f;
                    if (CharUtilities.isFixedWidthSpace(c)) {
                        this.flushText(ptocaBuilder, stringBuffer, characterSet);
                        ptocaBuilder.setVariableSpaceCharacterIncrement(n8);
                        bl = true;
                        stringBuffer.append(' ');
                        n7 = font.getCharWidth(c);
                        f += (float)(n7 - n4);
                    } else {
                        if (bl) {
                            this.flushText(ptocaBuilder, stringBuffer, characterSet);
                            ptocaBuilder.setVariableSpaceCharacterIncrement(n6);
                            bl = false;
                        }
                        n7 = c == '\u00a0' ? 32 : (int)c;
                        stringBuffer.append((char)n7);
                    }
                    if (f == 0.0f) continue;
                    this.flushText(ptocaBuilder, stringBuffer, characterSet);
                    n7 = Math.round(aFPUnitConverter.mpt2units(f));
                    ptocaBuilder.relativeMoveInline(n7);
                }
                this.flushText(ptocaBuilder, stringBuffer, characterSet);
            }

            private void flushText(PtocaBuilder ptocaBuilder, StringBuffer stringBuffer, CharacterSet characterSet2) throws IOException {
                if (stringBuffer.length() > 0) {
                    ptocaBuilder.addTransparentData(characterSet2.encodeChars(stringBuffer));
                    stringBuffer.setLength(0);
                }
            }
        };
        this.currentPage.createText((PtocaProducer)object);
    }

    public void createLine(AFPLineDataInfo aFPLineDataInfo) {
        this.currentPage.createLine(aFPLineDataInfo);
    }

    public void createShading(int n, int n2, int n3, int n4, Color color) {
        this.currentPageObject.createShading(n, n2, n3, n4, color.getRed(), color.getGreen(), color.getBlue());
    }

    public void createIncludePageOverlay(String string, int n, int n2) {
        this.currentPageObject.createIncludePageOverlay(string, n, n2, this.paintingState.getRotation());
        this.currentPageObject.getActiveEnvironmentGroup().createOverlay(string);
    }

    public void createInvokeMediumMap(String string) {
        this.currentPageGroup.createInvokeMediumMap(string);
    }

    public void createIncludePageSegment(String string, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = this.paintingState.getRotation();
        switch (n7) {
            case 90: {
                n6 = n - n4;
                n5 = n2;
                break;
            }
            case 180: {
                n6 = n - n3;
                n5 = n2 - n4;
                break;
            }
            case 270: {
                n6 = n;
                n5 = n2 - n3;
                break;
            }
            default: {
                n6 = n;
                n5 = n2;
            }
        }
        boolean bl = true;
        this.currentPage.createIncludePageSegment(string, n6, n5, bl);
    }

    public void createPageTagLogicalElement(TagLogicalElementBean[] tagLogicalElementBeanArray) {
        for (int i = 0; i < tagLogicalElementBeanArray.length; ++i) {
            String string = tagLogicalElementBeanArray[i].getKey();
            String string2 = tagLogicalElementBeanArray[i].getValue();
            this.currentPage.createTagLogicalElement(string, string2, this.tleSequence++);
        }
    }

    public void createPageGroupTagLogicalElement(TagLogicalElementBean[] tagLogicalElementBeanArray) {
        for (int i = 0; i < tagLogicalElementBeanArray.length; ++i) {
            String string = tagLogicalElementBeanArray[i].getKey();
            String string2 = tagLogicalElementBeanArray[i].getValue();
            this.currentPageGroup.createTagLogicalElement(string, string2);
        }
    }

    public void createTagLogicalElement(String string, String string2) {
        if (this.currentPage != null) {
            this.currentPage.createTagLogicalElement(string, string2, this.tleSequence++);
        } else {
            this.currentPageGroup.createTagLogicalElement(string, string2);
        }
    }

    public void createNoOperation(String string) {
        if (this.currentPage != null) {
            this.currentPage.createNoOperation(string);
        } else if (this.currentPageGroup != null) {
            this.currentPageGroup.createNoOperation(string);
        } else {
            this.document.createNoOperation(string);
        }
    }

    public PageGroup getCurrentPageGroup() {
        return this.currentPageGroup;
    }

    public void startDocument() throws IOException {
        this.document = this.factory.createDocument();
        this.document.writeToStream(this.outputStream);
    }

    public void startPageGroup() throws IOException {
        this.endPageGroup();
        this.currentPageGroup = this.factory.createPageGroup(this.tleSequence);
    }

    public void endPageGroup() throws IOException {
        if (this.currentPageGroup != null) {
            this.currentPageGroup.endPageGroup();
            this.tleSequence = this.currentPageGroup.getTleSequence();
            this.document.addPageGroup(this.currentPageGroup);
            this.currentPageGroup = null;
        }
        this.document.writeToStream(this.outputStream);
    }

    public void setInterchangeSet(InterchangeSet interchangeSet) {
        this.interchangeSet = interchangeSet;
    }

    public InterchangeSet getInterchangeSet() {
        return this.interchangeSet;
    }

    public ResourceGroup getResourceGroup(AFPResourceLevel aFPResourceLevel) {
        ResourceGroup resourceGroup = null;
        if (aFPResourceLevel.isDocument()) {
            resourceGroup = this.document.getResourceGroup();
        } else if (aFPResourceLevel.isPageGroup()) {
            resourceGroup = this.currentPageGroup.getResourceGroup();
        } else if (aFPResourceLevel.isPage()) {
            resourceGroup = this.currentPageObject.getResourceGroup();
        }
        return resourceGroup;
    }
}

