/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.util.List;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.fonts.AFPBase12FontCollection;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.AFPFontInfo;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AFPFontCollection
implements FontCollection {
    private final AFPEventProducer eventProducer;
    private final List<AFPFontInfo> fontInfoList;

    public AFPFontCollection(EventBroadcaster eventBroadcaster, List<AFPFontInfo> list) {
        this.eventProducer = AFPEventProducer.Provider.get(eventBroadcaster);
        this.fontInfoList = list;
    }

    @Override
    public int setup(int n, FontInfo fontInfo) {
        int n2 = 1;
        if (this.fontInfoList != null && this.fontInfoList.size() > 0) {
            for (AFPFontInfo aFPFontInfo : this.fontInfoList) {
                AFPFont aFPFont = aFPFontInfo.getAFPFont();
                List<FontTriplet> list = aFPFontInfo.getFontTriplets();
                for (FontTriplet fontTriplet : list) {
                    fontInfo.addMetrics("F" + n2, aFPFont);
                    fontInfo.addFontProperties("F" + n2, fontTriplet.getName(), fontTriplet.getStyle(), fontTriplet.getWeight());
                    ++n2;
                }
            }
            this.checkDefaultFontAvailable(fontInfo, "normal", 400);
            this.checkDefaultFontAvailable(fontInfo, "italic", 400);
            this.checkDefaultFontAvailable(fontInfo, "normal", 700);
            this.checkDefaultFontAvailable(fontInfo, "italic", 700);
        } else {
            this.eventProducer.warnDefaultFontSetup(this);
            AFPBase12FontCollection aFPBase12FontCollection = new AFPBase12FontCollection(this.eventProducer);
            n2 = aFPBase12FontCollection.setup(n2, fontInfo);
        }
        return n2;
    }

    private void checkDefaultFontAvailable(FontInfo fontInfo, String string, int n) {
        if (!fontInfo.hasFont("any", string, n)) {
            this.eventProducer.warnMissingDefaultFont(this, string, n);
        }
    }
}

