/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ioca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.util.BinaryUtils;

public class ImageOutputControl
extends AbstractAFPObject {
    private int orientation = 0;
    private int xCoord = 0;
    private int yCoord = 0;
    private boolean singlePoint = true;

    public ImageOutputControl(int n, int n2) {
        this.xCoord = n;
        this.yCoord = n2;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[33];
        byArray[0] = 90;
        byArray[1] = 0;
        byArray[2] = 32;
        byArray[3] = -45;
        byArray[4] = -89;
        byArray[5] = 123;
        byArray[6] = 0;
        byArray[7] = 0;
        byArray[8] = 0;
        byte[] byArray2 = BinaryUtils.convert(this.xCoord, 3);
        byArray[9] = byArray2[0];
        byArray[10] = byArray2[1];
        byArray[11] = byArray2[2];
        byte[] byArray3 = BinaryUtils.convert(this.yCoord, 3);
        byArray[12] = byArray3[0];
        byArray[13] = byArray3[1];
        byArray[14] = byArray3[2];
        switch (this.orientation) {
            case 0: {
                byArray[15] = 0;
                byArray[16] = 0;
                byArray[17] = 45;
                byArray[18] = 0;
                break;
            }
            case 90: {
                byArray[15] = 45;
                byArray[16] = 0;
                byArray[17] = 90;
                byArray[18] = 0;
                break;
            }
            case 180: {
                byArray[15] = 90;
                byArray[16] = 0;
                byArray[17] = -121;
                byArray[18] = 0;
                break;
            }
            case 270: {
                byArray[15] = -121;
                byArray[16] = 0;
                byArray[17] = 0;
                byArray[18] = 0;
                break;
            }
            default: {
                byArray[15] = 0;
                byArray[16] = 0;
                byArray[17] = 45;
                byArray[18] = 0;
            }
        }
        byArray[19] = 0;
        byArray[20] = 0;
        byArray[21] = 0;
        byArray[22] = 0;
        byArray[23] = 0;
        byArray[24] = 0;
        byArray[25] = 0;
        byArray[26] = 0;
        if (this.singlePoint) {
            byArray[27] = 3;
            byArray[28] = -24;
            byArray[29] = 3;
            byArray[30] = -24;
        } else {
            byArray[27] = 7;
            byArray[28] = -48;
            byArray[29] = 7;
            byArray[30] = -48;
        }
        byArray[31] = -1;
        byArray[32] = -1;
        outputStream.write(byArray);
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 90 && n != 180 && n != 270) {
            throw new IllegalArgumentException("The orientation must be one of the values 0, 90, 180, 270");
        }
        this.orientation = n;
    }

    public void setSinglepoint(boolean bl) {
        this.singlePoint = bl;
    }
}

