/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ioca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.ioca.ImageContent;
import org.apache.fop.afp.ioca.ImageSizeParameter;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;

public class ImageSegment
extends AbstractNamedAFPObject {
    private ImageContent imageContent = null;
    private final Factory factory;
    private static final int NAME_LENGTH = 4;

    public ImageSegment(Factory factory, String string) {
        super(string);
        this.factory = factory;
    }

    public ImageContent getImageContent() {
        if (this.imageContent == null) {
            this.imageContent = this.factory.createImageContent();
        }
        return this.imageContent;
    }

    public void setImageSize(int n, int n2, int n3, int n4) {
        ImageSizeParameter imageSizeParameter = this.factory.createImageSizeParameter(n, n2, n3, n4);
        this.getImageContent().setImageSizeParameter(imageSizeParameter);
    }

    public void setEncoding(byte by) {
        this.getImageContent().setImageEncoding(by);
    }

    public void setCompression(byte by) {
        this.getImageContent().setImageCompression(by);
    }

    public void setIDESize(byte by) {
        this.getImageContent().setImageIDESize(by);
    }

    public void setIDEColorModel(byte by) {
        this.getImageContent().setImageIDEColorModel(by);
    }

    public void setSubtractive(boolean bl) {
        this.getImageContent().setSubtractive(bl);
    }

    public void setData(byte[] byArray) {
        this.getImageContent().setImageData(byArray);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        if (this.imageContent != null) {
            this.imageContent.writeToStream(outputStream);
        }
    }

    protected int getNameLength() {
        return 4;
    }

    protected void writeStart(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[]{112, 0};
        outputStream.write(byArray);
    }

    protected void writeEnd(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[]{113, 0};
        outputStream.write(byArray);
    }
}

