/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.Completable;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.Startable;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.afp.modca.ObjectAreaDescriptor;
import org.apache.fop.afp.modca.ObjectAreaPosition;
import org.apache.fop.afp.modca.ObjectEnvironmentGroup;

public abstract class AbstractDataObject
extends AbstractNamedAFPObject
implements Startable,
Completable {
    protected ObjectEnvironmentGroup objectEnvironmentGroup = null;
    protected final Factory factory;
    private boolean complete;
    private boolean started;

    public AbstractDataObject(Factory factory, String string) {
        super(string);
        this.factory = factory;
    }

    public void setViewport(AFPDataObjectInfo aFPDataObjectInfo) {
        AFPObjectAreaInfo aFPObjectAreaInfo = aFPDataObjectInfo.getObjectAreaInfo();
        int n = aFPObjectAreaInfo.getWidth();
        int n2 = aFPObjectAreaInfo.getHeight();
        int n3 = aFPObjectAreaInfo.getWidthRes();
        int n4 = aFPObjectAreaInfo.getHeightRes();
        ObjectAreaDescriptor objectAreaDescriptor = this.factory.createObjectAreaDescriptor(n, n2, n3, n4);
        this.getObjectEnvironmentGroup().setObjectAreaDescriptor(objectAreaDescriptor);
        AFPResourceInfo aFPResourceInfo = aFPDataObjectInfo.getResourceInfo();
        AFPResourceLevel aFPResourceLevel = aFPResourceInfo.getLevel();
        ObjectAreaPosition objectAreaPosition = null;
        int n5 = aFPObjectAreaInfo.getRotation();
        if (aFPResourceLevel.isInline()) {
            int n6 = aFPObjectAreaInfo.getX();
            int n7 = aFPObjectAreaInfo.getY();
            objectAreaPosition = this.factory.createObjectAreaPosition(n6, n7, n5);
        } else {
            objectAreaPosition = this.factory.createObjectAreaPosition(0, 0, n5);
        }
        objectAreaPosition.setReferenceCoordinateSystem((byte)0);
        this.getObjectEnvironmentGroup().setObjectAreaPosition(objectAreaPosition);
    }

    public ObjectEnvironmentGroup getObjectEnvironmentGroup() {
        if (this.objectEnvironmentGroup == null) {
            this.objectEnvironmentGroup = this.factory.createObjectEnvironmentGroup();
        }
        return this.objectEnvironmentGroup;
    }

    protected void writeStart(OutputStream outputStream) throws IOException {
        this.setStarted(true);
    }

    protected void writeContent(OutputStream outputStream) throws IOException {
        this.writeTriplets(outputStream);
        if (this.objectEnvironmentGroup != null) {
            this.objectEnvironmentGroup.writeToStream(outputStream);
        }
    }

    public void setStarted(boolean bl) {
        this.started = bl;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

