/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.modca.AbstractEnvironmentGroup;
import org.apache.fop.afp.modca.MapCodedFont;
import org.apache.fop.afp.modca.MapPageSegment;
import org.apache.fop.afp.modca.MaximumSizeExceededException;
import org.apache.fop.afp.modca.ObjectAreaDescriptor;
import org.apache.fop.afp.modca.ObjectAreaPosition;
import org.apache.fop.afp.modca.PageDescriptor;
import org.apache.fop.afp.modca.PresentationTextDescriptor;

public final class ActiveEnvironmentGroup
extends AbstractEnvironmentGroup {
    private final List mapCodedFonts = new ArrayList();
    private List mapPageSegments = null;
    private ObjectAreaDescriptor objectAreaDescriptor = null;
    private ObjectAreaPosition objectAreaPosition = null;
    private PresentationTextDescriptor presentationTextDataDescriptor = null;
    private PageDescriptor pageDescriptor = null;
    private final Factory factory;

    public ActiveEnvironmentGroup(Factory factory, String string, int n, int n2, int n3, int n4) {
        super(string);
        this.factory = factory;
        this.pageDescriptor = factory.createPageDescriptor(n, n2, n3, n4);
        this.objectAreaDescriptor = factory.createObjectAreaDescriptor(n, n2, n3, n4);
        this.presentationTextDataDescriptor = factory.createPresentationTextDataDescriptor(n, n2, n3, n4);
    }

    public void setObjectAreaPosition(int n, int n2, int n3) {
        this.objectAreaPosition = this.factory.createObjectAreaPosition(n, n2, n3);
    }

    public PageDescriptor getPageDescriptor() {
        return this.pageDescriptor;
    }

    public PresentationTextDescriptor getPresentationTextDataDescriptor() {
        return this.presentationTextDataDescriptor;
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        super.writeTriplets(outputStream);
        this.writeObjects(this.mapCodedFonts, outputStream);
        this.writeObjects(this.mapDataResources, outputStream);
        this.writeObjects(this.mapPageOverlays, outputStream);
        this.writeObjects(this.mapPageSegments, outputStream);
        if (this.pageDescriptor != null) {
            this.pageDescriptor.writeToStream(outputStream);
        }
        if (this.objectAreaDescriptor != null && this.objectAreaPosition != null) {
            this.objectAreaDescriptor.writeToStream(outputStream);
            this.objectAreaPosition.writeToStream(outputStream);
        }
        if (this.presentationTextDataDescriptor != null) {
            this.presentationTextDataDescriptor.writeToStream(outputStream);
        }
    }

    protected void writeStart(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-88, (byte)-55);
        outputStream.write(byArray);
    }

    protected void writeEnd(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-87, (byte)-55);
        outputStream.write(byArray);
    }

    public void createFont(int n, AFPFont aFPFont, int n2, int n3) {
        MapCodedFont mapCodedFont = this.getCurrentMapCodedFont();
        if (mapCodedFont == null) {
            mapCodedFont = this.factory.createMapCodedFont();
            this.mapCodedFonts.add(mapCodedFont);
        }
        try {
            mapCodedFont.addFont(n, aFPFont, n2, n3);
        }
        catch (MaximumSizeExceededException maximumSizeExceededException) {
            mapCodedFont = this.factory.createMapCodedFont();
            this.mapCodedFonts.add(mapCodedFont);
            try {
                mapCodedFont.addFont(n, aFPFont, n2, n3);
            }
            catch (MaximumSizeExceededException maximumSizeExceededException2) {
                LOG.error((Object)"createFont():: resulted in a MaximumSizeExceededException");
            }
        }
    }

    private MapCodedFont getCurrentMapCodedFont() {
        int n = this.mapCodedFonts.size();
        if (n > 0) {
            return (MapCodedFont)this.mapCodedFonts.get(n - 1);
        }
        return null;
    }

    public void addMapPageSegment(String string) {
        try {
            this.needMapPageSegment().addPageSegment(string);
        }
        catch (MaximumSizeExceededException maximumSizeExceededException) {
            throw new IllegalStateException("Internal error: " + maximumSizeExceededException.getMessage());
        }
    }

    private MapPageSegment getCurrentMapPageSegment() {
        return (MapPageSegment)this.getLastElement(this.mapPageSegments);
    }

    private MapPageSegment needMapPageSegment() {
        MapPageSegment mapPageSegment;
        if (this.mapPageSegments == null) {
            this.mapPageSegments = new ArrayList();
        }
        if ((mapPageSegment = this.getCurrentMapPageSegment()) == null || mapPageSegment.isFull()) {
            mapPageSegment = new MapPageSegment();
            this.mapPageSegments.add(mapPageSegment);
        }
        return mapPageSegment;
    }
}

