/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPImageObjectInfo;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.ioca.ImageSegment;
import org.apache.fop.afp.modca.AbstractDataObject;
import org.apache.fop.afp.modca.ImageDataDescriptor;
import org.apache.fop.afp.modca.MapImageObject;

public class ImageObject
extends AbstractDataObject {
    private static final int MAX_DATA_LEN = 8192;
    private ImageSegment imageSegment = null;

    public ImageObject(Factory factory, String string) {
        super(factory, string);
    }

    public ImageSegment getImageSegment() {
        if (this.imageSegment == null) {
            this.imageSegment = this.factory.createImageSegment();
        }
        return this.imageSegment;
    }

    public void setViewport(AFPDataObjectInfo aFPDataObjectInfo) {
        super.setViewport(aFPDataObjectInfo);
        AFPImageObjectInfo aFPImageObjectInfo = (AFPImageObjectInfo)aFPDataObjectInfo;
        int n = aFPImageObjectInfo.getDataWidth();
        int n2 = aFPImageObjectInfo.getDataHeight();
        int n3 = aFPImageObjectInfo.getDataWidthRes();
        int n4 = aFPImageObjectInfo.getDataWidthRes();
        ImageDataDescriptor imageDataDescriptor = this.factory.createImageDataDescriptor(n, n2, n3, n4);
        if ("image/x-afp+fs45".equals(aFPImageObjectInfo.getMimeType())) {
            imageDataDescriptor.setFunctionSet((byte)45);
        } else if (aFPImageObjectInfo.getBitsPerPixel() == 1) {
            imageDataDescriptor.setFunctionSet((byte)10);
        }
        this.getObjectEnvironmentGroup().setDataDescriptor(imageDataDescriptor);
        this.getObjectEnvironmentGroup().setMapImageObject(new MapImageObject(aFPDataObjectInfo.getMappingOption()));
        this.getImageSegment().setImageSize(n, n2, n3, n4);
    }

    public void setEncoding(byte by) {
        this.getImageSegment().setEncoding(by);
    }

    public void setCompression(byte by) {
        this.getImageSegment().setCompression(by);
    }

    public void setIDESize(byte by) {
        this.getImageSegment().setIDESize(by);
    }

    public void setIDEColorModel(byte by) {
        this.getImageSegment().setIDEColorModel(by);
    }

    public void setSubtractive(boolean bl) {
        this.getImageSegment().setSubtractive(bl);
    }

    public void setData(byte[] byArray) {
        this.getImageSegment().setData(byArray);
    }

    protected void writeStart(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-88, (byte)-5);
        outputStream.write(byArray);
    }

    protected void writeContent(OutputStream outputStream) throws IOException {
        super.writeContent(outputStream);
        if (this.imageSegment != null) {
            byte[] byArray = new byte[9];
            ImageObject.copySF(byArray, (byte)-45, (byte)-18, (byte)-5);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.imageSegment.writeToStream((OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ImageObject.writeChunksToStream(byArray2, byArray, 1, 8192, outputStream);
        }
    }

    protected void writeEnd(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-87, (byte)-5);
        outputStream.write(byArray);
    }
}

