/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ptoca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.afp.fonts.CharactersetEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TransparentDataControlSequence
implements Iterable<TransparentData> {
    private static final int MAX_SBCS_TRN_SIZE = 253;
    private static final int MAX_DBCS_TRN_SIZE = 252;
    private final List<TransparentData> trns;

    public TransparentDataControlSequence(CharactersetEncoder.EncodedChars encodedChars) {
        int n;
        int n2 = encodedChars.isDBCS() ? 252 : 253;
        int n3 = encodedChars.getLength() / n2;
        int n4 = 0;
        ArrayList<TransparentData> arrayList = new ArrayList<TransparentData>();
        for (n = 0; n < n3; ++n) {
            arrayList.add(new TransparentData(n4, n2, encodedChars));
            n4 += n2;
        }
        n = encodedChars.getLength() - n4;
        arrayList.add(new TransparentData(n4, n, encodedChars));
        this.trns = Collections.unmodifiableList(arrayList);
    }

    @Override
    public Iterator<TransparentData> iterator() {
        return this.trns.iterator();
    }

    static final class TransparentData {
        private final int offset;
        private final int length;
        private final CharactersetEncoder.EncodedChars encodedChars;

        private TransparentData(int n, int n2, CharactersetEncoder.EncodedChars encodedChars) {
            this.offset = n;
            this.length = n2;
            this.encodedChars = encodedChars;
        }

        void writeTo(OutputStream outputStream) throws IOException {
            this.encodedChars.writeTo(outputStream, this.offset, this.length);
        }
    }
}

