/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.svg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPGraphics2D;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.AFPFontAttributes;
import org.apache.fop.afp.fonts.AFPPageFonts;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.modca.GraphicsObject;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.FOPTextHandlerAdapter;

public class AFPTextHandler
extends FOPTextHandlerAdapter {
    private static Log log = LogFactory.getLog(AFPTextHandler.class);
    protected org.apache.fop.fonts.Font overrideFont = null;
    private final FontInfo fontInfo;
    private AFPResourceManager resourceManager;

    public AFPTextHandler(FontInfo fontInfo, AFPResourceManager aFPResourceManager) {
        this.fontInfo = fontInfo;
        this.resourceManager = aFPResourceManager;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    private int registerPageFont(AFPPageFonts aFPPageFonts, String string, int n) {
        AFPFont aFPFont = (AFPFont)this.fontInfo.getFonts().get(string);
        AFPFontAttributes aFPFontAttributes = aFPPageFonts.registerFont(string, aFPFont, n);
        if (aFPFont.isEmbeddable()) {
            try {
                CharacterSet characterSet = aFPFont.getCharacterSet(n);
                this.resourceManager.embedFont(aFPFont, characterSet);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error while embedding font resources", iOException);
            }
        }
        return aFPFontAttributes.getFontReference();
    }

    public void drawString(Graphics2D graphics2D, String string, float f, float f2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("drawString() str=" + string + ", x=" + f + ", y=" + f2));
        }
        if (graphics2D instanceof AFPGraphics2D) {
            Object object;
            Object object2;
            int n;
            String string2;
            AFPGraphics2D aFPGraphics2D = (AFPGraphics2D)((Object)graphics2D);
            GraphicsObject graphicsObject = aFPGraphics2D.getGraphicsObject();
            Color color = aFPGraphics2D.getColor();
            AFPPaintingState aFPPaintingState = aFPGraphics2D.getPaintingState();
            if (aFPPaintingState.setColor(color)) {
                graphicsObject.setColor(color);
            }
            int n2 = 0;
            AFPPageFonts aFPPageFonts = aFPPaintingState.getPageFonts();
            if (this.overrideFont != null) {
                string2 = this.overrideFont.getFontName();
                n = this.overrideFont.getFontSize();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  with overriding font: " + string2 + ", " + n));
                }
            } else {
                object2 = aFPGraphics2D.getFont();
                object = this.fontInfo.getFontInstanceForAWTFont((Font)object2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  with font: " + object));
                }
                string2 = ((org.apache.fop.fonts.Font)object).getFontName();
                n = ((org.apache.fop.fonts.Font)object).getFontSize();
            }
            n = (int)Math.round(aFPGraphics2D.convertToAbsoluteLength(n));
            n2 = this.registerPageFont(aFPPageFonts, string2, n);
            object2 = (AFPFont)this.fontInfo.getFonts().get(string2);
            object = ((AFPFont)object2).getCharacterSet(n);
            graphicsObject.setCharacterSet(n2);
            graphicsObject.addString(string, Math.round(f), Math.round(f2), (CharacterSet)object);
        } else {
            graphics2D.drawString(string, f, f2);
        }
    }

    public void setOverrideFont(org.apache.fop.fonts.Font font) {
        this.overrideFont = font;
    }
}

