/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.util;

import java.io.ByteArrayOutputStream;

public final class BinaryUtils {
    private BinaryUtils() {
    }

    public static byte[] convert(int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer(Integer.toHexString(n));
        if (stringBuffer.length() % 2 != 0) {
            stringBuffer.insert(0, "0");
        }
        if ((n3 = stringBuffer.length() / 2) > n2) {
            stringBuffer.delete(0, stringBuffer.length() - n2 * 2);
        } else {
            while (n3 < n2) {
                stringBuffer.insert(0, "00");
                ++n3;
            }
        }
        return BinaryUtils.convert(stringBuffer.toString());
    }

    public static byte[] convert(int n) {
        return BinaryUtils.convert(Integer.toHexString(n));
    }

    public static byte[] convert(String string) {
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < string.length(); i += 2) {
            char c = string.charAt(i);
            char c2 = string.charAt(i + 1);
            int n = 0;
            if (c >= '0' && c <= '9') {
                n = (byte)(n + (c - 48) * 16);
            } else if (c >= 'a' && c <= 'f') {
                n = (byte)(n + (c - 97 + 10) * 16);
            } else if (c >= 'A' && c <= 'F') {
                n = (byte)(n + (c - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException("Bad hexadecimal digit");
            }
            if (c2 >= '0' && c2 <= '9') {
                n = (byte)(n + (c2 - 48));
            } else if (c2 >= 'a' && c2 <= 'f') {
                n = (byte)(n + (c2 - 97 + 10));
            } else if (c2 >= 'A' && c2 <= 'F') {
                n = (byte)(n + (c2 - 65 + 10));
            } else {
                throw new IllegalArgumentException("Bad hexadecimal digit");
            }
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void shortToByteArray(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s >>> 8);
        byArray[n + 1] = (byte)s;
    }

    public static byte[] shortToByteArray(short s) {
        byte[] byArray = new byte[2];
        BinaryUtils.shortToByteArray(s, byArray, 0);
        return byArray;
    }
}

