/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.util;

import java.io.IOException;
import java.net.URL;
import org.apache.fop.afp.fonts.FontRuntimeException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDEntityResolver
implements EntityResolver {
    public static final String AFP_DTD_1_0_ID = "-//APACHE/DTD AFP Installed Font Definition DTD 1.0//EN";
    public static final String AFP_DTD_1_0_RESOURCE = "afp-fonts-1.0.dtd";
    public static final String AFP_DTD_1_1_ID = "-//APACHE/DTD AFP Installed Font Definition DTD 1.1//EN";
    public static final String AFP_DTD_1_1_RESOURCE = "afp-fonts-1.1.dtd";
    public static final String AFP_DTD_1_2_ID = "-//APACHE/DTD AFP Installed Font Definition DTD 1.2//EN";
    public static final String AFP_DTD_1_2_RESOURCE = "afp-fonts-1.2.dtd";

    public InputSource resolveEntity(String string, String string2) throws IOException {
        URL uRL = null;
        if (AFP_DTD_1_2_ID.equals(string)) {
            uRL = this.getResource(AFP_DTD_1_2_RESOURCE);
        } else if (AFP_DTD_1_1_ID.equals(string)) {
            uRL = this.getResource(AFP_DTD_1_1_RESOURCE);
        } else {
            if (AFP_DTD_1_0_ID.equals(string)) {
                throw new FontRuntimeException("The AFP Installed Font Definition 1.0 DTD is not longer supported");
            }
            if (string2 != null && string2.indexOf("afp-fonts.dtd") >= 0) {
                throw new FontRuntimeException("The AFP Installed Font Definition DTD must be specified using the public id");
            }
            return null;
        }
        InputSource inputSource = new InputSource(uRL.openStream());
        inputSource.setPublicId(string);
        inputSource.setSystemId(string2);
        return inputSource;
    }

    private URL getResource(String string) {
        URL uRL;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((uRL = classLoader.getResource(string)) == null) {
            throw new FontRuntimeException("Resource " + string + "could not be found on the classpath");
        }
        return uRL;
    }
}

