/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.util.io.Base64EncodeStream;
import org.apache.xmlgraphics.util.uri.CommonURIResolver;

public class FOURIResolver
implements URIResolver {
    private Log log = LogFactory.getLog((String)"FOP");
    private CommonURIResolver commonURIResolver = new CommonURIResolver();
    private URIResolver uriResolver = null;
    private boolean throwExceptions = false;

    public String checkBaseURL(String string) throws MalformedURLException {
        File file;
        if (!(string = string.replace('\\', '/')).endsWith("/")) {
            string = string + "/";
        }
        if ((file = new File(string)).isDirectory()) {
            return file.toURI().toASCIIString();
        }
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getScheme();
            boolean bl = true;
            if ("file".equals(string2)) {
                file = FileUtils.toFile((URL)uRI.toURL());
                bl = file.isDirectory();
            }
            if (string2 == null || !bl) {
                String string3 = "base " + string + " is not a valid directory";
                if (this.throwExceptions) {
                    throw new MalformedURLException(string3);
                }
                this.log.error((Object)string3);
            }
            return uRI.toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MalformedURLException(uRISyntaxException.getMessage());
        }
    }

    public FOURIResolver() {
        this(false);
    }

    public FOURIResolver(boolean bl) {
        this.throwExceptions = bl;
    }

    private void handleException(Exception exception, String string, boolean bl) throws TransformerException {
        if (bl) {
            throw new TransformerException(string, exception);
        }
        this.log.error((Object)exception.getMessage());
    }

    public Source resolve(String string, String string2) throws TransformerException {
        Source source = null;
        source = this.commonURIResolver.resolve(string, string2);
        if (source == null && this.uriResolver != null) {
            source = this.uriResolver.resolve(string, string2);
        }
        if (source == null) {
            Object object;
            Object object2;
            URL uRL;
            block26: {
                String string3;
                String string4;
                uRL = null;
                int n = string.indexOf(35);
                if (n >= 0) {
                    string4 = string.substring(0, n);
                    string3 = string.substring(n);
                } else {
                    string4 = string;
                    string3 = null;
                }
                File file = new File(string4);
                if (file.canRead() && file.isFile()) {
                    try {
                        if (string3 != null) {
                            uRL = new URL(file.toURI().toURL().toExternalForm() + string3);
                            break block26;
                        }
                        uRL = file.toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.handleException(malformedURLException, "Could not convert filename '" + string + "' to URL", this.throwExceptions);
                    }
                } else if (string2 == null) {
                    try {
                        uRL = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            uRL = new URL("file:" + string);
                        }
                        catch (MalformedURLException malformedURLException2) {
                            this.handleException(malformedURLException2, "Error with URL '" + string + "'", this.throwExceptions);
                        }
                    }
                } else {
                    object2 = null;
                    try {
                        object2 = new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.handleException(malformedURLException, "Error with base URL '" + string2 + "'", this.throwExceptions);
                    }
                    assert (object2 != null);
                    object = ((URL)object2).getProtocol() + ":";
                    if (string.startsWith((String)object) && "file:".equals(object)) {
                        string = string.substring(((String)object).length());
                        int n2 = string.indexOf(58);
                        int n3 = string.indexOf(47);
                        if (n3 >= 0 && n2 >= 0 && n2 < n3) {
                            string = "/" + string;
                        }
                    }
                    try {
                        uRL = new URL((URL)object2, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.handleException(malformedURLException, "Error with URL; base '" + string2 + "' " + "href '" + string + "'", this.throwExceptions);
                    }
                }
            }
            if (uRL != null) {
                object2 = uRL.toExternalForm();
                try {
                    object = uRL.openConnection();
                    ((URLConnection)object).setAllowUserInteraction(false);
                    ((URLConnection)object).setDoInput(true);
                    this.updateURLConnection((URLConnection)object, string);
                    ((URLConnection)object).connect();
                    return new StreamSource(((URLConnection)object).getInputStream(), (String)object2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log.debug((Object)("File not found: " + (String)object2));
                }
                catch (IOException iOException) {
                    this.log.error((Object)("Error with opening URL '" + (String)object2 + "': " + iOException.getMessage()));
                }
            }
        }
        return source;
    }

    protected void updateURLConnection(URLConnection uRLConnection, String string) {
    }

    protected void applyHttpBasicAuthentication(URLConnection uRLConnection, String string, String string2) {
        String string3 = string + ":" + string2;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string3.length() * 2);
            Base64EncodeStream base64EncodeStream = new Base64EncodeStream((OutputStream)byteArrayOutputStream);
            base64EncodeStream.write(string3.getBytes("UTF-8"));
            base64EncodeStream.close();
            uRLConnection.setRequestProperty("Authorization", "Basic " + new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error during base64 encodation of username/password");
        }
    }

    public void setCustomURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public URIResolver getCustomURIResolver() {
        return this.uriResolver;
    }

    public void setThrowExceptions(boolean bl) {
        this.throwExceptions = bl;
    }
}

