/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.Trait;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.WritingModeTraitsGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Area
extends AreaTreeObject
implements Serializable {
    private static final long serialVersionUID = 6342888466142626492L;
    public static final int ORIENT_0 = 0;
    public static final int ORIENT_90 = 1;
    public static final int ORIENT_180 = 2;
    public static final int ORIENT_270 = 3;
    public static final int CLASS_NORMAL = 0;
    public static final int CLASS_FIXED = 1;
    public static final int CLASS_ABSOLUTE = 2;
    public static final int CLASS_BEFORE_FLOAT = 3;
    public static final int CLASS_FOOTNOTE = 4;
    public static final int CLASS_SIDE_FLOAT = 5;
    public static final int CLASS_MAX = 6;
    private int areaClass = 0;
    protected int ipd;
    protected int bpd;
    protected int bidiLevel = -1;
    protected TreeMap<Integer, Object> traits;
    protected static final Log log = LogFactory.getLog(Area.class);

    public int getAreaClass() {
        return this.areaClass;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Area area = (Area)super.clone();
        if (this.traits != null) {
            area.traits = (TreeMap)this.traits.clone();
        }
        return area;
    }

    public void setAreaClass(int n) {
        this.areaClass = n;
    }

    public void setIPD(int n) {
        this.ipd = n;
    }

    public int getIPD() {
        return this.ipd;
    }

    public void setBPD(int n) {
        this.bpd = n;
    }

    public int getBPD() {
        return this.bpd;
    }

    public int getAllocIPD() {
        return this.getBorderAndPaddingWidthStart() + this.getIPD() + this.getBorderAndPaddingWidthEnd();
    }

    public int getAllocBPD() {
        return this.getSpaceBefore() + this.getBorderAndPaddingWidthBefore() + this.getBPD() + this.getBorderAndPaddingWidthAfter() + this.getSpaceAfter();
    }

    public void setBidiLevel(int n) {
        this.bidiLevel = n;
    }

    public void resetBidiLevel() {
        this.setBidiLevel(-1);
    }

    public int getBidiLevel() {
        return this.bidiLevel;
    }

    public int getBorderAndPaddingWidthBefore() {
        Integer n;
        int n2 = 0;
        BorderProps borderProps = (BorderProps)this.getTrait(Trait.BORDER_BEFORE);
        if (borderProps != null) {
            n2 = borderProps.width;
        }
        if ((n = (Integer)this.getTrait(Trait.PADDING_BEFORE)) != null) {
            n2 += n.intValue();
        }
        return n2;
    }

    public int getBorderAndPaddingWidthAfter() {
        Integer n;
        int n2 = 0;
        BorderProps borderProps = (BorderProps)this.getTrait(Trait.BORDER_AFTER);
        if (borderProps != null) {
            n2 = borderProps.width;
        }
        if ((n = (Integer)this.getTrait(Trait.PADDING_AFTER)) != null) {
            n2 += n.intValue();
        }
        return n2;
    }

    public int getBorderAndPaddingWidthStart() {
        Integer n;
        int n2 = 0;
        BorderProps borderProps = (BorderProps)this.getTrait(Trait.BORDER_START);
        if (borderProps != null) {
            n2 = borderProps.width;
        }
        if ((n = (Integer)this.getTrait(Trait.PADDING_START)) != null) {
            n2 += n.intValue();
        }
        return n2;
    }

    public int getBorderAndPaddingWidthEnd() {
        Integer n;
        int n2 = 0;
        BorderProps borderProps = (BorderProps)this.getTrait(Trait.BORDER_END);
        if (borderProps != null) {
            n2 = borderProps.width;
        }
        if ((n = (Integer)this.getTrait(Trait.PADDING_END)) != null) {
            n2 += n.intValue();
        }
        return n2;
    }

    public int getSpaceBefore() {
        int n = 0;
        Integer n2 = (Integer)this.getTrait(Trait.SPACE_BEFORE);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public int getSpaceAfter() {
        int n = 0;
        Integer n2 = (Integer)this.getTrait(Trait.SPACE_AFTER);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public int getSpaceStart() {
        int n = 0;
        Integer n2 = (Integer)this.getTrait(Trait.SPACE_START);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public int getSpaceEnd() {
        int n = 0;
        Integer n2 = (Integer)this.getTrait(Trait.SPACE_END);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public void addChildArea(Area area) {
    }

    public void addTrait(Integer n, Object object) {
        if (this.traits == null) {
            this.traits = new TreeMap();
        }
        this.traits.put(n, object);
    }

    public void setTraits(Map map) {
        this.traits = map != null ? new TreeMap(map) : null;
    }

    public Map<Integer, Object> getTraits() {
        return this.traits;
    }

    public boolean hasTraits() {
        return this.traits != null;
    }

    public Object getTrait(Integer n) {
        return this.traits != null ? this.traits.get(n) : null;
    }

    public boolean hasTrait(Integer n) {
        return this.getTrait(n) != null;
    }

    public boolean getTraitAsBoolean(Integer n) {
        return Boolean.TRUE.equals(this.getTrait(n));
    }

    public int getTraitAsInteger(Integer n) {
        Object object = this.getTrait(n);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new IllegalArgumentException("Trait " + n.getClass().getName() + " could not be converted to an integer");
    }

    public void setWritingModeTraits(WritingModeTraitsGetter writingModeTraitsGetter) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" {ipd=").append(Integer.toString(this.getIPD()));
        stringBuffer.append(", bpd=").append(Integer.toString(this.getBPD()));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

