/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.CTM;
import org.apache.fop.area.DestinationData;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.util.ColorUtil;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.fop.util.ContentHandlerFactoryRegistry;
import org.apache.fop.util.ConversionUtils;
import org.apache.fop.util.DefaultErrorListener;
import org.apache.fop.util.XMLUtil;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.util.QName;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class AreaTreeParser {
    protected static final Log log = LogFactory.getLog(AreaTreeParser.class);
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();

    public void parse(Source source, AreaTreeModel areaTreeModel, FOUserAgent fOUserAgent) throws TransformerException {
        Transformer transformer = tFactory.newTransformer();
        transformer.setErrorListener(new DefaultErrorListener(log));
        SAXResult sAXResult = new SAXResult(this.getContentHandler(areaTreeModel, fOUserAgent));
        transformer.transform(source, sAXResult);
    }

    public ContentHandler getContentHandler(AreaTreeModel areaTreeModel, FOUserAgent fOUserAgent) {
        ElementMappingRegistry elementMappingRegistry = fOUserAgent.getFactory().getElementMappingRegistry();
        return new Handler(areaTreeModel, fOUserAgent, elementMappingRegistry);
    }

    private static class Handler
    extends DefaultHandler {
        private Map<String, AbstractMaker> makers = new HashMap<String, AbstractMaker>();
        private AreaTreeModel treeModel;
        private FOUserAgent userAgent;
        private ElementMappingRegistry elementMappingRegistry;
        private Attributes lastAttributes;
        private CharBuffer content = CharBuffer.allocate(64);
        private boolean ignoreCharacters = true;
        private PageViewport currentPageViewport;
        private Map<String, PageViewport> pageViewportsByKey = new HashMap<String, PageViewport>();
        private Set<String> idFirstsAssigned = new HashSet<String>();
        private Stack<Object> areaStack = new Stack();
        private boolean firstFlow;
        private Stack<String> delegateStack = new Stack();
        private ContentHandler delegate;
        private DOMImplementation domImplementation;
        private Locator locator;
        private static final Object[] SUBSET_COMMON = new Object[]{Trait.PROD_ID};
        private static final Object[] SUBSET_LINK = new Object[]{Trait.INTERNAL_LINK, Trait.EXTERNAL_LINK};
        private static final Object[] SUBSET_COLOR = new Object[]{Trait.BACKGROUND, Trait.COLOR};
        private static final Object[] SUBSET_FONT = new Object[]{Trait.FONT, Trait.FONT_SIZE, Trait.BLINK, Trait.OVERLINE, Trait.OVERLINE_COLOR, Trait.LINETHROUGH, Trait.LINETHROUGH_COLOR, Trait.UNDERLINE, Trait.UNDERLINE_COLOR};
        private static final Object[] SUBSET_BOX = new Object[]{Trait.BORDER_BEFORE, Trait.BORDER_AFTER, Trait.BORDER_START, Trait.BORDER_END, Trait.SPACE_BEFORE, Trait.SPACE_AFTER, Trait.SPACE_START, Trait.SPACE_END, Trait.PADDING_BEFORE, Trait.PADDING_AFTER, Trait.PADDING_START, Trait.PADDING_END, Trait.START_INDENT, Trait.END_INDENT, Trait.IS_REFERENCE_AREA, Trait.IS_VIEWPORT_AREA};
        private static final Object[] SUBSET_BORDER_PADDING = new Object[]{Trait.BORDER_BEFORE, Trait.BORDER_AFTER, Trait.BORDER_START, Trait.BORDER_END, Trait.PADDING_BEFORE, Trait.PADDING_AFTER, Trait.PADDING_START, Trait.PADDING_END};

        public Handler(AreaTreeModel areaTreeModel, FOUserAgent fOUserAgent, ElementMappingRegistry elementMappingRegistry) {
            this.treeModel = areaTreeModel;
            this.userAgent = fOUserAgent;
            this.elementMappingRegistry = elementMappingRegistry;
            this.makers.put("areaTree", new AreaTreeMaker());
            this.makers.put("page", new PageMaker());
            this.makers.put("pageSequence", new PageSequenceMaker());
            this.makers.put("title", new TitleMaker());
            this.makers.put("pageViewport", new PageViewportMaker());
            this.makers.put("regionViewport", new RegionViewportMaker());
            this.makers.put("regionBefore", new RegionBeforeMaker());
            this.makers.put("regionAfter", new RegionAfterMaker());
            this.makers.put("regionStart", new RegionStartMaker());
            this.makers.put("regionEnd", new RegionEndMaker());
            this.makers.put("regionBody", new RegionBodyMaker());
            this.makers.put("flow", new FlowMaker());
            this.makers.put("mainReference", new MainReferenceMaker());
            this.makers.put("span", new SpanMaker());
            this.makers.put("footnote", new FootnoteMaker());
            this.makers.put("beforeFloat", new BeforeFloatMaker());
            this.makers.put("block", new BlockMaker());
            this.makers.put("lineArea", new LineAreaMaker());
            this.makers.put("inline", new InlineMaker());
            this.makers.put("inlineparent", new InlineParentMaker());
            this.makers.put("inlineblockparent", new InlineBlockParentMaker());
            this.makers.put("text", new TextMaker());
            this.makers.put("word", new WordMaker());
            this.makers.put("space", new SpaceMaker());
            this.makers.put("leader", new LeaderMaker());
            this.makers.put("viewport", new InlineViewportMaker());
            this.makers.put("image", new ImageMaker());
            this.makers.put("foreignObject", new ForeignObjectMaker());
            this.makers.put("bookmarkTree", new BookmarkTreeMaker());
            this.makers.put("bookmark", new BookmarkMaker());
            this.makers.put("destination", new DestinationMaker());
        }

        private Area findAreaType(Class clazz) {
            if (this.areaStack.size() > 0) {
                int n;
                Object var3_3 = null;
                for (n = this.areaStack.size() - 1; n >= 0 && !clazz.isInstance(var3_3 = this.areaStack.get(n)); --n) {
                }
                if (n >= 0) {
                    return var3_3;
                }
            }
            return null;
        }

        private RegionViewport getCurrentRegionViewport() {
            return (RegionViewport)this.findAreaType(RegionViewport.class);
        }

        private BodyRegion getCurrentBodyRegion() {
            return (BodyRegion)this.findAreaType(BodyRegion.class);
        }

        private BlockParent getCurrentBlockParent() {
            return (BlockParent)this.findAreaType(BlockParent.class);
        }

        private AbstractTextArea getCurrentText() {
            return (AbstractTextArea)this.findAreaType(AbstractTextArea.class);
        }

        private InlineViewport getCurrentViewport() {
            return (InlineViewport)this.findAreaType(InlineViewport.class);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private Locator getLocator() {
            return this.locator;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.delegate != null) {
                this.delegateStack.push(string3);
                this.delegate.startElement(string, string2, string3, attributes);
            } else if (this.domImplementation != null) {
                TransformerHandler transformerHandler;
                try {
                    transformerHandler = tFactory.newTransformerHandler();
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw new SAXException("Error creating a new TransformerHandler", transformerConfigurationException);
                }
                Document document = this.domImplementation.createDocument(string, string3, null);
                document.removeChild(document.getDocumentElement());
                transformerHandler.setResult(new DOMResult(document));
                Area area = (Area)this.areaStack.peek();
                ((ForeignObject)area).setDocument(document);
                this.domImplementation = null;
                this.delegate = transformerHandler;
                this.delegateStack.push(string3);
                this.delegate.startDocument();
                this.delegate.startElement(string, string2, string3, attributes);
            } else {
                boolean bl = true;
                if ("".equals(string)) {
                    if (string2.equals("structureTree")) {
                        this.delegate = new DefaultHandler();
                        this.delegateStack.push(string3);
                        this.delegate.startDocument();
                        this.delegate.startElement(string, string2, string3, attributes);
                    } else {
                        bl = this.startAreaTreeElement(string2, attributes);
                    }
                } else {
                    ContentHandlerFactoryRegistry contentHandlerFactoryRegistry = this.userAgent.getFactory().getContentHandlerFactoryRegistry();
                    ContentHandlerFactory contentHandlerFactory = contentHandlerFactoryRegistry.getFactory(string);
                    if (contentHandlerFactory != null) {
                        this.delegate = contentHandlerFactory.createContentHandler();
                        this.delegateStack.push(string3);
                        this.delegate.startDocument();
                        this.delegate.startElement(string, string2, string3, attributes);
                    } else {
                        bl = false;
                    }
                }
                if (!bl) {
                    if (string == null || string.length() == 0) {
                        throw new SAXException("Unhandled element " + string2 + " in namespace: " + string);
                    }
                    log.warn((Object)("Unhandled element " + string2 + " in namespace: " + string));
                }
            }
        }

        private boolean startAreaTreeElement(String string, Attributes attributes) throws SAXException {
            this.lastAttributes = new AttributesImpl(attributes);
            Maker maker = this.makers.get(string);
            this.content.clear();
            this.ignoreCharacters = true;
            if (maker != null) {
                this.ignoreCharacters = maker.ignoreCharacters();
                maker.startElement(attributes);
            } else if (!"extension-attachments".equals(string)) {
                return false;
            }
            return true;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.delegate != null) {
                this.delegate.endElement(string, string2, string3);
                this.delegateStack.pop();
                if (this.delegateStack.size() == 0) {
                    this.delegate.endDocument();
                    if (this.delegate instanceof ContentHandlerFactory.ObjectSource) {
                        Object object = ((ContentHandlerFactory.ObjectSource)((Object)this.delegate)).getObject();
                        this.handleExternallyGeneratedObject(object);
                    }
                    this.delegate = null;
                }
            } else if ("".equals(string)) {
                Maker maker = this.makers.get(string2);
                if (maker != null) {
                    maker.endElement();
                    this.content.clear();
                }
                this.ignoreCharacters = true;
            }
        }

        private void pushNewRegionReference(Attributes attributes, int n) {
            String string = attributes.getValue("name");
            RegionViewport regionViewport = this.getCurrentRegionViewport();
            RegionReference regionReference = new RegionReference(n, string, regionViewport);
            Handler.transferForeignObjects(attributes, regionReference);
            regionReference.setCTM(Handler.getAttributeAsCTM(attributes, "ctm"));
            this.setAreaAttributes(attributes, regionReference);
            this.setTraits(attributes, regionReference, SUBSET_BORDER_PADDING);
            regionViewport.setRegionReference(regionReference);
            this.currentPageViewport.getPage().setRegionViewport(n, regionViewport);
            this.areaStack.push(regionReference);
        }

        private void assertObjectOfClass(Object object, Class clazz) {
            if (!clazz.isInstance(object)) {
                throw new IllegalStateException("Object is not an instance of " + clazz.getName() + " but of " + object.getClass().getName());
            }
        }

        protected void handleExternallyGeneratedObject(Object object) {
            if (this.areaStack.size() == 0 && object instanceof ExtensionAttachment) {
                ExtensionAttachment extensionAttachment = (ExtensionAttachment)object;
                if (this.currentPageViewport == null) {
                    this.treeModel.handleOffDocumentItem(new OffDocumentExtensionAttachment(extensionAttachment));
                } else {
                    this.currentPageViewport.addExtensionAttachment(extensionAttachment);
                }
            } else {
                Object object2 = this.areaStack.peek();
                if (object2 instanceof AreaTreeObject && object instanceof ExtensionAttachment) {
                    AreaTreeObject areaTreeObject = (AreaTreeObject)object2;
                    ExtensionAttachment extensionAttachment = (ExtensionAttachment)object;
                    areaTreeObject.addExtensionAttachment(extensionAttachment);
                } else {
                    log.warn((Object)("Don't know how to handle externally generated object: " + object));
                }
            }
        }

        private void setAreaAttributes(Attributes attributes, Area area) {
            area.setIPD(Integer.parseInt(attributes.getValue("ipd")));
            area.setBPD(Integer.parseInt(attributes.getValue("bpd")));
            area.setBidiLevel(XMLUtil.getAttributeAsInt(attributes, "level", -1));
        }

        private void setTraits(Attributes attributes, Area area, Object[] objectArray) {
            int n = objectArray.length;
            while (--n >= 0) {
                Object object;
                Object object2;
                Integer n2 = (Integer)objectArray[n];
                String string = Trait.getTraitName(n2);
                String string2 = attributes.getValue(string);
                if (string2 != null) {
                    object2 = Trait.getTraitClass(n2);
                    if (object2 == Integer.class) {
                        area.addTrait(n2, new Integer(string2));
                        continue;
                    }
                    if (object2 == Boolean.class) {
                        area.addTrait(n2, Boolean.valueOf(string2));
                        continue;
                    }
                    if (object2 == String.class) {
                        area.addTrait(n2, string2);
                        if (!Trait.PROD_ID.equals(n2) || this.idFirstsAssigned.contains(string2) || this.currentPageViewport == null) continue;
                        this.currentPageViewport.setFirstWithID(string2);
                        this.idFirstsAssigned.add(string2);
                        continue;
                    }
                    if (object2 == Color.class) {
                        try {
                            area.addTrait(n2, ColorUtil.parseColorString(this.userAgent, string2));
                            continue;
                        }
                        catch (PropertyException propertyException) {
                            throw new IllegalArgumentException(propertyException.getMessage());
                        }
                    }
                    if (object2 == Trait.InternalLink.class) {
                        area.addTrait(n2, new Trait.InternalLink(string2));
                        continue;
                    }
                    if (object2 == Trait.ExternalLink.class) {
                        area.addTrait(n2, Trait.ExternalLink.makeFromTraitValue(string2));
                        continue;
                    }
                    if (object2 == Trait.Background.class) {
                        Object object3;
                        object = new Trait.Background();
                        try {
                            object3 = ColorUtil.parseColorString(this.userAgent, attributes.getValue("bkg-color"));
                            ((Trait.Background)object).setColor((Color)object3);
                        }
                        catch (PropertyException propertyException) {
                            throw new IllegalArgumentException(propertyException.getMessage());
                        }
                        object3 = attributes.getValue("bkg-img");
                        if (object3 != null) {
                            ResourceEventProducer resourceEventProducer;
                            Object object4;
                            ((Trait.Background)object).setURL((String)object3);
                            try {
                                object4 = this.userAgent.getFactory().getImageManager();
                                resourceEventProducer = this.userAgent.getImageSessionContext();
                                ImageInfo imageInfo = object4.getImageInfo((String)object3, (ImageSessionContext)resourceEventProducer);
                                ((Trait.Background)object).setImageInfo(imageInfo);
                            }
                            catch (ImageException imageException) {
                                resourceEventProducer = ResourceEventProducer.Provider.get(this.userAgent.getEventBroadcaster());
                                resourceEventProducer.imageError(this, (String)object3, imageException, this.getLocator());
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                resourceEventProducer = ResourceEventProducer.Provider.get(this.userAgent.getEventBroadcaster());
                                resourceEventProducer.imageNotFound(this, (String)object3, fileNotFoundException, this.getLocator());
                            }
                            catch (IOException iOException) {
                                resourceEventProducer = ResourceEventProducer.Provider.get(this.userAgent.getEventBroadcaster());
                                resourceEventProducer.imageIOError(this, (String)object3, iOException, this.getLocator());
                            }
                            object4 = attributes.getValue("bkg-repeat");
                            if (object4 != null) {
                                ((Trait.Background)object).setRepeat((String)object4);
                            }
                            ((Trait.Background)object).setHoriz(XMLUtil.getAttributeAsInt(attributes, "bkg-horz-offset", 0));
                            ((Trait.Background)object).setVertical(XMLUtil.getAttributeAsInt(attributes, "bkg-vert-offset", 0));
                        }
                        area.addTrait(n2, object);
                        continue;
                    }
                    if (object2 != BorderProps.class) continue;
                    area.addTrait(n2, BorderProps.valueOf(this.userAgent, string2));
                    continue;
                }
                if (!Trait.FONT.equals(n2) || (object2 = attributes.getValue("font-name")) == null) continue;
                object = attributes.getValue("font-style");
                int n3 = XMLUtil.getAttributeAsInt(attributes, "font-weight", 400);
                area.addTrait(n2, FontInfo.createFontKey((String)object2, (String)object, n3));
            }
        }

        private static CTM getAttributeAsCTM(Attributes attributes, String string) {
            String string2 = attributes.getValue(string).trim();
            if (string2.startsWith("[") && string2.endsWith("]")) {
                double[] dArray = ConversionUtils.toDoubleArray(string2 = string2.substring(1, string2.length() - 1), "\\s");
                if (dArray.length != 6) {
                    throw new IllegalArgumentException("CTM must consist of 6 double values!");
                }
                return new CTM(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            }
            throw new IllegalArgumentException("CTM must be surrounded by square brackets!");
        }

        private static void transferForeignObjects(Attributes attributes, AreaTreeObject areaTreeObject) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string = attributes.getURI(i);
                if (string.length() <= 0 || "http://www.w3.org/2000/xmlns/".equals(string)) continue;
                QName qName = new QName(string, attributes.getQName(i));
                areaTreeObject.setForeignAttribute(qName, attributes.getValue(i));
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(cArray, n, n2);
            } else if (!this.ignoreCharacters) {
                int n3 = this.content.capacity() - this.content.position();
                if (n3 < n2) {
                    CharBuffer charBuffer = CharBuffer.allocate(this.content.position() + n2);
                    this.content.flip();
                    charBuffer.put(this.content);
                    this.content = charBuffer;
                }
                this.content.limit(this.content.capacity());
                this.content.put(cArray, n, n2);
                if (this.content.position() < this.content.limit()) {
                    this.content.limit(this.content.position());
                }
            }
        }

        private class DestinationMaker
        extends AbstractMaker {
            private DestinationMaker() {
            }

            public void startElement(Attributes attributes) {
                String[] stringArray = Trait.InternalLink.parseXMLAttribute(Handler.this.lastAttributes.getValue("internal-link"));
                PageViewport pageViewport = (PageViewport)Handler.this.pageViewportsByKey.get(stringArray[0]);
                DestinationData destinationData = new DestinationData(stringArray[1]);
                ArrayList<PageViewport> arrayList = new ArrayList<PageViewport>();
                arrayList.add(pageViewport);
                destinationData.resolveIDRef(stringArray[1], arrayList);
                Handler.this.areaStack.push(destinationData);
            }

            public void endElement() {
                Object e = Handler.this.areaStack.pop();
                Handler.this.assertObjectOfClass(e, DestinationData.class);
                Handler.this.treeModel.handleOffDocumentItem((DestinationData)e);
            }
        }

        private class BookmarkMaker
        extends AbstractMaker {
            private BookmarkMaker() {
            }

            public void startElement(Attributes attributes) {
                String string = attributes.getValue("title");
                boolean bl = XMLUtil.getAttributeAsBoolean(attributes, "show-children", false);
                String[] stringArray = Trait.InternalLink.parseXMLAttribute(attributes.getValue("internal-link"));
                PageViewport pageViewport = (PageViewport)Handler.this.pageViewportsByKey.get(stringArray[0]);
                BookmarkData bookmarkData = new BookmarkData(string, bl, pageViewport, stringArray[1]);
                Object e = Handler.this.areaStack.peek();
                if (e instanceof BookmarkData) {
                    BookmarkData bookmarkData2 = (BookmarkData)e;
                    bookmarkData2.addSubData(bookmarkData);
                }
                Handler.this.areaStack.push(bookmarkData);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), BookmarkData.class);
            }
        }

        private class BookmarkTreeMaker
        extends AbstractMaker {
            private BookmarkTreeMaker() {
            }

            public void startElement(Attributes attributes) {
                BookmarkData bookmarkData = new BookmarkData();
                Handler.this.areaStack.push(bookmarkData);
            }

            public void endElement() {
                Object e = Handler.this.areaStack.pop();
                Handler.this.assertObjectOfClass(e, BookmarkData.class);
                Handler.this.treeModel.handleOffDocumentItem((BookmarkData)e);
            }
        }

        private class ForeignObjectMaker
        extends AbstractMaker {
            private ForeignObjectMaker() {
            }

            public void startElement(Attributes attributes) throws SAXException {
                String string = attributes.getValue("ns");
                Handler.this.domImplementation = Handler.this.elementMappingRegistry.getDOMImplementationForNamespace(string);
                if (Handler.this.domImplementation == null) {
                    throw new SAXException("No DOMImplementation could be identified to handle namespace: " + string);
                }
                ForeignObject foreignObject = new ForeignObject(string);
                Handler.transferForeignObjects(attributes, foreignObject);
                Handler.this.setAreaAttributes(attributes, foreignObject);
                Handler.this.setTraits(attributes, foreignObject, SUBSET_COMMON);
                Handler.this.getCurrentViewport().setContent(foreignObject);
                Handler.this.areaStack.push(foreignObject);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), ForeignObject.class);
            }
        }

        private class ImageMaker
        extends AbstractMaker {
            private ImageMaker() {
            }

            public void startElement(Attributes attributes) {
                String string = attributes.getValue("url");
                Image image = new Image(string);
                Handler.transferForeignObjects(attributes, image);
                Handler.this.setAreaAttributes(attributes, image);
                Handler.this.setTraits(attributes, image, SUBSET_COMMON);
                Handler.this.getCurrentViewport().setContent(image);
            }
        }

        private class InlineViewportMaker
        extends AbstractMaker {
            private InlineViewportMaker() {
            }

            public void startElement(Attributes attributes) {
                int n = XMLUtil.getAttributeAsInt(attributes, "level", -1);
                InlineViewport inlineViewport = new InlineViewport(null, n);
                Handler.transferForeignObjects(attributes, inlineViewport);
                Handler.this.setAreaAttributes(attributes, inlineViewport);
                Handler.this.setTraits(attributes, inlineViewport, SUBSET_COMMON);
                Handler.this.setTraits(attributes, inlineViewport, SUBSET_BOX);
                Handler.this.setTraits(attributes, inlineViewport, SUBSET_COLOR);
                inlineViewport.setContentPosition(XMLUtil.getAttributeAsRectangle2D(attributes, "pos"));
                inlineViewport.setClip(XMLUtil.getAttributeAsBoolean(attributes, "clip", false));
                inlineViewport.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                Area area = (Area)Handler.this.areaStack.peek();
                area.addChildArea(inlineViewport);
                Handler.this.areaStack.push(inlineViewport);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), InlineViewport.class);
            }
        }

        private class LeaderMaker
        extends AbstractMaker {
            private LeaderMaker() {
            }

            public void startElement(Attributes attributes) {
                Leader leader = new Leader();
                Handler.transferForeignObjects(attributes, leader);
                Handler.this.setAreaAttributes(attributes, leader);
                Handler.this.setTraits(attributes, leader, SUBSET_COMMON);
                Handler.this.setTraits(attributes, leader, SUBSET_BOX);
                Handler.this.setTraits(attributes, leader, SUBSET_COLOR);
                Handler.this.setTraits(attributes, leader, SUBSET_FONT);
                leader.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                String string = attributes.getValue("ruleStyle");
                if (string != null) {
                    leader.setRuleStyle(string);
                }
                leader.setRuleThickness(XMLUtil.getAttributeAsInt(attributes, "ruleThickness", 0));
                Area area = (Area)Handler.this.areaStack.peek();
                area.addChildArea(leader);
            }
        }

        private class SpaceMaker
        extends AbstractMaker {
            private SpaceMaker() {
            }

            public void endElement() {
                int n = XMLUtil.getAttributeAsInt(Handler.this.lastAttributes, "offset", 0);
                if (Handler.this.content.position() > 0) {
                    Handler.this.content.flip();
                    boolean bl = XMLUtil.getAttributeAsBoolean(Handler.this.lastAttributes, "adj", true);
                    int n2 = XMLUtil.getAttributeAsInt(Handler.this.lastAttributes, "level", -1);
                    SpaceArea spaceArea = new SpaceArea(n, n2, Handler.this.content.charAt(0), bl);
                    AbstractTextArea abstractTextArea = Handler.this.getCurrentText();
                    spaceArea.setParentArea(abstractTextArea);
                    abstractTextArea.addChildArea(spaceArea);
                } else {
                    Space space = new Space();
                    Handler.this.setAreaAttributes(Handler.this.lastAttributes, space);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_COMMON);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_BOX);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_COLOR);
                    space.setBlockProgressionOffset(n);
                    Area area = (Area)Handler.this.areaStack.peek();
                    area.addChildArea(space);
                }
            }

            public boolean ignoreCharacters() {
                return false;
            }
        }

        private class WordMaker
        extends AbstractMaker {
            private WordMaker() {
            }

            public void endElement() {
                int n = XMLUtil.getAttributeAsInt(Handler.this.lastAttributes, "offset", 0);
                int[] nArray = ConversionUtils.toIntArray(Handler.this.lastAttributes.getValue("letter-adjust"), "\\s");
                int n2 = XMLUtil.getAttributeAsInt(Handler.this.lastAttributes, "level", -1);
                boolean bl = XMLUtil.getAttributeAsBoolean(Handler.this.lastAttributes, "reversed", false);
                int[][] nArray2 = XMLUtil.getAttributeAsPositionAdjustments(Handler.this.lastAttributes, "position-adjust");
                Handler.this.content.flip();
                WordArea wordArea = new WordArea(n, n2, Handler.this.content.toString().trim(), nArray, null, nArray2, bl);
                AbstractTextArea abstractTextArea = Handler.this.getCurrentText();
                wordArea.setParentArea(abstractTextArea);
                abstractTextArea.addChildArea(wordArea);
            }

            public boolean ignoreCharacters() {
                return false;
            }
        }

        private class TextMaker
        extends AbstractMaker {
            private TextMaker() {
            }

            public void startElement(Attributes attributes) {
                if (Handler.this.getCurrentText() != null) {
                    throw new IllegalStateException("Current Text must be null");
                }
                TextArea textArea = new TextArea();
                Handler.this.setAreaAttributes(attributes, textArea);
                Handler.this.setTraits(attributes, textArea, SUBSET_COMMON);
                Handler.this.setTraits(attributes, textArea, SUBSET_BOX);
                Handler.this.setTraits(attributes, textArea, SUBSET_COLOR);
                Handler.this.setTraits(attributes, textArea, SUBSET_FONT);
                textArea.setBaselineOffset(XMLUtil.getAttributeAsInt(attributes, "baseline", 0));
                textArea.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                textArea.setTextLetterSpaceAdjust(XMLUtil.getAttributeAsInt(attributes, "tlsadjust", 0));
                textArea.setTextWordSpaceAdjust(XMLUtil.getAttributeAsInt(attributes, "twsadjust", 0));
                Area area = (Area)Handler.this.areaStack.peek();
                area.addChildArea(textArea);
                Handler.this.areaStack.push(textArea);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), TextArea.class);
            }
        }

        private class InlineBlockParentMaker
        extends AbstractMaker {
            private InlineBlockParentMaker() {
            }

            public void startElement(Attributes attributes) {
                InlineBlockParent inlineBlockParent = new InlineBlockParent();
                Handler.transferForeignObjects(attributes, inlineBlockParent);
                inlineBlockParent.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                Handler.this.setAreaAttributes(attributes, inlineBlockParent);
                Handler.this.setTraits(attributes, inlineBlockParent, SUBSET_COMMON);
                Handler.this.setTraits(attributes, inlineBlockParent, SUBSET_BOX);
                Handler.this.setTraits(attributes, inlineBlockParent, SUBSET_COLOR);
                Area area = (Area)Handler.this.areaStack.peek();
                area.addChildArea(inlineBlockParent);
                Handler.this.areaStack.push(inlineBlockParent);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), InlineBlockParent.class);
            }
        }

        private class InlineParentMaker
        extends AbstractMaker {
            private InlineParentMaker() {
            }

            public void startElement(Attributes attributes) {
                InlineParent inlineParent = new InlineParent();
                Handler.transferForeignObjects(attributes, inlineParent);
                inlineParent.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                Handler.this.setAreaAttributes(attributes, inlineParent);
                Handler.this.setTraits(attributes, inlineParent, SUBSET_COMMON);
                Handler.this.setTraits(attributes, inlineParent, SUBSET_BOX);
                Handler.this.setTraits(attributes, inlineParent, SUBSET_COLOR);
                Handler.this.setTraits(attributes, inlineParent, SUBSET_LINK);
                Area area = (Area)Handler.this.areaStack.peek();
                area.addChildArea(inlineParent);
                Handler.this.areaStack.push(inlineParent);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), InlineParent.class);
            }
        }

        private class InlineMaker
        extends AbstractMaker {
            private InlineMaker() {
            }

            public void startElement(Attributes attributes) {
                InlineArea inlineArea = new InlineArea();
                Handler.transferForeignObjects(attributes, inlineArea);
                inlineArea.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                Handler.this.setAreaAttributes(attributes, inlineArea);
                Handler.this.setTraits(attributes, inlineArea, SUBSET_COMMON);
                Handler.this.setTraits(attributes, inlineArea, SUBSET_BOX);
                Handler.this.setTraits(attributes, inlineArea, SUBSET_COLOR);
                Area area = (Area)Handler.this.areaStack.peek();
                area.addChildArea(inlineArea);
                Handler.this.areaStack.push(inlineArea);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), InlineArea.class);
            }
        }

        private class LineAreaMaker
        extends AbstractMaker {
            private LineAreaMaker() {
            }

            public void startElement(Attributes attributes) {
                LineArea lineArea = new LineArea();
                Handler.this.setAreaAttributes(attributes, lineArea);
                Handler.this.setTraits(attributes, lineArea, SUBSET_COMMON);
                Handler.this.setTraits(attributes, lineArea, SUBSET_BOX);
                Handler.this.setTraits(attributes, lineArea, SUBSET_COLOR);
                BlockParent blockParent = Handler.this.getCurrentBlockParent();
                blockParent.addChildArea(lineArea);
                Handler.this.areaStack.push(lineArea);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), LineArea.class);
            }
        }

        private class BlockMaker
        extends AbstractMaker {
            private BlockMaker() {
            }

            public void startElement(Attributes attributes) {
                Object object;
                Object object2;
                boolean bl = XMLUtil.getAttributeAsBoolean(attributes, "is-viewport-area", false);
                if (bl) {
                    object2 = new BlockViewport();
                    ((BlockViewport)object2).setClip(XMLUtil.getAttributeAsBoolean(attributes, "clipped", false));
                    ((BlockViewport)object2).setCTM(Handler.getAttributeAsCTM(attributes, "ctm"));
                    if (((Block)object2).getPositioning() != 1) {
                        ((BlockParent)object2).setXOffset(XMLUtil.getAttributeAsInt(attributes, "left-position", 0));
                        ((BlockParent)object2).setYOffset(XMLUtil.getAttributeAsInt(attributes, "top-position", 0));
                    }
                    object = object2;
                } else {
                    object = new Block();
                }
                object2 = attributes.getValue("positioning");
                if ("absolute".equalsIgnoreCase((String)object2)) {
                    ((Block)object).setPositioning(2);
                } else if ("fixed".equalsIgnoreCase((String)object2)) {
                    ((Block)object).setPositioning(3);
                } else if ("relative".equalsIgnoreCase((String)object2)) {
                    ((Block)object).setPositioning(1);
                } else {
                    ((Block)object).setPositioning(0);
                }
                if (attributes.getValue("left-offset") != null) {
                    ((BlockParent)object).setXOffset(XMLUtil.getAttributeAsInt(attributes, "left-offset", 0));
                }
                if (attributes.getValue("top-offset") != null) {
                    ((BlockParent)object).setYOffset(XMLUtil.getAttributeAsInt(attributes, "top-offset", 0));
                }
                Handler.transferForeignObjects(attributes, (AreaTreeObject)object);
                Handler.this.setAreaAttributes(attributes, (Area)object);
                Handler.this.setTraits(attributes, (Area)object, SUBSET_COMMON);
                Handler.this.setTraits(attributes, (Area)object, SUBSET_BOX);
                Handler.this.setTraits(attributes, (Area)object, SUBSET_COLOR);
                Area area = (Area)Handler.this.areaStack.peek();
                area.addChildArea((Area)object);
                Handler.this.areaStack.push(object);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), Block.class);
            }
        }

        private class BeforeFloatMaker
        extends AbstractMaker {
            private BeforeFloatMaker() {
            }

            public void startElement(Attributes attributes) {
                BeforeFloat beforeFloat = Handler.this.getCurrentBodyRegion().getBeforeFloat();
                Handler.transferForeignObjects(attributes, beforeFloat);
                Handler.this.areaStack.push(beforeFloat);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), BeforeFloat.class);
            }
        }

        private class FootnoteMaker
        extends AbstractMaker {
            private FootnoteMaker() {
            }

            public void startElement(Attributes attributes) {
                Footnote footnote = Handler.this.getCurrentBodyRegion().getFootnote();
                Handler.transferForeignObjects(attributes, footnote);
                footnote.setTop(XMLUtil.getAttributeAsInt(attributes, "top-offset", 0));
                Handler.this.areaStack.push(footnote);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), Footnote.class);
            }
        }

        private class SpanMaker
        extends AbstractMaker {
            private SpanMaker() {
            }

            public void startElement(Attributes attributes) {
                int n = XMLUtil.getAttributeAsInt(attributes, "ipd", 0);
                int n2 = XMLUtil.getAttributeAsInt(attributes, "columnCount", 1);
                BodyRegion bodyRegion = Handler.this.getCurrentBodyRegion();
                Span span = new Span(n2, bodyRegion.getColumnGap(), n);
                Handler.transferForeignObjects(attributes, span);
                Handler.this.setAreaAttributes(attributes, span);
                bodyRegion.getMainReference().getSpans().add(span);
                Handler.this.firstFlow = true;
            }
        }

        private class MainReferenceMaker
        extends AbstractMaker {
            private MainReferenceMaker() {
            }

            public void startElement(Attributes attributes) {
                MainReference mainReference = Handler.this.getCurrentBodyRegion().getMainReference();
                Handler.transferForeignObjects(attributes, mainReference);
                Handler.this.setAreaAttributes(attributes, mainReference);
            }
        }

        private class FlowMaker
        extends AbstractMaker {
            private FlowMaker() {
            }

            public void startElement(Attributes attributes) {
                BodyRegion bodyRegion = Handler.this.getCurrentBodyRegion();
                if (!Handler.this.firstFlow) {
                    bodyRegion.getMainReference().getCurrentSpan().moveToNextFlow();
                } else {
                    Handler.this.firstFlow = false;
                }
                NormalFlow normalFlow = bodyRegion.getMainReference().getCurrentSpan().getCurrentFlow();
                Handler.transferForeignObjects(attributes, normalFlow);
                Handler.this.setAreaAttributes(attributes, normalFlow);
                Handler.this.areaStack.push(normalFlow);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), NormalFlow.class);
            }
        }

        private class RegionBodyMaker
        extends AbstractMaker {
            private RegionBodyMaker() {
            }

            public void startElement(Attributes attributes) {
                BodyRegion bodyRegion = Handler.this.getCurrentBodyRegion();
                if (bodyRegion != null) {
                    throw new IllegalStateException("Current BodyRegion must be null");
                }
                String string = attributes.getValue("name");
                int n = XMLUtil.getAttributeAsInt(attributes, "columnCount", 1);
                int n2 = XMLUtil.getAttributeAsInt(attributes, "columnGap", 0);
                RegionViewport regionViewport = Handler.this.getCurrentRegionViewport();
                bodyRegion = new BodyRegion(58, string, regionViewport, n, n2);
                Handler.transferForeignObjects(attributes, bodyRegion);
                bodyRegion.setCTM(Handler.getAttributeAsCTM(attributes, "ctm"));
                Handler.this.setAreaAttributes(attributes, bodyRegion);
                Handler.this.setTraits(attributes, bodyRegion, SUBSET_BORDER_PADDING);
                regionViewport.setRegionReference(bodyRegion);
                Handler.this.currentPageViewport.getPage().setRegionViewport(58, regionViewport);
                Handler.this.areaStack.push(bodyRegion);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), BodyRegion.class);
            }
        }

        private class RegionEndMaker
        extends AbstractMaker {
            private RegionEndMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 59);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionReference.class);
            }
        }

        private class RegionStartMaker
        extends AbstractMaker {
            private RegionStartMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 61);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionReference.class);
            }
        }

        private class RegionAfterMaker
        extends AbstractMaker {
            private RegionAfterMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 56);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionReference.class);
            }
        }

        private class RegionBeforeMaker
        extends AbstractMaker {
            private RegionBeforeMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 57);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionReference.class);
            }
        }

        private class RegionViewportMaker
        extends AbstractMaker {
            private RegionViewportMaker() {
            }

            public void startElement(Attributes attributes) {
                RegionViewport regionViewport = Handler.this.getCurrentRegionViewport();
                if (regionViewport != null) {
                    throw new IllegalStateException("Current RegionViewport must be null");
                }
                Rectangle2D rectangle2D = XMLUtil.getAttributeAsRectangle2D(attributes, "rect");
                regionViewport = new RegionViewport(rectangle2D);
                Handler.transferForeignObjects(attributes, regionViewport);
                regionViewport.setClip(XMLUtil.getAttributeAsBoolean(attributes, "clipped", false));
                Handler.this.setAreaAttributes(attributes, regionViewport);
                Handler.this.setTraits(attributes, regionViewport, SUBSET_COMMON);
                Handler.this.setTraits(attributes, regionViewport, SUBSET_BOX);
                Handler.this.setTraits(attributes, regionViewport, SUBSET_COLOR);
                Handler.this.areaStack.push(regionViewport);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionViewport.class);
            }
        }

        private class PageMaker
        extends AbstractMaker {
            private PageMaker() {
            }

            public void startElement(Attributes attributes) {
                Page page = new Page();
                Handler.this.currentPageViewport.setPage(page);
            }

            public void endElement() {
                Handler.this.treeModel.addPage(Handler.this.currentPageViewport);
                Handler.this.currentPageViewport = null;
            }
        }

        private class PageViewportMaker
        extends AbstractMaker {
            private PageViewportMaker() {
            }

            public void startElement(Attributes attributes) {
                Cloneable cloneable;
                if (!Handler.this.areaStack.isEmpty()) {
                    cloneable = (PageSequence)Handler.this.areaStack.peek();
                    Handler.this.treeModel.startPageSequence((PageSequence)cloneable);
                    Handler.this.areaStack.pop();
                }
                if (Handler.this.currentPageViewport != null) {
                    throw new IllegalStateException("currentPageViewport must be null");
                }
                cloneable = XMLUtil.getAttributeAsRectangle(attributes, "bounds");
                int n = XMLUtil.getAttributeAsInt(attributes, "nr", -1);
                String string = attributes.getValue("key");
                String string2 = attributes.getValue("formatted-nr");
                String string3 = attributes.getValue("simple-page-master-name");
                boolean bl = XMLUtil.getAttributeAsBoolean(attributes, "blank", false);
                Handler.this.currentPageViewport = new PageViewport((Rectangle)cloneable, n, string2, string3, bl);
                Handler.transferForeignObjects(attributes, Handler.this.currentPageViewport);
                Handler.this.currentPageViewport.setKey(string);
                Handler.this.pageViewportsByKey.put(string, Handler.this.currentPageViewport);
            }
        }

        private class TitleMaker
        extends AbstractMaker {
            private TitleMaker() {
            }

            public void startElement(Attributes attributes) {
                LineArea lineArea = new LineArea();
                Handler.transferForeignObjects(attributes, lineArea);
                Handler.this.areaStack.push(lineArea);
            }

            public void endElement() {
                LineArea lineArea = (LineArea)Handler.this.areaStack.pop();
                PageSequence pageSequence = (PageSequence)Handler.this.areaStack.peek();
                pageSequence.setTitle(lineArea);
            }
        }

        private class PageSequenceMaker
        extends AbstractMaker {
            private PageSequenceMaker() {
            }

            public void startElement(Attributes attributes) {
                PageSequence pageSequence = new PageSequence(null);
                String string = attributes.getValue("language");
                pageSequence.setLanguage(string);
                String string2 = attributes.getValue("country");
                pageSequence.setCountry(string2);
                Handler.transferForeignObjects(attributes, pageSequence);
                Handler.this.areaStack.push(pageSequence);
            }
        }

        private class AreaTreeMaker
        extends AbstractMaker {
            private AreaTreeMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.idFirstsAssigned.clear();
            }
        }

        private abstract class AbstractMaker
        implements Maker {
            private AbstractMaker() {
            }

            public void startElement(Attributes attributes) throws SAXException {
            }

            public void endElement() {
            }

            public boolean ignoreCharacters() {
                return true;
            }
        }

        private static interface Maker {
            public void startElement(Attributes var1) throws SAXException;

            public void endElement();

            public boolean ignoreCharacters();
        }
    }
}

