/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.Resolvable;
import org.apache.fop.area.Span;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.traits.WritingModeTraitsGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageViewport
extends AreaTreeObject
implements Resolvable {
    private Page page;
    private Rectangle viewArea;
    private String simplePageMasterName;
    private String pageKey;
    private int pageNumber = -1;
    private String pageNumberString = null;
    private int pageIndex = -1;
    private boolean blank;
    private transient PageSequence pageSequence;
    private Set<String> idFirsts = new HashSet<String>();
    private Map<String, List<Resolvable>> unresolvedIDRefs = new HashMap<String, List<Resolvable>>();
    private Map<String, List<PageViewport>> pendingResolved = null;
    private Map<String, Marker> markerFirstStart = null;
    private Map<String, Marker> markerLastStart = null;
    private Map<String, Marker> markerFirstAny = null;
    private Map<String, Marker> markerLastEnd = null;
    private Map<String, Marker> markerLastAny = null;
    protected static final Log log = LogFactory.getLog(PageViewport.class);

    public PageViewport(SimplePageMaster simplePageMaster, int n, String string, boolean bl, boolean bl2) {
        this.simplePageMasterName = simplePageMaster.getMasterName();
        this.setExtensionAttachments(simplePageMaster.getExtensionAttachments());
        this.setForeignAttributes(simplePageMaster.getForeignAttributes());
        this.blank = bl;
        int n2 = simplePageMaster.getPageWidth().getValue();
        int n3 = simplePageMaster.getPageHeight().getValue();
        this.pageNumber = n;
        this.pageNumberString = string;
        this.viewArea = new Rectangle(0, 0, n2, n3);
        this.page = new Page(simplePageMaster);
        this.createSpan(bl2);
    }

    public PageViewport(SimplePageMaster simplePageMaster, int n, String string, boolean bl) {
        this(simplePageMaster, n, string, bl, false);
    }

    public PageViewport(PageViewport pageViewport) throws FOPException {
        if (pageViewport.extensionAttachments != null) {
            this.setExtensionAttachments(pageViewport.extensionAttachments);
        }
        if (pageViewport.foreignAttributes != null) {
            this.setForeignAttributes(pageViewport.foreignAttributes);
        }
        this.pageIndex = pageViewport.pageIndex;
        this.pageNumber = pageViewport.pageNumber;
        this.pageNumberString = pageViewport.pageNumberString;
        try {
            this.page = (Page)pageViewport.page.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new FOPException(cloneNotSupportedException);
        }
        this.viewArea = new Rectangle(pageViewport.viewArea);
        this.simplePageMasterName = pageViewport.simplePageMasterName;
        this.blank = pageViewport.blank;
    }

    public PageViewport(Rectangle rectangle, int n, String string, String string2, boolean bl) {
        this.viewArea = rectangle;
        this.pageNumber = n;
        this.pageNumberString = string;
        this.simplePageMasterName = string2;
        this.blank = bl;
    }

    public void setPageSequence(PageSequence pageSequence) {
        this.pageSequence = pageSequence;
    }

    public PageSequence getPageSequence() {
        return this.pageSequence;
    }

    public Rectangle getViewArea() {
        return this.viewArea;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public String getPageNumberString() {
        return this.pageNumberString;
    }

    public void setPageIndex(int n) {
        this.pageIndex = n;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setKey(String string) {
        this.pageKey = string;
    }

    public String getKey() {
        if (this.pageKey == null) {
            throw new IllegalStateException("No page key set on the PageViewport: " + this.toString());
        }
        return this.pageKey;
    }

    public void setFirstWithID(String string) {
        if (string != null) {
            this.idFirsts.add(string);
        }
    }

    public boolean isFirstWithID(String string) {
        return this.idFirsts.contains(string);
    }

    public void addUnresolvedIDRef(String string, Resolvable resolvable) {
        List<Resolvable> list;
        if (this.unresolvedIDRefs == null) {
            this.unresolvedIDRefs = new HashMap<String, List<Resolvable>>();
        }
        if ((list = this.unresolvedIDRefs.get(string)) == null) {
            list = new ArrayList<Resolvable>();
            this.unresolvedIDRefs.put(string, list);
        }
        list.add(resolvable);
    }

    @Override
    public boolean isResolved() {
        return this.unresolvedIDRefs == null || this.unresolvedIDRefs.size() == 0;
    }

    @Override
    public String[] getIDRefs() {
        return this.unresolvedIDRefs == null ? null : this.unresolvedIDRefs.keySet().toArray(new String[this.unresolvedIDRefs.keySet().size()]);
    }

    @Override
    public void resolveIDRef(String string, List<PageViewport> list) {
        List<Resolvable> list2;
        if (this.page == null) {
            if (this.pendingResolved == null) {
                this.pendingResolved = new HashMap<String, List<PageViewport>>();
            }
            this.pendingResolved.put(string, list);
        } else if (this.unresolvedIDRefs != null && (list2 = this.unresolvedIDRefs.get(string)) != null) {
            for (Resolvable resolvable : list2) {
                resolvable.resolveIDRef(string, list);
            }
        }
        if (this.unresolvedIDRefs != null && list != null) {
            this.unresolvedIDRefs.remove(string);
            if (this.unresolvedIDRefs.isEmpty()) {
                this.unresolvedIDRefs = null;
            }
        }
    }

    public void addMarkers(Map<String, Marker> map, boolean bl, boolean bl2, boolean bl3) {
        if (map == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("--" + map.keySet() + ": " + (bl ? "starting" : "ending") + (bl2 ? ", first" : "") + (bl3 ? ", last" : "")));
        }
        if (bl) {
            if (bl2) {
                if (this.markerFirstStart == null) {
                    this.markerFirstStart = new HashMap<String, Marker>();
                }
                if (this.markerFirstAny == null) {
                    this.markerFirstAny = new HashMap<String, Marker>();
                }
                for (String string : map.keySet()) {
                    if (!this.markerFirstStart.containsKey(string)) {
                        this.markerFirstStart.put(string, map.get(string));
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("page " + this.pageNumberString + ": " + "Adding marker " + string + " to FirstStart"));
                        }
                    }
                    if (this.markerFirstAny.containsKey(string)) continue;
                    this.markerFirstAny.put(string, map.get(string));
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("page " + this.pageNumberString + ": " + "Adding marker " + string + " to FirstAny"));
                }
                if (this.markerLastStart == null) {
                    this.markerLastStart = new HashMap<String, Marker>();
                }
                this.markerLastStart.putAll(map);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("page " + this.pageNumberString + ": " + "Adding all markers to LastStart"));
                }
            } else {
                if (this.markerFirstAny == null) {
                    this.markerFirstAny = new HashMap<String, Marker>();
                }
                for (String string : map.keySet()) {
                    if (this.markerFirstAny.containsKey(string)) continue;
                    this.markerFirstAny.put(string, map.get(string));
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("page " + this.pageNumberString + ": " + "Adding marker " + string + " to FirstAny"));
                }
            }
        } else {
            if (bl3) {
                if (this.markerLastEnd == null) {
                    this.markerLastEnd = new HashMap<String, Marker>();
                }
                this.markerLastEnd.putAll(map);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("page " + this.pageNumberString + ": " + "Adding all markers to LastEnd"));
                }
            }
            if (this.markerLastAny == null) {
                this.markerLastAny = new HashMap<String, Marker>();
            }
            this.markerLastAny.putAll(map);
            if (log.isTraceEnabled()) {
                log.trace((Object)("page " + this.pageNumberString + ": " + "Adding all markers to LastAny"));
            }
        }
    }

    public Marker getMarker(String string, int n) {
        Marker marker = null;
        String string2 = null;
        switch (n) {
            case 54: {
                if (this.markerFirstStart != null) {
                    marker = this.markerFirstStart.get(string);
                    string2 = "FSWP";
                }
                if (marker != null || this.markerFirstAny == null) break;
                marker = this.markerFirstAny.get(string);
                string2 = "FirstAny after " + string2;
                break;
            }
            case 49: {
                if (this.markerFirstAny == null) break;
                marker = this.markerFirstAny.get(string);
                string2 = "FIC";
                break;
            }
            case 81: {
                if (this.markerLastStart != null) {
                    marker = this.markerLastStart.get(string);
                    string2 = "LSWP";
                }
                if (marker != null || this.markerLastAny == null) break;
                marker = this.markerLastAny.get(string);
                string2 = "LastAny after " + string2;
                break;
            }
            case 74: {
                if (this.markerLastEnd != null) {
                    marker = this.markerLastEnd.get(string);
                    string2 = "LEWP";
                }
                if (marker != null || this.markerLastAny == null) break;
                marker = this.markerLastAny.get(string);
                string2 = "LastAny after " + string2;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("page " + this.pageNumberString + ": " + "Retrieving marker " + string + " at position " + string2));
        }
        return marker;
    }

    public void dumpMarkers() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("FirstAny: " + this.markerFirstAny));
            log.trace((Object)("FirstStart: " + this.markerFirstStart));
            log.trace((Object)("LastAny: " + this.markerLastAny));
            log.trace((Object)("LastEnd: " + this.markerLastEnd));
            log.trace((Object)("LastStart: " + this.markerLastStart));
        }
    }

    public void savePage(ObjectOutputStream objectOutputStream) throws IOException {
        this.page.setUnresolvedReferences(this.unresolvedIDRefs);
        objectOutputStream.writeObject(this.page);
        this.page = null;
    }

    public void loadPage(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.page = (Page)objectInputStream.readObject();
        this.unresolvedIDRefs = this.page.getUnresolvedReferences();
        if (this.unresolvedIDRefs != null && this.pendingResolved != null) {
            for (String string : this.pendingResolved.keySet()) {
                this.resolveIDRef(string, this.pendingResolved.get(string));
            }
            this.pendingResolved = null;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PageViewport pageViewport = (PageViewport)super.clone();
        pageViewport.page = (Page)this.page.clone();
        pageViewport.viewArea = (Rectangle)this.viewArea.clone();
        return pageViewport;
    }

    public void clear() {
        this.page = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("PageViewport: page=");
        stringBuffer.append(this.getPageNumberString());
        return stringBuffer.toString();
    }

    public String getSimplePageMasterName() {
        return this.simplePageMasterName;
    }

    public boolean isBlank() {
        return this.blank;
    }

    public BodyRegion getBodyRegion() {
        return (BodyRegion)this.getPage().getRegionViewport(58).getRegionReference();
    }

    public Span createSpan(boolean bl) {
        return this.getBodyRegion().getMainReference().createSpan(bl);
    }

    public Span getCurrentSpan() {
        return this.getBodyRegion().getMainReference().getCurrentSpan();
    }

    public NormalFlow getCurrentFlow() {
        return this.getCurrentSpan().getCurrentFlow();
    }

    public NormalFlow moveToNextFlow() {
        return this.getCurrentSpan().moveToNextFlow();
    }

    public RegionReference getRegionReference(int n) {
        return this.getPage().getRegionViewport(n).getRegionReference();
    }

    public void setWritingModeTraits(WritingModeTraitsGetter writingModeTraitsGetter) {
        if (this.page != null) {
            this.page.setWritingModeTraits(writingModeTraitsGetter);
        }
    }
}

