/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.Trait;
import org.apache.fop.traits.WritingModeTraitsGetter;

public class Span
extends Area {
    private static final long serialVersionUID = -5551430053660081549L;
    private List<NormalFlow> flowAreas;
    private int colCount;
    private int colGap;
    private int colWidth;
    private int curFlowIdx;

    public Span(int n, int n2, int n3) {
        this.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
        this.colCount = n;
        this.colGap = n2;
        this.ipd = n3;
        this.curFlowIdx = 0;
        this.createNormalFlows();
    }

    private void createNormalFlows() {
        this.flowAreas = new ArrayList<NormalFlow>(this.colCount);
        this.colWidth = (this.ipd - (this.colCount - 1) * this.colGap) / this.colCount;
        for (int i = 0; i < this.colCount; ++i) {
            NormalFlow normalFlow = new NormalFlow(this.colWidth);
            this.flowAreas.add(normalFlow);
        }
    }

    public int getColumnCount() {
        return this.colCount;
    }

    public int getColumnWidth() {
        return this.colWidth;
    }

    public int getHeight() {
        return this.getBPD();
    }

    public NormalFlow getNormalFlow(int n) {
        if (n >= 0 && n < this.colCount) {
            return this.flowAreas.get(n);
        }
        throw new IllegalArgumentException("Invalid column number " + n + " requested; only 0-" + (this.colCount - 1) + " available.");
    }

    public NormalFlow getCurrentFlow() {
        return this.getNormalFlow(this.curFlowIdx);
    }

    public int getCurrentFlowIndex() {
        return this.curFlowIdx;
    }

    public NormalFlow moveToNextFlow() {
        if (this.hasMoreFlows()) {
            ++this.curFlowIdx;
            return this.getNormalFlow(this.curFlowIdx);
        }
        throw new IllegalStateException("(Internal error.) No more flows left in span.");
    }

    public boolean hasMoreFlows() {
        return this.curFlowIdx < this.colCount - 1;
    }

    public void notifyFlowsFinished() {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this.colCount; ++i) {
            n = Math.max(n, this.getNormalFlow(i).getAllocBPD());
        }
        this.bpd = n;
    }

    public boolean isEmpty() {
        int n = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            NormalFlow normalFlow = this.getNormalFlow(i);
            if (normalFlow == null || normalFlow.getChildAreas() == null) continue;
            n += normalFlow.getChildAreas().size();
        }
        return n == 0;
    }

    public void setWritingModeTraits(WritingModeTraitsGetter writingModeTraitsGetter) {
        switch (writingModeTraitsGetter.getColumnProgressionDirection().getEnumValue()) {
            case 202: {
                this.setBidiLevel(1);
                Iterator<NormalFlow> iterator = this.flowAreas.iterator();
                while (iterator.hasNext()) {
                    iterator.next().setBidiLevel(1);
                }
                break;
            }
            default: {
                this.resetBidiLevel();
                Iterator<NormalFlow> iterator = this.flowAreas.iterator();
                while (iterator.hasNext()) {
                    iterator.next().resetBidiLevel();
                }
                break block0;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.colCount > 1) {
            stringBuffer.append(" {colCount=").append(this.colCount);
            stringBuffer.append(", colWidth=").append(this.colWidth);
            stringBuffer.append(", curFlowIdx=").append(this.curFlowIdx);
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }
}

