/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;

public abstract class AbstractTextArea
extends InlineParent {
    private static final long serialVersionUID = -1246306443569094371L;
    private int textWordSpaceAdjust = 0;
    private int textLetterSpaceAdjust = 0;
    private TextAdjustingInfo textAdjustingInfo = null;
    private int baselineOffset = 0;

    public AbstractTextArea() {
    }

    public AbstractTextArea(int n, int n2, int n3) {
        this.textAdjustingInfo = new TextAdjustingInfo(n, n2, n3);
    }

    public int getTextWordSpaceAdjust() {
        return this.textWordSpaceAdjust;
    }

    public void setTextWordSpaceAdjust(int n) {
        this.textWordSpaceAdjust = n;
    }

    public int getTextLetterSpaceAdjust() {
        return this.textLetterSpaceAdjust;
    }

    public void setTextLetterSpaceAdjust(int n) {
        this.textLetterSpaceAdjust = n;
    }

    public void setSpaceDifference(int n) {
        this.textAdjustingInfo.spaceDifference = n;
    }

    public boolean applyVariationFactor(double d, int n, int n2) {
        if (this.textAdjustingInfo != null) {
            double d2 = 1.0;
            if (d < 0.0) {
                d2 = this.textWordSpaceAdjust < 0 ? (double)this.textAdjustingInfo.availableStretch / (double)this.textAdjustingInfo.availableShrink * ((double)n2 / (double)n) : (double)this.textAdjustingInfo.availableShrink / (double)this.textAdjustingInfo.availableStretch * ((double)n / (double)n2);
            }
            this.textWordSpaceAdjust = (int)((double)(this.textWordSpaceAdjust - this.textAdjustingInfo.spaceDifference) * d * d2) + this.textAdjustingInfo.spaceDifference;
            this.textLetterSpaceAdjust = (int)((double)this.textLetterSpaceAdjust * d);
            int n3 = this.textAdjustingInfo.adjustment;
            this.textAdjustingInfo.adjustment = (int)((double)this.textAdjustingInfo.adjustment * (d2 * d));
            this.ipd += this.textAdjustingInfo.adjustment - n3;
        }
        return false;
    }

    public int getBaselineOffset() {
        return this.baselineOffset;
    }

    public void setBaselineOffset(int n) {
        this.baselineOffset = n;
    }

    int getVirtualOffset() {
        return this.getBlockProgressionOffset();
    }

    int getVirtualBPD() {
        return this.getBPD();
    }

    protected class TextAdjustingInfo
    extends InlineArea.InlineAdjustingInfo {
        private static final long serialVersionUID = -2412095162983479947L;
        protected int spaceDifference;

        protected TextAdjustingInfo(int n, int n2, int n3) {
            super(AbstractTextArea.this, n, n2, n3);
            this.spaceDifference = 0;
        }
    }
}

