/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.util.Arrays;
import java.util.List;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.complexscripts.bidi.InlineRun;
import org.apache.fop.complexscripts.util.CharMirror;

public class WordArea
extends InlineArea {
    private static final long serialVersionUID = 6444644662158970942L;
    protected String word;
    protected int[] letterAdjust;
    protected int[] levels;
    protected int[][] gposAdjustments;
    protected boolean reversed;

    public WordArea(int n, int n2, String string, int[] nArray, int[] nArray2, int[][] nArray3, boolean bl) {
        super(n, n2);
        int n3 = string != null ? string.length() : 0;
        this.word = string;
        this.letterAdjust = WordArea.maybeAdjustLength(nArray, n3);
        this.levels = WordArea.maybePopulateLevels(nArray2, n2, n3);
        this.gposAdjustments = WordArea.maybeAdjustLength(nArray3, n3);
        this.reversed = bl;
    }

    public WordArea(int n, int n2, String string, int[] nArray, int[] nArray2, int[][] nArray3) {
        this(n, n2, string, nArray, nArray2, nArray3, false);
    }

    public String getWord() {
        return this.word;
    }

    public int[] getLetterAdjustArray() {
        return this.letterAdjust;
    }

    public int[] getBidiLevels() {
        return this.levels;
    }

    public int[] getBidiLevels(int n, int n2) {
        assert (n <= n2);
        if (this.levels != null) {
            int n3 = n2 - n;
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = this.levels[n + i];
            }
            return nArray;
        }
        return null;
    }

    public int bidiLevelAt(int n) {
        if (n > this.word.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.levels != null) {
            return this.levels[n];
        }
        return -1;
    }

    public List collectInlineRuns(List list) {
        assert (list != null);
        InlineRun inlineRun = this.getBidiLevels() != null ? new InlineRun(this, this.getBidiLevels()) : new InlineRun(this, -1, this.word.length());
        list.add(inlineRun);
        return list;
    }

    public int[][] getGlyphPositionAdjustments() {
        return this.gposAdjustments;
    }

    public int[] glyphPositionAdjustmentsAt(int n) {
        if (n > this.word.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.gposAdjustments != null) {
            return this.gposAdjustments[n];
        }
        return null;
    }

    public void reverse(boolean bl) {
        if (this.word.length() > 0) {
            this.word = new StringBuffer(this.word).reverse().toString();
            if (this.levels != null) {
                WordArea.reverse(this.levels);
            }
            if (this.gposAdjustments != null) {
                WordArea.reverse(this.gposAdjustments);
            }
            boolean bl2 = this.reversed = !this.reversed;
            if (bl) {
                this.word = CharMirror.mirror(this.word);
            }
        }
    }

    public void mirror() {
        if (this.word.length() > 0) {
            this.word = CharMirror.mirror(this.word);
        }
    }

    public boolean isReversed() {
        return this.reversed;
    }

    private static int[] maybeAdjustLength(int[] nArray, int n) {
        if (nArray != null) {
            if (nArray.length == n) {
                return nArray;
            }
            int[] nArray2 = new int[n];
            int n2 = nArray.length;
            for (int i = 0; i < n2 && i < n; ++i) {
                nArray2[i] = nArray[i];
            }
            return nArray2;
        }
        return nArray;
    }

    private static int[][] maybeAdjustLength(int[][] nArray, int n) {
        if (nArray != null) {
            if (nArray.length == n) {
                return nArray;
            }
            int[][] nArrayArray = new int[n][];
            int n2 = nArray.length;
            for (int i = 0; i < n2 && i < n; ++i) {
                nArrayArray[i] = nArray[i];
            }
            return nArrayArray;
        }
        return nArray;
    }

    private static int[] maybePopulateLevels(int[] nArray, int n, int n2) {
        if (nArray == null && n >= 0) {
            nArray = new int[n2];
            Arrays.fill(nArray, n);
        }
        return WordArea.maybeAdjustLength(nArray, n2);
    }

    private static void reverse(int[] nArray) {
        int n = nArray.length;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i - 1;
            int n4 = nArray[n3];
            nArray[n3] = nArray[i];
            nArray[i] = n4;
        }
    }

    private static void reverse(int[][] nArray) {
        int n = nArray.length;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i - 1;
            int[] nArray2 = nArray[n3];
            nArray[n3] = nArray[i];
            nArray[i] = nArray2;
        }
    }
}

