/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.fo.flow.AbstractPageNumberCitation;
import org.apache.fop.fo.flow.BidiOverride;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.Leader;

class TextInterval {
    private FONode fn;
    private int textStart;
    private int start;
    private int end;
    private int level;

    TextInterval(FONode fONode, int n, int n2) {
        this(fONode, n, n, n2, -1);
    }

    TextInterval(FONode fONode, int n, int n2, int n3, int n4) {
        this.fn = fONode;
        this.textStart = n;
        this.start = n2;
        this.end = n3;
        this.level = n4;
    }

    FONode getNode() {
        return this.fn;
    }

    int getTextStart() {
        return this.textStart;
    }

    int getStart() {
        return this.start;
    }

    int getEnd() {
        return this.end;
    }

    int getLevel() {
        return this.level;
    }

    void setLevel(int n) {
        this.level = n;
    }

    public int length() {
        return this.end - this.start;
    }

    public String getText() {
        if (this.fn instanceof FOText) {
            return ((FOText)this.fn).getCharSequence().toString();
        }
        if (this.fn instanceof Character) {
            return new String(new char[]{((Character)this.fn).getCharacter()});
        }
        return null;
    }

    public void assignTextLevels() {
        if (this.fn instanceof FOText) {
            ((FOText)this.fn).setBidiLevel(this.level, this.start - this.textStart, this.end - this.textStart);
        } else if (this.fn instanceof Character) {
            ((Character)this.fn).setBidiLevel(this.level);
        } else if (this.fn instanceof AbstractPageNumberCitation) {
            ((AbstractPageNumberCitation)this.fn).setBidiLevel(this.level);
        } else if (this.fn instanceof AbstractGraphics) {
            ((AbstractGraphics)this.fn).setBidiLevel(this.level);
        } else if (this.fn instanceof Leader) {
            ((Leader)this.fn).setBidiLevel(this.level);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof TextInterval) {
            TextInterval textInterval = (TextInterval)object;
            if (textInterval.getNode() != this.fn) {
                return false;
            }
            if (textInterval.getStart() != this.start) {
                return false;
            }
            return textInterval.getEnd() == this.end;
        }
        return false;
    }

    public int hashCode() {
        int n = this.fn != null ? this.fn.hashCode() : 0;
        n = (n ^ this.start) + (n << 19);
        n = (n ^ this.end) + (n << 11);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.fn instanceof FOText ? 84 : (this.fn instanceof Character ? 67 : (this.fn instanceof BidiOverride ? 66 : (this.fn instanceof AbstractPageNumberCitation ? 35 : (this.fn instanceof AbstractGraphics ? 71 : (this.fn instanceof Leader ? 76 : 63)))));
        stringBuffer.append((char)n);
        stringBuffer.append("[" + this.start + "," + this.end + "][" + this.textStart + "](" + this.level + ")");
        return stringBuffer.toString();
    }
}

