/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphClassTable;
import org.apache.fop.complexscripts.fonts.GlyphCoverageTable;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionState;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionSubtable;
import org.apache.fop.complexscripts.fonts.GlyphSubtable;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.scripts.ScriptProcessor;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.GlyphTester;

public class GlyphSubstitutionTable
extends GlyphTable {
    private static final Log log = LogFactory.getLog(GlyphSubstitutionTable.class);
    public static final int GSUB_LOOKUP_TYPE_SINGLE = 1;
    public static final int GSUB_LOOKUP_TYPE_MULTIPLE = 2;
    public static final int GSUB_LOOKUP_TYPE_ALTERNATE = 3;
    public static final int GSUB_LOOKUP_TYPE_LIGATURE = 4;
    public static final int GSUB_LOOKUP_TYPE_CONTEXTUAL = 5;
    public static final int GSUB_LOOKUP_TYPE_CHAINED_CONTEXTUAL = 6;
    public static final int GSUB_LOOKUP_TYPE_EXTENSION_SUBSTITUTION = 7;
    public static final int GSUB_LOOKUP_TYPE_REVERSE_CHAINED_SINGLE = 8;

    public GlyphSubstitutionTable(GlyphDefinitionTable glyphDefinitionTable, Map map, List list) {
        super(glyphDefinitionTable, map);
        if (list == null || list.size() == 0) {
            throw new AdvancedTypographicTableFormatException("subtables must be non-empty");
        }
        for (Object e : list) {
            if (e instanceof GlyphSubstitutionSubtable) {
                this.addSubtable((GlyphSubtable)e);
                continue;
            }
            throw new AdvancedTypographicTableFormatException("subtable must be a glyph substitution subtable");
        }
        this.freezeSubtables();
    }

    public GlyphSequence substitute(GlyphSequence glyphSequence, String string, String string2) {
        GlyphSequence glyphSequence2;
        Map map = this.matchLookups(string, string2, "*");
        if (map != null && map.size() > 0) {
            ScriptProcessor scriptProcessor = ScriptProcessor.getInstance(string);
            glyphSequence2 = scriptProcessor.substitute(this, glyphSequence, string, string2, map);
        } else {
            glyphSequence2 = glyphSequence;
        }
        return glyphSequence2;
    }

    public static int getLookupTypeFromName(String string) {
        String string2 = string.toLowerCase();
        int n = "single".equals(string2) ? 1 : ("multiple".equals(string2) ? 2 : ("alternate".equals(string2) ? 3 : ("ligature".equals(string2) ? 4 : ("contextual".equals(string2) ? 5 : ("chainedcontextual".equals(string2) ? 6 : ("extensionsubstitution".equals(string2) ? 7 : ("reversechainiingcontextualsingle".equals(string2) ? 8 : -1)))))));
        return n;
    }

    public static String getLookupTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "single";
                break;
            }
            case 2: {
                string = "multiple";
                break;
            }
            case 3: {
                string = "alternate";
                break;
            }
            case 4: {
                string = "ligature";
                break;
            }
            case 5: {
                string = "contextual";
                break;
            }
            case 6: {
                string = "chainedcontextual";
                break;
            }
            case 7: {
                string = "extensionsubstitution";
                break;
            }
            case 8: {
                string = "reversechainiingcontextualsingle";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    public static GlyphSubtable createSubtable(int n, String string, int n2, int n3, int n4, GlyphCoverageTable glyphCoverageTable, List list) {
        GlyphSubstitutionSubtable glyphSubstitutionSubtable = null;
        switch (n) {
            case 1: {
                glyphSubstitutionSubtable = SingleSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 2: {
                glyphSubstitutionSubtable = MultipleSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 3: {
                glyphSubstitutionSubtable = AlternateSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 4: {
                glyphSubstitutionSubtable = LigatureSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 5: {
                glyphSubstitutionSubtable = ContextualSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 6: {
                glyphSubstitutionSubtable = ChainedContextualSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 8: {
                glyphSubstitutionSubtable = ReverseChainedSingleSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
        }
        return glyphSubstitutionSubtable;
    }

    public static GlyphSubtable createSubtable(int n, String string, int n2, int n3, int n4, List list, List list2) {
        return GlyphSubstitutionTable.createSubtable(n, string, n2, n3, n4, GlyphCoverageTable.createCoverageTable(list), list2);
    }

    public static class LigatureSet {
        private final Ligature[] ligatures;
        private final int maxComponents;

        public LigatureSet(List list) {
            this(list.toArray(new Ligature[list.size()]));
        }

        public LigatureSet(Ligature[] ligatureArray) {
            if (ligatureArray == null) {
                throw new AdvancedTypographicTableFormatException("invalid ligatures, must be non-null array");
            }
            this.ligatures = ligatureArray;
            int n = -1;
            for (Ligature ligature : ligatureArray) {
                int n2 = ligature.getNumComponents() + 1;
                if (n2 <= n) continue;
                n = n2;
            }
            this.maxComponents = n;
        }

        public Ligature[] getLigatures() {
            return this.ligatures;
        }

        public int getNumLigatures() {
            return this.ligatures.length;
        }

        public int getMaxComponents() {
            return this.maxComponents;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ligs={");
            int n = this.ligatures.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.ligatures[i]);
            }
            stringBuffer.append("}}");
            return stringBuffer.toString();
        }
    }

    public static class Ligature {
        private final int ligature;
        private final int[] components;

        public Ligature(int n, int[] nArray) {
            if (n < 0 || n > 65535) {
                throw new AdvancedTypographicTableFormatException("invalid ligature glyph index: " + n);
            }
            if (nArray == null) {
                throw new AdvancedTypographicTableFormatException("invalid ligature components, must be non-null array");
            }
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray[i];
                if (n3 >= 0 && n3 <= 65535) continue;
                throw new AdvancedTypographicTableFormatException("invalid component glyph index: " + n3);
            }
            this.ligature = n;
            this.components = nArray;
        }

        public int getLigature() {
            return this.ligature;
        }

        public int[] getComponents() {
            return this.components;
        }

        public int getNumComponents() {
            return this.components.length;
        }

        public boolean matchesComponents(int[] nArray) {
            if (nArray.length < this.components.length + 1) {
                return false;
            }
            int n = this.components.length;
            for (int i = 0; i < n; ++i) {
                if (nArray[i + 1] == this.components[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{components={");
            int n = this.components.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(Integer.toString(this.components[i]));
            }
            stringBuffer.append("},ligature=");
            stringBuffer.append(Integer.toString(this.ligature));
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    private static class ReverseChainedSingleSubtableFormat1
    extends ReverseChainedSingleSubtable {
        ReverseChainedSingleSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            return null;
        }

        private void populate(List list) {
        }
    }

    private static abstract class ReverseChainedSingleSubtable
    extends GlyphSubstitutionSubtable {
        public ReverseChainedSingleSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 8;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof ReverseChainedSingleSubtable;
        }

        public boolean usesReverseScan() {
            return true;
        }

        static GlyphSubstitutionSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new ReverseChainedSingleSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class ChainedContextualSubtableFormat3
    extends ChainedContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ChainedContextualSubtableFormat3(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> arrayList = new ArrayList<GlyphTable.RuleSet[]>(1);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphSubstitutionState glyphSubstitutionState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphSubstitutionState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    GlyphCoverageTable[] glyphCoverageTableArray;
                    GlyphCoverageTable[] glyphCoverageTableArray2;
                    GlyphTable.ChainedCoverageSequenceRule chainedCoverageSequenceRule;
                    GlyphCoverageTable[] glyphCoverageTableArray3;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedCoverageSequenceRule) || !this.matches(glyphSubstitutionState, glyphCoverageTableArray3 = (chainedCoverageSequenceRule = (GlyphTable.ChainedCoverageSequenceRule)rule).getCoverages(), 0, nArray) || !this.matches(glyphSubstitutionState, glyphCoverageTableArray2 = chainedCoverageSequenceRule.getBacktrackCoverages(), -1, null) || !this.matches(glyphSubstitutionState, glyphCoverageTableArray = chainedCoverageSequenceRule.getLookaheadCoverages(), nArray[0], null)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        private boolean matches(GlyphSubstitutionState glyphSubstitutionState, GlyphCoverageTable[] glyphCoverageTableArray, int n, int[] nArray) {
            return ContextualSubtableFormat3.matches(glyphSubstitutionState, glyphCoverageTableArray, n, nArray);
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
        }
    }

    private static class ChainedContextualSubtableFormat2
    extends ChainedContextualSubtable {
        private GlyphClassTable icdt;
        private GlyphClassTable bcdt;
        private GlyphClassTable lcdt;
        private int ngc;
        private GlyphTable.RuleSet[] rsa;

        ChainedContextualSubtableFormat2(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(5);
                arrayList.add(this.icdt);
                arrayList.add(this.bcdt);
                arrayList.add(this.lcdt);
                arrayList.add(this.ngc);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphSubstitutionState glyphSubstitutionState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphSubstitutionState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    int[] nArray2;
                    int[] nArray3;
                    GlyphTable.ChainedClassSequenceRule chainedClassSequenceRule;
                    int[] nArray4;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedClassSequenceRule) || !this.matches(glyphSubstitutionState, this.icdt, nArray4 = (chainedClassSequenceRule = (GlyphTable.ChainedClassSequenceRule)rule).getClasses(this.icdt.getClassIndex(n2, glyphSubstitutionState.getClassMatchSet(n2))), 0, nArray) || !this.matches(glyphSubstitutionState, this.bcdt, nArray3 = chainedClassSequenceRule.getBacktrackClasses(), -1, null) || !this.matches(glyphSubstitutionState, this.lcdt, nArray2 = chainedClassSequenceRule.getLookaheadClasses(), nArray[0], null)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        private boolean matches(GlyphSubstitutionState glyphSubstitutionState, GlyphClassTable glyphClassTable, int[] nArray, int n, int[] nArray2) {
            return ContextualSubtableFormat2.matches(glyphSubstitutionState, glyphClassTable, nArray, n, nArray2);
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 5) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 5 entries");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an GlyphClassTable, but is: " + (e != null ? e.getClass() : null));
            }
            this.icdt = (GlyphClassTable)e;
            e = list.get(1);
            if (e != null && !(e instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, second entry must be an GlyphClassTable, but is: " + e.getClass());
            }
            this.bcdt = (GlyphClassTable)e;
            e = list.get(2);
            if (e != null && !(e instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, third entry must be an GlyphClassTable, but is: " + e.getClass());
            }
            this.lcdt = (GlyphClassTable)e;
            e = list.get(3);
            if (e == null || !(e instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fourth entry must be an Integer, but is: " + (e != null ? e.getClass() : null));
            }
            this.ngc = (Integer)e;
            e = list.get(4);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fifth entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
            if (this.rsa.length != this.ngc) {
                throw new AdvancedTypographicTableFormatException("illegal entries, RuleSet[] length is " + this.rsa.length + ", but expected " + this.ngc + " glyph classes");
            }
        }
    }

    private static class ChainedContextualSubtableFormat1
    extends ChainedContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ChainedContextualSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> arrayList = new ArrayList<GlyphTable.RuleSet[]>(1);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphSubstitutionState glyphSubstitutionState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphSubstitutionState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    int[] nArray2;
                    int[] nArray3;
                    GlyphTable.ChainedGlyphSequenceRule chainedGlyphSequenceRule;
                    int[] nArray4;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedGlyphSequenceRule) || !this.matches(glyphSubstitutionState, nArray4 = (chainedGlyphSequenceRule = (GlyphTable.ChainedGlyphSequenceRule)rule).getGlyphs(n2), 0, nArray) || !this.matches(glyphSubstitutionState, nArray3 = chainedGlyphSequenceRule.getBacktrackGlyphs(), -1, null) || !this.matches(glyphSubstitutionState, nArray2 = chainedGlyphSequenceRule.getLookaheadGlyphs(), nArray[0], null)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        private boolean matches(GlyphSubstitutionState glyphSubstitutionState, int[] nArray, int n, int[] nArray2) {
            return ContextualSubtableFormat1.matches(glyphSubstitutionState, nArray, n, nArray2);
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
        }
    }

    private static abstract class ChainedContextualSubtable
    extends GlyphSubstitutionSubtable {
        public ChainedContextualSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 6;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof ChainedContextualSubtable;
        }

        public boolean substitute(GlyphSubstitutionState glyphSubstitutionState) {
            int n = glyphSubstitutionState.getGlyph();
            int n2 = this.getCoverageIndex(n);
            if (n2 < 0) {
                return false;
            }
            int[] nArray = new int[1];
            GlyphTable.RuleLookup[] ruleLookupArray = this.getLookups(n2, n, glyphSubstitutionState, nArray);
            if (ruleLookupArray != null) {
                glyphSubstitutionState.apply(ruleLookupArray, nArray[0]);
                return true;
            }
            return false;
        }

        public abstract GlyphTable.RuleLookup[] getLookups(int var1, int var2, GlyphSubstitutionState var3, int[] var4);

        static GlyphSubstitutionSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new ChainedContextualSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            if (n3 == 2) {
                return new ChainedContextualSubtableFormat2(string, n, n2, n3, glyphCoverageTable, list);
            }
            if (n3 == 3) {
                return new ChainedContextualSubtableFormat3(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class ContextualSubtableFormat3
    extends ContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ContextualSubtableFormat3(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> arrayList = new ArrayList<GlyphTable.RuleSet[]>(1);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphSubstitutionState glyphSubstitutionState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphSubstitutionState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    GlyphTable.ChainedCoverageSequenceRule chainedCoverageSequenceRule;
                    GlyphCoverageTable[] glyphCoverageTableArray;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedCoverageSequenceRule) || !ContextualSubtableFormat3.matches(glyphSubstitutionState, glyphCoverageTableArray = (chainedCoverageSequenceRule = (GlyphTable.ChainedCoverageSequenceRule)rule).getCoverages(), 0, nArray)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        static boolean matches(GlyphSubstitutionState glyphSubstitutionState, GlyphCoverageTable[] glyphCoverageTableArray, int n, int[] nArray) {
            int n2;
            GlyphTester glyphTester;
            if (glyphCoverageTableArray == null || glyphCoverageTableArray.length == 0) {
                return true;
            }
            boolean bl = n < 0;
            int[] nArray2 = glyphSubstitutionState.getGlyphsAvailable(n, bl, glyphTester = glyphSubstitutionState.getIgnoreDefault());
            int n3 = nArray2[0];
            if (n3 < (n2 = glyphCoverageTableArray.length)) {
                return false;
            }
            int[] nArray3 = glyphSubstitutionState.getGlyphs(n, n2, bl, glyphTester, null, nArray2);
            for (int i = 0; i < n2; ++i) {
                GlyphCoverageTable glyphCoverageTable = glyphCoverageTableArray[i];
                if (glyphCoverageTable == null || glyphCoverageTable.getCoverageIndex(nArray3[i]) >= 0) continue;
                return false;
            }
            if (nArray != null) {
                nArray[0] = nArray2[0] + nArray2[1];
            }
            return true;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
        }
    }

    private static class ContextualSubtableFormat2
    extends ContextualSubtable {
        private GlyphClassTable cdt;
        private int ngc;
        private GlyphTable.RuleSet[] rsa;

        ContextualSubtableFormat2(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(3);
                arrayList.add(this.cdt);
                arrayList.add(this.ngc);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphSubstitutionState glyphSubstitutionState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphSubstitutionState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    GlyphTable.ChainedClassSequenceRule chainedClassSequenceRule;
                    int[] nArray2;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedClassSequenceRule) || !ContextualSubtableFormat2.matches(glyphSubstitutionState, this.cdt, nArray2 = (chainedClassSequenceRule = (GlyphTable.ChainedClassSequenceRule)rule).getClasses(this.cdt.getClassIndex(n2, glyphSubstitutionState.getClassMatchSet(n2))), 0, nArray)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        static boolean matches(GlyphSubstitutionState glyphSubstitutionState, GlyphClassTable glyphClassTable, int[] nArray, int n, int[] nArray2) {
            int n2;
            GlyphTester glyphTester;
            if (glyphClassTable == null || nArray == null || nArray.length == 0) {
                return true;
            }
            boolean bl = n < 0;
            int[] nArray3 = glyphSubstitutionState.getGlyphsAvailable(n, bl, glyphTester = glyphSubstitutionState.getIgnoreDefault());
            int n3 = nArray3[0];
            if (n3 < (n2 = nArray.length)) {
                return false;
            }
            int[] nArray4 = glyphSubstitutionState.getGlyphs(n, n2, bl, glyphTester, null, nArray3);
            for (int i = 0; i < n2; ++i) {
                int n4 = nArray4[i];
                int n5 = glyphSubstitutionState.getClassMatchSet(n4);
                int n6 = glyphClassTable.getClassIndex(n4, n5);
                if (n6 < 0 || n6 >= glyphClassTable.getClassSize(n5)) {
                    return false;
                }
                if (n6 == nArray[i]) continue;
                return false;
            }
            if (nArray2 != null) {
                nArray2[0] = nArray3[0] + nArray3[1];
            }
            return true;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 3) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 3 entries");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an GlyphClassTable, but is: " + (e != null ? e.getClass() : null));
            }
            this.cdt = (GlyphClassTable)e;
            e = list.get(1);
            if (e == null || !(e instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, second entry must be an Integer, but is: " + (e != null ? e.getClass() : null));
            }
            this.ngc = (Integer)e;
            e = list.get(2);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, third entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
            if (this.rsa.length != this.ngc) {
                throw new AdvancedTypographicTableFormatException("illegal entries, RuleSet[] length is " + this.rsa.length + ", but expected " + this.ngc + " glyph classes");
            }
        }
    }

    private static class ContextualSubtableFormat1
    extends ContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ContextualSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> arrayList = new ArrayList<GlyphTable.RuleSet[]>(1);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphSubstitutionState glyphSubstitutionState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphSubstitutionState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    GlyphTable.ChainedGlyphSequenceRule chainedGlyphSequenceRule;
                    int[] nArray2;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedGlyphSequenceRule) || !ContextualSubtableFormat1.matches(glyphSubstitutionState, nArray2 = (chainedGlyphSequenceRule = (GlyphTable.ChainedGlyphSequenceRule)rule).getGlyphs(n2), 0, nArray)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        static boolean matches(GlyphSubstitutionState glyphSubstitutionState, int[] nArray, int n, int[] nArray2) {
            int n2;
            GlyphTester glyphTester;
            if (nArray == null || nArray.length == 0) {
                return true;
            }
            boolean bl = n < 0;
            int[] nArray3 = glyphSubstitutionState.getGlyphsAvailable(n, bl, glyphTester = glyphSubstitutionState.getIgnoreDefault());
            int n3 = nArray3[0];
            if (n3 < (n2 = nArray.length)) {
                return false;
            }
            int[] nArray4 = glyphSubstitutionState.getGlyphs(n, n2, bl, glyphTester, null, nArray3);
            for (int i = 0; i < n2; ++i) {
                if (nArray4[i] == nArray[i]) continue;
                return false;
            }
            if (nArray2 != null) {
                nArray2[0] = nArray3[0] + nArray3[1];
            }
            return true;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
        }
    }

    private static abstract class ContextualSubtable
    extends GlyphSubstitutionSubtable {
        public ContextualSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 5;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof ContextualSubtable;
        }

        public boolean substitute(GlyphSubstitutionState glyphSubstitutionState) {
            int n = glyphSubstitutionState.getGlyph();
            int n2 = this.getCoverageIndex(n);
            if (n2 < 0) {
                return false;
            }
            int[] nArray = new int[1];
            GlyphTable.RuleLookup[] ruleLookupArray = this.getLookups(n2, n, glyphSubstitutionState, nArray);
            if (ruleLookupArray != null) {
                glyphSubstitutionState.apply(ruleLookupArray, nArray[0]);
            }
            return true;
        }

        public abstract GlyphTable.RuleLookup[] getLookups(int var1, int var2, GlyphSubstitutionState var3, int[] var4);

        static GlyphSubstitutionSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new ContextualSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            if (n3 == 2) {
                return new ContextualSubtableFormat2(string, n, n2, n3, glyphCoverageTable, list);
            }
            if (n3 == 3) {
                return new ContextualSubtableFormat3(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class LigatureSubtableFormat1
    extends LigatureSubtable {
        private LigatureSet[] ligatureSets;

        public LigatureSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            ArrayList<LigatureSet> arrayList = new ArrayList<LigatureSet>(this.ligatureSets.length);
            int n = this.ligatureSets.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.ligatureSets[i]);
            }
            return arrayList;
        }

        public LigatureSet getLigatureSetForCoverageIndex(int n, int n2) throws IllegalArgumentException {
            if (this.ligatureSets == null) {
                return null;
            }
            if (n >= this.ligatureSets.length) {
                throw new IllegalArgumentException("coverage index " + n + " out of range, maximum coverage index is " + this.ligatureSets.length);
            }
            return this.ligatureSets[n];
        }

        private void populate(List list) {
            int n = 0;
            int n2 = list.size();
            LigatureSet[] ligatureSetArray = new LigatureSet[n2];
            for (Object e : list) {
                if (e instanceof LigatureSet) {
                    ligatureSetArray[n++] = (LigatureSet)e;
                    continue;
                }
                throw new AdvancedTypographicTableFormatException("illegal ligatures entry, must be LigatureSet: " + e);
            }
            assert (n == n2);
            assert (this.ligatureSets == null);
            this.ligatureSets = ligatureSetArray;
        }
    }

    private static abstract class LigatureSubtable
    extends GlyphSubstitutionSubtable {
        public LigatureSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 4;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof LigatureSubtable;
        }

        public boolean substitute(GlyphSubstitutionState glyphSubstitutionState) {
            int[] nArray;
            Ligature ligature;
            GlyphTester glyphTester;
            boolean bl;
            int[] nArray2;
            int n;
            int n2 = glyphSubstitutionState.getGlyph();
            int n3 = this.getCoverageIndex(n2);
            if (n3 < 0) {
                return false;
            }
            LigatureSet ligatureSet = this.getLigatureSetForCoverageIndex(n3, n2);
            if (ligatureSet != null && (n = (nArray2 = glyphSubstitutionState.getGlyphsAvailable(0, bl = false, glyphTester = glyphSubstitutionState.getIgnoreDefault()))[0]) > 1 && (ligature = this.findLigature(ligatureSet, nArray = glyphSubstitutionState.getGlyphs(0, n, bl, glyphTester, null, nArray2))) != null) {
                int n4 = ligature.getLigature();
                if (n4 < 0 || n4 > 65535) {
                    n4 = 65535;
                }
                int n5 = 1 + ligature.getNumComponents();
                glyphSubstitutionState.getGlyphs(0, n5, bl, glyphTester, null, nArray2);
                n = nArray2[0];
                int n6 = nArray2[1];
                GlyphSequence.CharAssociation[] charAssociationArray = glyphSubstitutionState.getAssociations(0, n);
                glyphSubstitutionState.putGlyph(n4, GlyphSequence.CharAssociation.join(charAssociationArray), Boolean.TRUE);
                if (n6 > 0) {
                    glyphSubstitutionState.putGlyphs(glyphSubstitutionState.getIgnoredGlyphs(0, n6), glyphSubstitutionState.getIgnoredAssociations(0, n6), null);
                }
                glyphSubstitutionState.consume(n + n6);
            }
            return true;
        }

        private Ligature findLigature(LigatureSet ligatureSet, int[] nArray) {
            Ligature[] ligatureArray = ligatureSet.getLigatures();
            int n = -1;
            int n2 = -1;
            int n3 = ligatureArray.length;
            for (int i = 0; i < n3; ++i) {
                int n4;
                Ligature ligature = ligatureArray[i];
                if (!ligature.matchesComponents(nArray) || (n4 = ligature.getNumComponents()) <= n2) continue;
                n2 = n4;
                n = i;
            }
            if (n >= 0) {
                return ligatureArray[n];
            }
            return null;
        }

        public abstract LigatureSet getLigatureSetForCoverageIndex(int var1, int var2) throws IllegalArgumentException;

        static GlyphSubstitutionSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new LigatureSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class AlternateSubtableFormat1
    extends AlternateSubtable {
        private int[][] gaa;

        AlternateSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            ArrayList<int[]> arrayList = new ArrayList<int[]>(this.gaa.length);
            int n = this.gaa.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.gaa[i]);
            }
            return arrayList;
        }

        public int[] getAlternatesForCoverageIndex(int n, int n2) throws IllegalArgumentException {
            if (this.gaa == null) {
                return null;
            }
            if (n >= this.gaa.length) {
                throw new IllegalArgumentException("coverage index " + n + " out of range, maximum coverage index is " + this.gaa.length);
            }
            return this.gaa[n];
        }

        private void populate(List list) {
            int n = 0;
            int n2 = list.size();
            int[][] nArrayArray = new int[n2][];
            for (Object e : list) {
                if (e instanceof int[]) {
                    nArrayArray[n++] = (int[])e;
                    continue;
                }
                throw new AdvancedTypographicTableFormatException("illegal entries entry, must be int[]: " + e);
            }
            assert (n == n2);
            assert (this.gaa == null);
            this.gaa = nArrayArray;
        }
    }

    private static abstract class AlternateSubtable
    extends GlyphSubstitutionSubtable {
        public AlternateSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 3;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof AlternateSubtable;
        }

        public boolean substitute(GlyphSubstitutionState glyphSubstitutionState) {
            int n = glyphSubstitutionState.getGlyph();
            int n2 = this.getCoverageIndex(n);
            if (n2 < 0) {
                return false;
            }
            int[] nArray = this.getAlternatesForCoverageIndex(n2, n);
            int n3 = glyphSubstitutionState.getAlternatesIndex(n2);
            int n4 = n3 < 0 || n3 >= nArray.length ? n : nArray[n3];
            if (n4 < 0 || n4 > 65535) {
                n4 = 65535;
            }
            glyphSubstitutionState.putGlyph(n4, glyphSubstitutionState.getAssociation(), Boolean.TRUE);
            glyphSubstitutionState.consume(1);
            return true;
        }

        public abstract int[] getAlternatesForCoverageIndex(int var1, int var2) throws IllegalArgumentException;

        static GlyphSubstitutionSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new AlternateSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class MultipleSubtableFormat1
    extends MultipleSubtable {
        private int[][] gsa;

        MultipleSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.gsa != null) {
                ArrayList<int[][]> arrayList = new ArrayList<int[][]>(1);
                arrayList.add(this.gsa);
                return arrayList;
            }
            return null;
        }

        public int[] getGlyphsForCoverageIndex(int n, int n2) throws IllegalArgumentException {
            if (this.gsa == null) {
                return null;
            }
            if (n >= this.gsa.length) {
                throw new IllegalArgumentException("coverage index " + n + " out of range, maximum coverage index is " + this.gsa.length);
            }
            return this.gsa[n];
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof int[][])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an int[][], but is: " + (e != null ? e.getClass() : null));
            }
            this.gsa = (int[][])e;
        }
    }

    private static abstract class MultipleSubtable
    extends GlyphSubstitutionSubtable {
        public MultipleSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 2;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof MultipleSubtable;
        }

        public boolean substitute(GlyphSubstitutionState glyphSubstitutionState) {
            int n = glyphSubstitutionState.getGlyph();
            int n2 = this.getCoverageIndex(n);
            if (n2 < 0) {
                return false;
            }
            int[] nArray = this.getGlyphsForCoverageIndex(n2, n);
            if (nArray != null) {
                glyphSubstitutionState.putGlyphs(nArray, GlyphSequence.CharAssociation.replicate(glyphSubstitutionState.getAssociation(), nArray.length), Boolean.TRUE);
                glyphSubstitutionState.consume(1);
            }
            return true;
        }

        public abstract int[] getGlyphsForCoverageIndex(int var1, int var2) throws IllegalArgumentException;

        static GlyphSubstitutionSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new MultipleSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class SingleSubtableFormat2
    extends SingleSubtable {
        private int[] glyphs;

        SingleSubtableFormat2(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.glyphs.length);
            int n = this.glyphs.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.glyphs[i]);
            }
            return arrayList;
        }

        public int getGlyphForCoverageIndex(int n, int n2) throws IllegalArgumentException {
            if (this.glyphs == null) {
                return -1;
            }
            if (n >= this.glyphs.length) {
                throw new IllegalArgumentException("coverage index " + n + " out of range, maximum coverage index is " + this.glyphs.length);
            }
            return this.glyphs[n];
        }

        private void populate(List list) {
            int n = 0;
            int n2 = list.size();
            int[] nArray = new int[n2];
            for (Object e : list) {
                if (e instanceof Integer) {
                    int n3 = (Integer)e;
                    if (n3 >= 0 && n3 < 65536) {
                        nArray[n++] = n3;
                        continue;
                    }
                    throw new AdvancedTypographicTableFormatException("illegal glyph index: " + n3);
                }
                throw new AdvancedTypographicTableFormatException("illegal entries entry, must be Integer: " + e);
            }
            assert (n == n2);
            assert (this.glyphs == null);
            this.glyphs = nArray;
        }
    }

    private static class SingleSubtableFormat1
    extends SingleSubtable {
        private int delta;
        private int ciMax;

        SingleSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
            arrayList.add(this.delta);
            return arrayList;
        }

        public int getGlyphForCoverageIndex(int n, int n2) throws IllegalArgumentException {
            if (n <= this.ciMax) {
                return n2 + this.delta;
            }
            throw new IllegalArgumentException("coverage index " + n + " out of range, maximum coverage index is " + this.ciMax);
        }

        private void populate(List list) {
            if (list == null || list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null and contain exactly one entry");
            }
            Object e = list.get(0);
            int n = 0;
            if (!(e instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries entry, must be Integer, but is: " + e);
            }
            n = (Integer)e;
            this.delta = n;
            this.ciMax = this.getCoverageSize() - 1;
        }
    }

    private static abstract class SingleSubtable
    extends GlyphSubstitutionSubtable {
        SingleSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 1;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof SingleSubtable;
        }

        public boolean substitute(GlyphSubstitutionState glyphSubstitutionState) {
            int n = glyphSubstitutionState.getGlyph();
            int n2 = this.getCoverageIndex(n);
            if (n2 < 0) {
                return false;
            }
            int n3 = this.getGlyphForCoverageIndex(n2, n);
            if (n3 < 0 || n3 > 65535) {
                n3 = 65535;
            }
            glyphSubstitutionState.putGlyph(n3, glyphSubstitutionState.getAssociation(), Boolean.TRUE);
            glyphSubstitutionState.consume(1);
            return true;
        }

        public abstract int getGlyphForCoverageIndex(int var1, int var2) throws IllegalArgumentException;

        static GlyphSubstitutionSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new SingleSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            if (n3 == 2) {
                return new SingleSubtableFormat2(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }
}

