/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphClassMapping;
import org.apache.fop.complexscripts.fonts.GlyphCoverageMapping;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphMappingTable;
import org.apache.fop.complexscripts.fonts.GlyphTable;

public abstract class GlyphSubtable
implements Comparable {
    public static final int LF_RIGHT_TO_LEFT = 1;
    public static final int LF_IGNORE_BASE = 2;
    public static final int LF_IGNORE_LIGATURE = 4;
    public static final int LF_IGNORE_MARK = 8;
    public static final int LF_USE_MARK_FILTERING_SET = 16;
    public static final int LF_RESERVED = 3584;
    public static final int LF_MARK_ATTACHMENT_TYPE = 65280;
    public static final int LF_INTERNAL_USE_REVERSE_SCAN = 65536;
    private String lookupId;
    private int sequence;
    private int flags;
    private int format;
    private GlyphMappingTable mapping;
    private WeakReference table;

    protected GlyphSubtable(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable) {
        if (string == null || string.length() == 0) {
            throw new AdvancedTypographicTableFormatException("invalid lookup identifier, must be non-empty string");
        }
        if (glyphMappingTable == null) {
            throw new AdvancedTypographicTableFormatException("invalid mapping table, must not be null");
        }
        this.lookupId = string;
        this.sequence = n;
        this.flags = n2;
        this.format = n3;
        this.mapping = glyphMappingTable;
    }

    public String getLookupId() {
        return this.lookupId;
    }

    public abstract int getTableType();

    public abstract int getType();

    public abstract String getTypeName();

    public abstract boolean isCompatible(GlyphSubtable var1);

    public abstract boolean usesReverseScan();

    public int getSequence() {
        return this.sequence;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getFormat() {
        return this.format;
    }

    public GlyphDefinitionTable getGDEF() {
        GlyphTable glyphTable = this.getTable();
        if (glyphTable != null) {
            return glyphTable.getGlyphDefinitions();
        }
        return null;
    }

    public GlyphCoverageMapping getCoverage() {
        if (this.mapping instanceof GlyphCoverageMapping) {
            return (GlyphCoverageMapping)((Object)this.mapping);
        }
        return null;
    }

    public GlyphClassMapping getClasses() {
        if (this.mapping instanceof GlyphClassMapping) {
            return (GlyphClassMapping)((Object)this.mapping);
        }
        return null;
    }

    public abstract List getEntries();

    public synchronized GlyphTable getTable() {
        WeakReference weakReference = this.table;
        return weakReference != null ? (GlyphTable)weakReference.get() : null;
    }

    public synchronized void setTable(GlyphTable glyphTable) throws IllegalStateException {
        WeakReference weakReference = this.table;
        if (glyphTable == null) {
            this.table = null;
            if (weakReference != null) {
                weakReference.clear();
            }
        } else if (weakReference == null) {
            this.table = new WeakReference<GlyphTable>(glyphTable);
        } else {
            throw new IllegalStateException("table already set");
        }
    }

    public void resolveLookupReferences(Map map) {
    }

    public int getCoverageIndex(int n) {
        if (this.mapping instanceof GlyphCoverageMapping) {
            return ((GlyphCoverageMapping)((Object)this.mapping)).getCoverageIndex(n);
        }
        return -1;
    }

    public int getCoverageSize() {
        if (this.mapping instanceof GlyphCoverageMapping) {
            return ((GlyphCoverageMapping)((Object)this.mapping)).getCoverageSize();
        }
        return 0;
    }

    public int hashCode() {
        int n = this.sequence;
        n = n * 3 + (this.lookupId.hashCode() ^ n);
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof GlyphSubtable) {
            GlyphSubtable glyphSubtable = (GlyphSubtable)object;
            return this.lookupId.equals(glyphSubtable.lookupId) && this.sequence == glyphSubtable.sequence;
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof GlyphSubtable) {
            GlyphSubtable glyphSubtable = (GlyphSubtable)object;
            n = this.lookupId.compareTo(glyphSubtable.lookupId);
            if (n == 0) {
                if (this.sequence < glyphSubtable.sequence) {
                    n = -1;
                } else if (this.sequence > glyphSubtable.sequence) {
                    n = 1;
                }
            }
        } else {
            n = -1;
        }
        return n;
    }

    public static boolean usesReverseScan(GlyphSubtable[] glyphSubtableArray) {
        if (glyphSubtableArray == null || glyphSubtableArray.length == 0) {
            return false;
        }
        int n = glyphSubtableArray.length;
        for (int i = 0; i < n; ++i) {
            if (!glyphSubtableArray[i].usesReverseScan()) continue;
            return true;
        }
        return false;
    }

    public static int getFlags(GlyphSubtable[] glyphSubtableArray) throws IllegalStateException {
        int n;
        int n2;
        if (glyphSubtableArray == null || glyphSubtableArray.length == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = glyphSubtableArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            n = glyphSubtableArray[n2].getFlags();
            if (n3 != 0) continue;
            n3 = n;
            break;
        }
        n4 = glyphSubtableArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            n = glyphSubtableArray[n2].getFlags();
            if (n == n3) continue;
            throw new IllegalStateException("inconsistent lookup flags " + n + ", expected " + n3);
        }
        return n3 | (GlyphSubtable.usesReverseScan(glyphSubtableArray) ? 65536 : 0);
    }
}

