/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphCoverageTable;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningState;
import org.apache.fop.complexscripts.fonts.GlyphPositioningSubtable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionState;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionSubtable;
import org.apache.fop.complexscripts.fonts.GlyphSubtable;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public class GlyphTable {
    private static final Log log = LogFactory.getLog(GlyphTable.class);
    public static final int GLYPH_TABLE_TYPE_SUBSTITUTION = 1;
    public static final int GLYPH_TABLE_TYPE_POSITIONING = 2;
    public static final int GLYPH_TABLE_TYPE_JUSTIFICATION = 3;
    public static final int GLYPH_TABLE_TYPE_BASELINE = 4;
    public static final int GLYPH_TABLE_TYPE_DEFINITION = 5;
    private GlyphTable gdef;
    private Map lookups;
    private Map lookupTables;
    private boolean frozen;

    public GlyphTable(GlyphTable glyphTable, Map map) {
        if (glyphTable != null && !(glyphTable instanceof GlyphDefinitionTable)) {
            throw new AdvancedTypographicTableFormatException("bad glyph definition table");
        }
        if (map == null) {
            throw new AdvancedTypographicTableFormatException("lookups must be non-null map");
        }
        this.gdef = glyphTable;
        this.lookups = map;
        this.lookupTables = new LinkedHashMap();
    }

    public GlyphDefinitionTable getGlyphDefinitions() {
        return (GlyphDefinitionTable)this.gdef;
    }

    public List getLookups() {
        return this.matchLookupSpecs("*", "*", "*");
    }

    public List getLookupTables() {
        TreeSet treeSet = new TreeSet(this.lookupTables.keySet());
        ArrayList arrayList = new ArrayList(treeSet.size());
        for (String string : treeSet) {
            arrayList.add(this.lookupTables.get(string));
        }
        return arrayList;
    }

    public LookupTable getLookupTable(String string) {
        return (LookupTable)this.lookupTables.get(string);
    }

    protected void addSubtable(GlyphSubtable glyphSubtable) {
        if (this.frozen) {
            throw new IllegalStateException("glyph table is frozen, subtable addition prohibited");
        }
        glyphSubtable.setTable(this);
        String string = glyphSubtable.getLookupId();
        if (this.lookupTables.containsKey(string)) {
            LookupTable lookupTable = (LookupTable)this.lookupTables.get(string);
            lookupTable.addSubtable(glyphSubtable);
        } else {
            LookupTable lookupTable = new LookupTable(string, glyphSubtable);
            this.lookupTables.put(string, lookupTable);
        }
    }

    protected void freezeSubtables() {
        if (!this.frozen) {
            for (LookupTable lookupTable : this.lookupTables.values()) {
                lookupTable.freezeSubtables(this.lookupTables);
            }
            this.frozen = true;
        }
    }

    public List matchLookupSpecs(String string, String string2, String string3) {
        Set set = this.lookups.keySet();
        ArrayList<LookupSpec> arrayList = new ArrayList<LookupSpec>();
        for (LookupSpec lookupSpec : set) {
            if (!"*".equals(string) && !lookupSpec.getScript().equals(string) || !"*".equals(string2) && !lookupSpec.getLanguage().equals(string2) || !"*".equals(string3) && !lookupSpec.getFeature().equals(string3)) continue;
            arrayList.add(lookupSpec);
        }
        return arrayList;
    }

    public Map matchLookups(String string, String string2, String string3) {
        List list = this.matchLookupSpecs(string, string2, string3);
        LinkedHashMap<LookupSpec, List> linkedHashMap = new LinkedHashMap<LookupSpec, List>();
        for (LookupSpec lookupSpec : list) {
            linkedHashMap.put(lookupSpec, this.findLookupTables(lookupSpec));
        }
        return linkedHashMap;
    }

    public List findLookupTables(LookupSpec lookupSpec) {
        TreeSet<LookupTable> treeSet = new TreeSet<LookupTable>();
        List list = (List)this.lookups.get(lookupSpec);
        if (list != null) {
            for (String string : list) {
                LookupTable lookupTable = (LookupTable)this.lookupTables.get(string);
                if (lookupTable == null) continue;
                treeSet.add(lookupTable);
            }
        }
        return new ArrayList(treeSet);
    }

    public UseSpec[] assembleLookups(String[] stringArray, Map map) {
        TreeSet<UseSpec> treeSet = new TreeSet<UseSpec>();
        for (String string : stringArray) {
            for (Map.Entry entry : map.entrySet()) {
                List list;
                LookupSpec lookupSpec = (LookupSpec)entry.getKey();
                if (!lookupSpec.getFeature().equals(string) || (list = (List)entry.getValue()) == null) continue;
                for (LookupTable lookupTable : list) {
                    treeSet.add(new UseSpec(lookupTable, string));
                }
            }
        }
        return treeSet.toArray(new UseSpec[treeSet.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("{");
        stringBuffer.append("lookups={");
        stringBuffer.append(this.lookups.toString());
        stringBuffer.append("},lookupTables={");
        stringBuffer.append(this.lookupTables.toString());
        stringBuffer.append("}}");
        return stringBuffer.toString();
    }

    public static int getTableTypeFromName(String string) {
        String string2 = string.toLowerCase();
        int n = "gsub".equals(string2) ? 1 : ("gpos".equals(string2) ? 2 : ("jstf".equals(string2) ? 3 : ("base".equals(string2) ? 4 : ("gdef".equals(string2) ? 5 : -1))));
        return n;
    }

    public static void resolveLookupReferences(RuleSet[] ruleSetArray, Map map) {
        if (ruleSetArray != null && map != null) {
            for (RuleSet ruleSet : ruleSetArray) {
                if (ruleSet == null) continue;
                ruleSet.resolveLookupReferences(map);
            }
        }
    }

    public static class HomogeneousRuleSet
    extends RuleSet {
        public HomogeneousRuleSet(Rule[] ruleArray) throws AdvancedTypographicTableFormatException {
            super(ruleArray);
            Object object = null;
            int n = ruleArray.length;
            for (int i = 1; object == null && i < n; ++i) {
                if (ruleArray[i] == null) continue;
                object = ruleArray[i];
            }
            if (object != null) {
                Class<?> clazz = object.getClass();
                int n2 = ruleArray.length;
                for (n = 1; n < n2; ++n) {
                    Rule rule = ruleArray[n];
                    if (rule == null || clazz.isInstance(rule)) continue;
                    throw new AdvancedTypographicTableFormatException("rules[" + n + "] is not an instance of " + clazz.getName());
                }
            }
        }
    }

    public static class RuleSet {
        private final Rule[] rules;

        public RuleSet(Rule[] ruleArray) throws AdvancedTypographicTableFormatException {
            if (ruleArray == null) {
                throw new AdvancedTypographicTableFormatException("rules[] is null");
            }
            this.rules = ruleArray;
        }

        public Rule[] getRules() {
            return this.rules;
        }

        public void resolveLookupReferences(Map map) {
            if (this.rules != null) {
                for (Rule rule : this.rules) {
                    if (rule == null) continue;
                    rule.resolveLookupReferences(map);
                }
            }
        }

        public String toString() {
            return "{ rules = " + Arrays.toString(this.rules) + " }";
        }
    }

    public static class ChainedCoverageSequenceRule
    extends CoverageSequenceRule {
        private final GlyphCoverageTable[] backtrackCoverages;
        private final GlyphCoverageTable[] lookaheadCoverages;

        public ChainedCoverageSequenceRule(RuleLookup[] ruleLookupArray, int n, GlyphCoverageTable[] glyphCoverageTableArray, GlyphCoverageTable[] glyphCoverageTableArray2, GlyphCoverageTable[] glyphCoverageTableArray3) {
            super(ruleLookupArray, n, glyphCoverageTableArray);
            assert (glyphCoverageTableArray2 != null);
            assert (glyphCoverageTableArray3 != null);
            this.backtrackCoverages = glyphCoverageTableArray2;
            this.lookaheadCoverages = glyphCoverageTableArray3;
        }

        public GlyphCoverageTable[] getBacktrackCoverages() {
            return this.backtrackCoverages;
        }

        public GlyphCoverageTable[] getLookaheadCoverages() {
            return this.lookaheadCoverages;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            stringBuffer.append("lookups = " + Arrays.toString(this.getLookups()));
            stringBuffer.append(", coverages = " + Arrays.toString(this.getCoverages()));
            stringBuffer.append(", backtrackCoverages = " + Arrays.toString(this.backtrackCoverages));
            stringBuffer.append(", lookaheadCoverages = " + Arrays.toString(this.lookaheadCoverages));
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
    }

    public static class ChainedClassSequenceRule
    extends ClassSequenceRule {
        private final int[] backtrackClasses;
        private final int[] lookaheadClasses;

        public ChainedClassSequenceRule(RuleLookup[] ruleLookupArray, int n, int[] nArray, int[] nArray2, int[] nArray3) {
            super(ruleLookupArray, n, nArray);
            assert (nArray2 != null);
            assert (nArray3 != null);
            this.backtrackClasses = nArray2;
            this.lookaheadClasses = nArray3;
        }

        public int[] getBacktrackClasses() {
            return this.backtrackClasses;
        }

        public int[] getLookaheadClasses() {
            return this.lookaheadClasses;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            stringBuffer.append("lookups = " + Arrays.toString(this.getLookups()));
            stringBuffer.append(", classes = " + Arrays.toString(this.getClasses()));
            stringBuffer.append(", backtrackClasses = " + Arrays.toString(this.backtrackClasses));
            stringBuffer.append(", lookaheadClasses = " + Arrays.toString(this.lookaheadClasses));
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
    }

    public static class ChainedGlyphSequenceRule
    extends GlyphSequenceRule {
        private final int[] backtrackGlyphs;
        private final int[] lookaheadGlyphs;

        public ChainedGlyphSequenceRule(RuleLookup[] ruleLookupArray, int n, int[] nArray, int[] nArray2, int[] nArray3) {
            super(ruleLookupArray, n, nArray);
            assert (nArray2 != null);
            assert (nArray3 != null);
            this.backtrackGlyphs = nArray2;
            this.lookaheadGlyphs = nArray3;
        }

        public int[] getBacktrackGlyphs() {
            return this.backtrackGlyphs;
        }

        public int[] getLookaheadGlyphs() {
            return this.lookaheadGlyphs;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            stringBuffer.append("lookups = " + Arrays.toString(this.getLookups()));
            stringBuffer.append(", glyphs = " + Arrays.toString(this.getGlyphs()));
            stringBuffer.append(", backtrackGlyphs = " + Arrays.toString(this.backtrackGlyphs));
            stringBuffer.append(", lookaheadGlyphs = " + Arrays.toString(this.lookaheadGlyphs));
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
    }

    public static class CoverageSequenceRule
    extends Rule {
        private final GlyphCoverageTable[] coverages;

        public CoverageSequenceRule(RuleLookup[] ruleLookupArray, int n, GlyphCoverageTable[] glyphCoverageTableArray) {
            super(ruleLookupArray, n);
            assert (glyphCoverageTableArray != null);
            this.coverages = glyphCoverageTableArray;
        }

        public GlyphCoverageTable[] getCoverages() {
            return this.coverages;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            stringBuffer.append("lookups = " + Arrays.toString(this.getLookups()));
            stringBuffer.append(", coverages = " + Arrays.toString(this.coverages));
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
    }

    public static class ClassSequenceRule
    extends Rule {
        private final int[] classes;

        public ClassSequenceRule(RuleLookup[] ruleLookupArray, int n, int[] nArray) {
            super(ruleLookupArray, n);
            assert (nArray != null);
            this.classes = nArray;
        }

        public int[] getClasses() {
            return this.classes;
        }

        public int[] getClasses(int n) {
            int[] nArray = new int[this.classes.length + 1];
            nArray[0] = n;
            System.arraycopy(this.classes, 0, nArray, 1, this.classes.length);
            return nArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            stringBuffer.append("lookups = " + Arrays.toString(this.getLookups()));
            stringBuffer.append(", classes = " + Arrays.toString(this.classes));
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
    }

    public static class GlyphSequenceRule
    extends Rule {
        private final int[] glyphs;

        public GlyphSequenceRule(RuleLookup[] ruleLookupArray, int n, int[] nArray) {
            super(ruleLookupArray, n);
            assert (nArray != null);
            this.glyphs = nArray;
        }

        public int[] getGlyphs() {
            return this.glyphs;
        }

        public int[] getGlyphs(int n) {
            int[] nArray = new int[this.glyphs.length + 1];
            nArray[0] = n;
            System.arraycopy(this.glyphs, 0, nArray, 1, this.glyphs.length);
            return nArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            stringBuffer.append("lookups = " + Arrays.toString(this.getLookups()));
            stringBuffer.append(", glyphs = " + Arrays.toString(this.glyphs));
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
    }

    public static abstract class Rule {
        private final RuleLookup[] lookups;
        private final int inputSequenceLength;

        protected Rule(RuleLookup[] ruleLookupArray, int n) {
            assert (ruleLookupArray != null);
            this.lookups = ruleLookupArray;
            this.inputSequenceLength = n;
        }

        public RuleLookup[] getLookups() {
            return this.lookups;
        }

        public int getInputSequenceLength() {
            return this.inputSequenceLength;
        }

        public void resolveLookupReferences(Map map) {
            if (this.lookups != null) {
                for (RuleLookup ruleLookup : this.lookups) {
                    if (ruleLookup == null) continue;
                    ruleLookup.resolveLookupReferences(map);
                }
            }
        }

        public String toString() {
            return "{ lookups = " + Arrays.toString(this.lookups) + ", inputSequenceLength = " + this.inputSequenceLength + " }";
        }
    }

    public static class RuleLookup {
        private final int sequenceIndex;
        private final int lookupIndex;
        private LookupTable lookup;

        public RuleLookup(int n, int n2) {
            this.sequenceIndex = n;
            this.lookupIndex = n2;
            this.lookup = null;
        }

        public int getSequenceIndex() {
            return this.sequenceIndex;
        }

        public int getLookupIndex() {
            return this.lookupIndex;
        }

        public LookupTable getLookup() {
            return this.lookup;
        }

        public void resolveLookupReferences(Map map) {
            if (map != null) {
                String string = "lu" + Integer.toString(this.lookupIndex);
                LookupTable lookupTable = (LookupTable)map.get(string);
                if (lookupTable != null) {
                    this.lookup = lookupTable;
                } else {
                    log.warn((Object)("unable to resolve glyph lookup table reference '" + string + "' amongst lookup tables: " + map.values()));
                }
            }
        }

        public String toString() {
            return "{ sequenceIndex = " + this.sequenceIndex + ", lookupIndex = " + this.lookupIndex + " }";
        }
    }

    public static class UseSpec
    implements Comparable {
        private final LookupTable lookupTable;
        private final String feature;

        public UseSpec(LookupTable lookupTable, String string) {
            this.lookupTable = lookupTable;
            this.feature = string;
        }

        public LookupTable getLookupTable() {
            return this.lookupTable;
        }

        public String getFeature() {
            return this.feature;
        }

        public GlyphSequence substitute(GlyphSequence glyphSequence, String string, String string2, ScriptContextTester scriptContextTester) {
            return this.lookupTable.substitute(glyphSequence, string, string2, this.feature, scriptContextTester);
        }

        public boolean position(GlyphSequence glyphSequence, String string, String string2, int n, int[] nArray, int[][] nArray2, ScriptContextTester scriptContextTester) {
            return this.lookupTable.position(glyphSequence, string, string2, this.feature, n, nArray, nArray2, scriptContextTester);
        }

        public int hashCode() {
            return this.lookupTable.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof UseSpec) {
                UseSpec useSpec = (UseSpec)object;
                return this.lookupTable.equals(useSpec.lookupTable);
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof UseSpec) {
                UseSpec useSpec = (UseSpec)object;
                return this.lookupTable.compareTo(useSpec.lookupTable);
            }
            return -1;
        }
    }

    public static class LookupTable
    implements Comparable {
        private final String id;
        private final List subtables;
        private boolean doesSub;
        private boolean doesPos;
        private boolean frozen;
        private GlyphSubtable[] subtablesArray;
        private static GlyphSubtable[] subtablesArrayEmpty = new GlyphSubtable[0];

        public LookupTable(String string, GlyphSubtable glyphSubtable) {
            this(string, LookupTable.makeSingleton(glyphSubtable));
        }

        public LookupTable(String string, List list) {
            assert (string != null);
            assert (string.length() != 0);
            this.id = string;
            this.subtables = new LinkedList();
            if (list != null) {
                for (GlyphSubtable glyphSubtable : list) {
                    this.addSubtable(glyphSubtable);
                }
            }
        }

        public String getId() {
            return this.id;
        }

        public GlyphSubtable[] getSubtables() {
            if (this.frozen) {
                return this.subtablesArray != null ? this.subtablesArray : subtablesArrayEmpty;
            }
            if (this.doesSub) {
                return this.subtables.toArray(new GlyphSubstitutionSubtable[this.subtables.size()]);
            }
            if (this.doesPos) {
                return this.subtables.toArray(new GlyphPositioningSubtable[this.subtables.size()]);
            }
            return null;
        }

        public boolean addSubtable(GlyphSubtable glyphSubtable) {
            boolean bl = false;
            if (this.frozen) {
                throw new IllegalStateException("glyph table is frozen, subtable addition prohibited");
            }
            this.validateSubtable(glyphSubtable);
            ListIterator<GlyphSubtable> listIterator = this.subtables.listIterator(0);
            while (listIterator.hasNext()) {
                GlyphSubtable glyphSubtable2 = (GlyphSubtable)listIterator.next();
                int n = glyphSubtable.compareTo(glyphSubtable2);
                if (n < 0) {
                    listIterator.set(glyphSubtable);
                    listIterator.add(glyphSubtable2);
                    bl = true;
                    continue;
                }
                if (n != 0) continue;
                bl = false;
                glyphSubtable = null;
            }
            if (!bl && glyphSubtable != null) {
                this.subtables.add(glyphSubtable);
                bl = true;
            }
            return bl;
        }

        private void validateSubtable(GlyphSubtable glyphSubtable) {
            GlyphSubtable glyphSubtable2;
            if (glyphSubtable == null) {
                throw new AdvancedTypographicTableFormatException("subtable must be non-null");
            }
            if (glyphSubtable instanceof GlyphSubstitutionSubtable) {
                if (this.doesPos) {
                    throw new AdvancedTypographicTableFormatException("subtable must be positioning subtable, but is: " + glyphSubtable);
                }
                this.doesSub = true;
            }
            if (glyphSubtable instanceof GlyphPositioningSubtable) {
                if (this.doesSub) {
                    throw new AdvancedTypographicTableFormatException("subtable must be substitution subtable, but is: " + glyphSubtable);
                }
                this.doesPos = true;
            }
            if (this.subtables.size() > 0 && !(glyphSubtable2 = (GlyphSubtable)this.subtables.get(0)).isCompatible(glyphSubtable)) {
                throw new AdvancedTypographicTableFormatException("subtable " + glyphSubtable + " is not compatible with subtable " + glyphSubtable2);
            }
        }

        public void freezeSubtables(Map map) {
            if (!this.frozen) {
                GlyphSubtable[] glyphSubtableArray = this.getSubtables();
                this.resolveLookupReferences(glyphSubtableArray, map);
                this.subtablesArray = glyphSubtableArray;
                this.frozen = true;
            }
        }

        private void resolveLookupReferences(GlyphSubtable[] glyphSubtableArray, Map map) {
            if (glyphSubtableArray != null) {
                for (GlyphSubtable glyphSubtable : glyphSubtableArray) {
                    if (glyphSubtable == null) continue;
                    glyphSubtable.resolveLookupReferences(map);
                }
            }
        }

        public boolean performsSubstitution() {
            return this.doesSub;
        }

        public GlyphSequence substitute(GlyphSequence glyphSequence, String string, String string2, String string3, ScriptContextTester scriptContextTester) {
            if (this.performsSubstitution()) {
                return GlyphSubstitutionSubtable.substitute(glyphSequence, string, string2, string3, (GlyphSubstitutionSubtable[])this.subtablesArray, scriptContextTester);
            }
            return glyphSequence;
        }

        public GlyphSequence substitute(GlyphSubstitutionState glyphSubstitutionState, int n) {
            if (this.performsSubstitution()) {
                return GlyphSubstitutionSubtable.substitute(glyphSubstitutionState, (GlyphSubstitutionSubtable[])this.subtablesArray, n);
            }
            return glyphSubstitutionState.getInput();
        }

        public boolean performsPositioning() {
            return this.doesPos;
        }

        public boolean position(GlyphSequence glyphSequence, String string, String string2, String string3, int n, int[] nArray, int[][] nArray2, ScriptContextTester scriptContextTester) {
            if (this.performsPositioning()) {
                return GlyphPositioningSubtable.position(glyphSequence, string, string2, string3, n, (GlyphPositioningSubtable[])this.subtablesArray, nArray, nArray2, scriptContextTester);
            }
            return false;
        }

        public boolean position(GlyphPositioningState glyphPositioningState, int n) {
            if (this.performsPositioning()) {
                return GlyphPositioningSubtable.position(glyphPositioningState, (GlyphPositioningSubtable[])this.subtablesArray, n);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof LookupTable) {
                LookupTable lookupTable = (LookupTable)object;
                return this.id.equals(lookupTable.id);
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof LookupTable) {
                LookupTable lookupTable = (LookupTable)object;
                assert (this.id.startsWith("lu"));
                int n = Integer.parseInt(this.id.substring(2));
                assert (lookupTable.id.startsWith("lu"));
                int n2 = Integer.parseInt(lookupTable.id.substring(2));
                if (n < n2) {
                    return -1;
                }
                if (n > n2) {
                    return 1;
                }
                return 0;
            }
            return -1;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            stringBuffer.append("id = " + this.id);
            stringBuffer.append(", subtables = " + this.subtables);
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }

        private static List makeSingleton(GlyphSubtable glyphSubtable) {
            if (glyphSubtable == null) {
                return null;
            }
            ArrayList<GlyphSubtable> arrayList = new ArrayList<GlyphSubtable>(1);
            arrayList.add(glyphSubtable);
            return arrayList;
        }
    }

    public static class LookupSpec
    implements Comparable {
        private final String script;
        private final String language;
        private final String feature;

        public LookupSpec(String string, String string2, String string3) {
            if (string == null || string.length() == 0) {
                throw new AdvancedTypographicTableFormatException("script must be non-empty string");
            }
            if (string2 == null || string2.length() == 0) {
                throw new AdvancedTypographicTableFormatException("language must be non-empty string");
            }
            if (string3 == null || string3.length() == 0) {
                throw new AdvancedTypographicTableFormatException("feature must be non-empty string");
            }
            if (string.equals("*")) {
                throw new AdvancedTypographicTableFormatException("script must not be wildcard");
            }
            if (string2.equals("*")) {
                throw new AdvancedTypographicTableFormatException("language must not be wildcard");
            }
            if (string3.equals("*")) {
                throw new AdvancedTypographicTableFormatException("feature must not be wildcard");
            }
            this.script = string.trim();
            this.language = string2.trim();
            this.feature = string3.trim();
        }

        public String getScript() {
            return this.script;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getFeature() {
            return this.feature;
        }

        public int hashCode() {
            int n = 0;
            n = 7 * n + (n ^ this.script.hashCode());
            n = 11 * n + (n ^ this.language.hashCode());
            n = 17 * n + (n ^ this.feature.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof LookupSpec) {
                LookupSpec lookupSpec = (LookupSpec)object;
                if (!lookupSpec.script.equals(this.script)) {
                    return false;
                }
                if (!lookupSpec.language.equals(this.language)) {
                    return false;
                }
                return lookupSpec.feature.equals(this.feature);
            }
            return false;
        }

        public int compareTo(Object object) {
            int n;
            if (object instanceof LookupSpec) {
                LookupSpec lookupSpec = (LookupSpec)object;
                n = this.script.compareTo(lookupSpec.script);
                if (n == 0 && (n = this.language.compareTo(lookupSpec.language)) == 0 && (n = this.feature.compareTo(lookupSpec.feature)) == 0) {
                    n = 0;
                }
            } else {
                n = -1;
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append("{");
            stringBuffer.append("<'" + this.script + "'");
            stringBuffer.append(",'" + this.language + "'");
            stringBuffer.append(",'" + this.feature + "'");
            stringBuffer.append(">}");
            return stringBuffer.toString();
        }
    }
}

