/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.scripts;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.scripts.ArabicScriptProcessor;
import org.apache.fop.complexscripts.scripts.DefaultScriptProcessor;
import org.apache.fop.complexscripts.scripts.IndicScriptProcessor;
import org.apache.fop.complexscripts.util.CharScript;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public abstract class ScriptProcessor {
    private final String script;
    private static Map<String, ScriptProcessor> processors = new HashMap<String, ScriptProcessor>();

    protected ScriptProcessor(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("script must be non-empty string");
        }
        this.script = string;
    }

    public final String getScript() {
        return this.script;
    }

    public abstract String[] getSubstitutionFeatures();

    public String[] getOptionalSubstitutionFeatures() {
        return new String[0];
    }

    public abstract ScriptContextTester getSubstitutionContextTester();

    public final GlyphSequence substitute(GlyphSubstitutionTable glyphSubstitutionTable, GlyphSequence glyphSequence, String string, String string2, Map map) {
        return this.substitute(glyphSequence, string, string2, this.assembleLookups(glyphSubstitutionTable, this.getSubstitutionFeatures(), map), this.getSubstitutionContextTester());
    }

    public GlyphSequence substitute(GlyphSequence glyphSequence, String string, String string2, GlyphTable.UseSpec[] useSpecArray, ScriptContextTester scriptContextTester) {
        assert (useSpecArray != null);
        for (GlyphTable.UseSpec useSpec : useSpecArray) {
            glyphSequence = useSpec.substitute(glyphSequence, string, string2, scriptContextTester);
        }
        return glyphSequence;
    }

    public GlyphSequence reorderCombiningMarks(GlyphDefinitionTable glyphDefinitionTable, GlyphSequence glyphSequence, int[][] nArray, String string, String string2) {
        return glyphSequence;
    }

    public abstract String[] getPositioningFeatures();

    public String[] getOptionalPositioningFeatures() {
        return new String[0];
    }

    public abstract ScriptContextTester getPositioningContextTester();

    public final boolean position(GlyphPositioningTable glyphPositioningTable, GlyphSequence glyphSequence, String string, String string2, int n, Map map, int[] nArray, int[][] nArray2) {
        return this.position(glyphSequence, string, string2, n, this.assembleLookups(glyphPositioningTable, this.getPositioningFeatures(), map), nArray, nArray2, this.getPositioningContextTester());
    }

    public boolean position(GlyphSequence glyphSequence, String string, String string2, int n, GlyphTable.UseSpec[] useSpecArray, int[] nArray, int[][] nArray2, ScriptContextTester scriptContextTester) {
        assert (useSpecArray != null);
        boolean bl = false;
        for (GlyphTable.UseSpec useSpec : useSpecArray) {
            if (!useSpec.position(glyphSequence, string, string2, n, nArray, nArray2, scriptContextTester)) continue;
            bl = true;
        }
        return bl;
    }

    public final GlyphTable.UseSpec[] assembleLookups(GlyphTable glyphTable, String[] stringArray, Map map) {
        return glyphTable.assembleLookups(stringArray, map);
    }

    public static synchronized ScriptProcessor getInstance(String string) {
        ScriptProcessor scriptProcessor = null;
        assert (processors != null);
        scriptProcessor = processors.get(string);
        if (scriptProcessor == null) {
            scriptProcessor = ScriptProcessor.createProcessor(string);
            processors.put(string, scriptProcessor);
        }
        return scriptProcessor;
    }

    private static ScriptProcessor createProcessor(String string) {
        ScriptProcessor scriptProcessor = null;
        int n = CharScript.scriptCodeFromTag(string);
        scriptProcessor = n == 160 ? new ArabicScriptProcessor(string) : (CharScript.isIndicScript(n) ? IndicScriptProcessor.makeProcessor(string) : new DefaultScriptProcessor(string));
        return scriptProcessor;
    }
}

