/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.util;

import org.apache.fop.util.CharUtilities;

public final class UTF32 {
    private UTF32() {
    }

    public static Integer[] toUTF32(String string, int n, boolean bl) throws IllegalArgumentException {
        int n2 = string.length();
        if (n2 == 0) {
            return new Integer[0];
        }
        Integer[] integerArray = new Integer[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = string.charAt(i);
            if (n4 >= 55296 && n4 < 57344) {
                char c;
                int n5 = n4;
                char c2 = c = i + 1 < n2 ? string.charAt(i + 1) : (char)'\u0000';
                if (n5 < 56320) {
                    if (c >= '\udc00' && c < '\ue000') {
                        n4 = (n5 - 55296 << 10) + (c - 56320) + 65536;
                        ++i;
                    } else {
                        if (bl) {
                            throw new IllegalArgumentException("isolated high (leading) surrogate");
                        }
                        n4 = n;
                    }
                } else {
                    if (bl) {
                        throw new IllegalArgumentException("isolated low (trailing) surrogate");
                    }
                    n4 = n;
                }
            }
            integerArray[n3++] = n4;
        }
        if (n3 == n2) {
            return integerArray;
        }
        Integer[] integerArray2 = new Integer[n3];
        System.arraycopy(integerArray, 0, integerArray2, 0, n3);
        return integerArray2;
    }

    public static String fromUTF32(Integer[] integerArray) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            if (n2 < 65535) {
                if (n2 < 55296 || n2 > 57343) {
                    stringBuffer.append((char)n2);
                    continue;
                }
                String string = CharUtilities.charToNCRef(n2);
                throw new IllegalArgumentException("illegal scalar value 0x" + string.substring(2, string.length() - 1) + "; cannot be UTF-16 surrogate");
            }
            if (n2 < 0x110000) {
                int n3 = (n2 - 65536 >> 10 & 0x3FF) + 55296;
                int n4 = (n2 - 65536 >> 0 & 0x3FF) + 56320;
                stringBuffer.append((char)n3);
                stringBuffer.append((char)n4);
                continue;
            }
            String string = CharUtilities.charToNCRef(n2);
            throw new IllegalArgumentException("illegal scalar value 0x" + string.substring(2, string.length() - 1) + "; out of range for UTF-16");
        }
        return stringBuffer.toString();
    }
}

