/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.UnknownXMLObj;
import org.apache.xmlgraphics.util.Service;
import org.w3c.dom.DOMImplementation;
import org.xml.sax.Locator;

public class ElementMappingRegistry {
    private static final Log LOG = LogFactory.getLog(ElementMappingRegistry.class);
    protected Map<String, Map<String, ElementMapping.Maker>> fobjTable = new HashMap<String, Map<String, ElementMapping.Maker>>();
    protected Map<String, ElementMapping> namespaces = new HashMap<String, ElementMapping>();

    public ElementMappingRegistry(FopFactory fopFactory) {
        this.setupDefaultMappings();
    }

    private void setupDefaultMappings() {
        Iterator iterator = Service.providerNames(ElementMapping.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    this.addElementMapping(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOG.warn((Object)"Error while adding element mapping", (Throwable)illegalArgumentException);
                }
            }
        }
    }

    public void addElementMapping(String string) throws IllegalArgumentException {
        try {
            ElementMapping elementMapping = (ElementMapping)Class.forName(string).newInstance();
            this.addElementMapping(elementMapping);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(string + " is not an ElementMapping");
        }
    }

    public void addElementMapping(ElementMapping elementMapping) {
        this.fobjTable.put(elementMapping.getNamespaceURI(), elementMapping.getTable());
        this.namespaces.put(elementMapping.getNamespaceURI().intern(), elementMapping);
    }

    public ElementMapping.Maker findFOMaker(String string, String string2, Locator locator) throws FOPException {
        Map<String, ElementMapping.Maker> map = this.fobjTable.get(string);
        ElementMapping.Maker maker = null;
        if (map != null && (maker = map.get(string2)) == null) {
            maker = map.get("<default>");
        }
        if (maker == null) {
            if (this.namespaces.containsKey(string.intern())) {
                throw new FOPException(FONode.errorText(locator) + "No element mapping definition found for " + FONode.getNodeString(string, string2), locator);
            }
            maker = new UnknownXMLObj.Maker(string);
        }
        return maker;
    }

    public DOMImplementation getDOMImplementationForNamespace(String string) {
        ElementMapping elementMapping = this.namespaces.get(string);
        if (elementMapping == null) {
            return null;
        }
        return elementMapping.getDOMImplementation();
    }

    public ElementMapping getElementMapping(String string) {
        return this.namespaces.get(string);
    }

    public boolean isKnownNamespace(String string) {
        return this.namespaces.containsKey(string);
    }
}

