/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.properties.BackgroundPositionShorthand;
import org.apache.fop.fo.properties.BorderSpacingShorthandParser;
import org.apache.fop.fo.properties.BorderWidthPropertyMaker;
import org.apache.fop.fo.properties.BoxPropShorthandParser;
import org.apache.fop.fo.properties.CharacterProperty;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.CondLengthProperty;
import org.apache.fop.fo.properties.CorrespondingPropertyMaker;
import org.apache.fop.fo.properties.DimensionPropertyMaker;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FontFamilyProperty;
import org.apache.fop.fo.properties.FontShorthandParser;
import org.apache.fop.fo.properties.FontShorthandProperty;
import org.apache.fop.fo.properties.FontSizePropertyMaker;
import org.apache.fop.fo.properties.FontStretchPropertyMaker;
import org.apache.fop.fo.properties.FontWeightPropertyMaker;
import org.apache.fop.fo.properties.GenericShorthandParser;
import org.apache.fop.fo.properties.IndentPropertyMaker;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthPairProperty;
import org.apache.fop.fo.properties.LengthProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.LineHeightPropertyMaker;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.PageBreakShorthandParser;
import org.apache.fop.fo.properties.PageDimensionMaker;
import org.apache.fop.fo.properties.PositionShorthandParser;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.fo.properties.ReferenceOrientationMaker;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fo.properties.SpacePropertyMaker;
import org.apache.fop.fo.properties.SpacingPropertyMaker;
import org.apache.fop.fo.properties.StringProperty;
import org.apache.fop.fo.properties.TableBorderPrecedence;
import org.apache.fop.fo.properties.TextDecorationMaker;
import org.apache.fop.fo.properties.ToBeImplementedProperty;
import org.apache.fop.fo.properties.URIProperty;
import org.apache.fop.fo.properties.VerticalAlignShorthandParser;
import org.apache.fop.fo.properties.WhiteSpaceShorthandParser;
import org.apache.fop.fo.properties.XMLLangShorthandParser;

public final class FOPropertyMapping
implements Constants {
    private static Map<String, Integer> propNames = new HashMap<String, Integer>();
    private static Map<String, Integer> subPropNames = new HashMap<String, Integer>();
    private static Map<Integer, String> propIds = new HashMap<Integer, String>();
    private static PropertyMaker[] generics = null;
    private Property[] enums = null;
    private PropertyMaker genericColor = null;
    private PropertyMaker genericBoolean = null;
    private PropertyMaker genericKeep = null;
    private PropertyMaker genericCondLength = null;
    private PropertyMaker genericCondPadding = null;
    private PropertyMaker genericPadding = null;
    private PropertyMaker genericCondBorderWidth = null;
    private PropertyMaker genericBorderWidth = null;
    private PropertyMaker genericBorderStyle = null;
    private PropertyMaker genericBreak = null;
    private PropertyMaker genericSpace = null;

    private FOPropertyMapping() {
    }

    private void createGenerics() {
        this.genericColor = new ColorProperty.Maker(0);
        this.genericBoolean = new EnumProperty.Maker(0);
        this.genericBoolean.addEnum("true", this.getEnumProperty(149, "TRUE"));
        this.genericBoolean.addEnum("false", this.getEnumProperty(48, "FALSE"));
        this.genericKeep = new KeepProperty.Maker(0);
        PropertyMaker propertyMaker = new NumberProperty.Maker(5632);
        propertyMaker.setByShorthand(true);
        propertyMaker.setDefault("auto");
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker(propertyMaker);
        propertyMaker = new NumberProperty.Maker(5120);
        propertyMaker.setByShorthand(true);
        propertyMaker.setDefault("auto");
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker(propertyMaker);
        propertyMaker = new NumberProperty.Maker(4608);
        propertyMaker.setByShorthand(true);
        propertyMaker.setDefault("auto");
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker(propertyMaker);
        this.genericCondLength = new CondLengthProperty.Maker(0);
        propertyMaker = new LengthProperty.Maker(2048);
        propertyMaker.setByShorthand(true);
        this.genericCondLength.addSubpropMaker(propertyMaker);
        propertyMaker = new EnumProperty.Maker(1024);
        propertyMaker.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        propertyMaker.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        this.genericCondLength.addSubpropMaker(propertyMaker);
        this.genericCondPadding = new CondLengthProperty.Maker(0);
        this.genericCondPadding.useGeneric(this.genericCondLength);
        this.genericCondPadding.setInherited(false);
        this.genericCondPadding.getSubpropMaker(2048).setDefault("0pt");
        this.genericCondPadding.setPercentBase(5);
        this.genericPadding = new LengthProperty.Maker(0);
        this.genericPadding.setInherited(false);
        this.genericPadding.setDefault("0pt");
        this.genericPadding.setPercentBase(5);
        this.genericPadding.addShorthand(generics[170]);
        this.genericCondBorderWidth = new CondLengthProperty.Maker(0);
        this.genericCondBorderWidth.setInherited(false);
        this.genericCondBorderWidth.addKeyword("thin", "0.5pt");
        this.genericCondBorderWidth.addKeyword("medium", "1pt");
        this.genericCondBorderWidth.addKeyword("thick", "2pt");
        propertyMaker = new LengthProperty.Maker(2048);
        propertyMaker.setByShorthand(true);
        propertyMaker.addKeyword("thin", "0.5pt");
        propertyMaker.addKeyword("medium", "1pt");
        propertyMaker.addKeyword("thick", "2pt");
        propertyMaker.setDefault("medium");
        this.genericCondBorderWidth.addSubpropMaker(propertyMaker);
        propertyMaker = new EnumProperty.Maker(1024);
        propertyMaker.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        propertyMaker.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        this.genericCondBorderWidth.addSubpropMaker(propertyMaker);
        this.genericBorderWidth = new LengthProperty.Maker(0);
        this.genericBorderWidth.setInherited(false);
        this.genericBorderWidth.addKeyword("thin", "0.5pt");
        this.genericBorderWidth.addKeyword("medium", "1pt");
        this.genericBorderWidth.addKeyword("thick", "2pt");
        this.genericBorderWidth.setDefault("medium");
        this.genericBorderStyle = new EnumProperty.Maker(0);
        this.genericBorderStyle.setInherited(false);
        this.genericBorderStyle.addEnum("none", this.getEnumProperty(95, "NONE"));
        this.genericBorderStyle.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        this.genericBorderStyle.addEnum("dotted", this.getEnumProperty(36, "DOTTED"));
        this.genericBorderStyle.addEnum("dashed", this.getEnumProperty(31, "DASHED"));
        this.genericBorderStyle.addEnum("solid", this.getEnumProperty(133, "SOLID"));
        this.genericBorderStyle.addEnum("double", this.getEnumProperty(37, "DOUBLE"));
        this.genericBorderStyle.addEnum("groove", this.getEnumProperty(55, "GROOVE"));
        this.genericBorderStyle.addEnum("ridge", this.getEnumProperty(119, "RIDGE"));
        this.genericBorderStyle.addEnum("inset", this.getEnumProperty(67, "INSET"));
        this.genericBorderStyle.addEnum("outset", this.getEnumProperty(101, "OUTSET"));
        this.genericBorderStyle.setDefault("none");
        this.genericBreak = new EnumProperty.Maker(0);
        this.genericBreak.setInherited(false);
        this.genericBreak.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        this.genericBreak.addEnum("column", this.getEnumProperty(28, "COLUMN"));
        this.genericBreak.addEnum("page", this.getEnumProperty(104, "PAGE"));
        this.genericBreak.addEnum("even-page", this.getEnumProperty(44, "EVEN_PAGE"));
        this.genericBreak.addEnum("odd-page", this.getEnumProperty(100, "ODD_PAGE"));
        this.genericBreak.setDefault("auto");
        this.genericSpace = new SpaceProperty.Maker(0);
        this.genericSpace.setInherited(false);
        propertyMaker = new LengthProperty.Maker(3072);
        propertyMaker.setDefault("0pt");
        propertyMaker.setByShorthand(true);
        this.genericSpace.addSubpropMaker(propertyMaker);
        propertyMaker = new LengthProperty.Maker(3584);
        propertyMaker.setDefault("0pt");
        propertyMaker.setByShorthand(true);
        this.genericSpace.addSubpropMaker(propertyMaker);
        propertyMaker = new LengthProperty.Maker(2560);
        propertyMaker.setDefault("0pt");
        propertyMaker.setByShorthand(true);
        this.genericSpace.addSubpropMaker(propertyMaker);
        propertyMaker = new NumberProperty.Maker(4096);
        propertyMaker.addEnum("force", this.getEnumProperty(53, "FORCE"));
        propertyMaker.setDefault("0");
        this.genericSpace.addSubpropMaker(propertyMaker);
        propertyMaker = new EnumProperty.Maker(1024);
        propertyMaker.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        propertyMaker.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        propertyMaker.setDefault("discard");
        this.genericSpace.addSubpropMaker(propertyMaker);
    }

    private static void addPropertyMaker(String string, PropertyMaker propertyMaker) {
        FOPropertyMapping.generics[propertyMaker.getPropId()] = propertyMaker;
        propNames.put(string, propertyMaker.getPropId());
        propIds.put(propertyMaker.getPropId(), string);
    }

    private static void addSubpropMakerName(String string, int n) {
        subPropNames.put(string, n);
        propIds.put(n, string);
    }

    private Property getEnumProperty(int n, String string) {
        if (this.enums == null) {
            this.enums = new Property[206];
        }
        if (this.enums[n] == null) {
            this.enums[n] = EnumProperty.getInstance(n, string);
        }
        return this.enums[n];
    }

    public static PropertyMaker[] getGenericMappings() {
        if (generics == null) {
            generics = new PropertyMaker[277];
            FOPropertyMapping fOPropertyMapping = new FOPropertyMapping();
            fOPropertyMapping.createShorthandProperties();
            fOPropertyMapping.createGenerics();
            fOPropertyMapping.createAccessibilityProperties();
            fOPropertyMapping.createAbsolutePositionProperties();
            fOPropertyMapping.createAuralProperties();
            fOPropertyMapping.createBorderPaddingBackgroundProperties();
            fOPropertyMapping.createFontProperties();
            fOPropertyMapping.createHyphenationProperties();
            fOPropertyMapping.createMarginBlockProperties();
            fOPropertyMapping.createMarginInlineProperties();
            fOPropertyMapping.createRelativePosProperties();
            fOPropertyMapping.createAreaAlignmentProperties();
            fOPropertyMapping.createAreaDimensionProperties();
            fOPropertyMapping.createBlockAndLineProperties();
            fOPropertyMapping.createCharacterProperties();
            fOPropertyMapping.createColorProperties();
            fOPropertyMapping.createFloatProperties();
            fOPropertyMapping.createKeepsAndBreaksProperties();
            fOPropertyMapping.createLayoutProperties();
            fOPropertyMapping.createLeaderAndRuleProperties();
            fOPropertyMapping.createDynamicProperties();
            fOPropertyMapping.createMarkersProperties();
            fOPropertyMapping.createNumberToStringProperties();
            fOPropertyMapping.createPaginationAndLayoutProperties();
            fOPropertyMapping.createTableProperties();
            fOPropertyMapping.createWritingModeProperties();
            fOPropertyMapping.createMiscProperties();
            FOPropertyMapping.addSubpropMakerName("length", 2048);
            FOPropertyMapping.addSubpropMakerName("conditionality", 1024);
            FOPropertyMapping.addSubpropMakerName("block-progression-direction", 512);
            FOPropertyMapping.addSubpropMakerName("inline-progression-direction", 1536);
            FOPropertyMapping.addSubpropMakerName("within-line", 5120);
            FOPropertyMapping.addSubpropMakerName("within-column", 4608);
            FOPropertyMapping.addSubpropMakerName("within-page", 5632);
            FOPropertyMapping.addSubpropMakerName("minimum", 3072);
            FOPropertyMapping.addSubpropMakerName("maximum", 2560);
            FOPropertyMapping.addSubpropMakerName("optimum", 3584);
            FOPropertyMapping.addSubpropMakerName("precedence", 4096);
        }
        return generics;
    }

    public static int getPropertyId(String string) {
        Integer n;
        if (string != null && (n = propNames.get(string)) != null) {
            return n;
        }
        return -1;
    }

    public static int getSubPropertyId(String string) {
        Integer n;
        if (string != null && (n = subPropNames.get(string)) != null) {
            return n;
        }
        return -1;
    }

    public static String getPropertyName(int n) {
        if ((n & 0xFFFFFE00) == 0 || (n & 0x1FF) == 0) {
            return propIds.get(n);
        }
        return propIds.get(n & 0x1FF) + "." + propIds.get(n & 0xFFFFFE00);
    }

    private void createAccessibilityProperties() {
        StringProperty.Maker maker = new StringProperty.Maker(221);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("source-document", maker);
        maker = new StringProperty.Maker(212);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("role", maker);
    }

    private void createAbsolutePositionProperties() {
        EnumProperty.Maker maker = new EnumProperty.Maker(1);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        maker.addEnum("absolute", this.getEnumProperty(1, "ABSOLUTE"));
        maker.setDefault("auto");
        maker.addShorthand(generics[193]);
        FOPropertyMapping.addPropertyMaker("absolute-position", maker);
        LengthProperty.Maker maker2 = new LengthProperty.Maker(253);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setDefault("auto");
        maker2.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("top", maker2);
        maker2 = new LengthProperty.Maker(211);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setDefault("auto");
        maker2.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("right", maker2);
        maker2 = new LengthProperty.Maker(57);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setDefault("auto");
        maker2.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("bottom", maker2);
        maker2 = new LengthProperty.Maker(140);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setDefault("auto");
        maker2.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("left", maker2);
    }

    private void createAuralProperties() {
        ToBeImplementedProperty.Maker maker = new ToBeImplementedProperty.Maker(6);
        maker.setInherited(true);
        maker.setDefault("center");
        FOPropertyMapping.addPropertyMaker("azimuth", maker);
        maker = new ToBeImplementedProperty.Maker(83);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("cue-after", maker);
        maker = new ToBeImplementedProperty.Maker(84);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("cue-before", maker);
        maker = new ToBeImplementedProperty.Maker(89);
        maker.setInherited(true);
        maker.setDefault("level");
        FOPropertyMapping.addPropertyMaker("elevation", maker);
        maker = new ToBeImplementedProperty.Maker(188);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause-after", maker);
        maker = new ToBeImplementedProperty.Maker(189);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause-before", maker);
        maker = new ToBeImplementedProperty.Maker(190);
        maker.setInherited(true);
        maker.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("pitch", maker);
        maker = new ToBeImplementedProperty.Maker(191);
        maker.setInherited(true);
        maker.setDefault("50");
        FOPropertyMapping.addPropertyMaker("pitch-range", maker);
        maker = new ToBeImplementedProperty.Maker(192);
        maker.setInherited(false);
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("play-during", maker);
        maker = new ToBeImplementedProperty.Maker(210);
        maker.setInherited(true);
        maker.setDefault("50");
        FOPropertyMapping.addPropertyMaker("richness", maker);
        maker = new ToBeImplementedProperty.Maker(227);
        maker.setInherited(true);
        maker.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("speak", maker);
        maker = new ToBeImplementedProperty.Maker(228);
        maker.setInherited(true);
        maker.setDefault("once");
        FOPropertyMapping.addPropertyMaker("speak-header", maker);
        maker = new ToBeImplementedProperty.Maker(229);
        maker.setInherited(true);
        maker.setDefault("continuous");
        FOPropertyMapping.addPropertyMaker("speak-numeral", maker);
        maker = new ToBeImplementedProperty.Maker(230);
        maker.setInherited(true);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("speak-punctuation", maker);
        maker = new ToBeImplementedProperty.Maker(231);
        maker.setInherited(true);
        maker.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("speech-rate", maker);
        maker = new ToBeImplementedProperty.Maker(236);
        maker.setInherited(true);
        maker.setDefault("50");
        FOPropertyMapping.addPropertyMaker("stress", maker);
        maker = new ToBeImplementedProperty.Maker(258);
        maker.setInherited(true);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("voice-family", maker);
        maker = new ToBeImplementedProperty.Maker(259);
        maker.setInherited(true);
        maker.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("volume", maker);
    }

    private void createBorderPaddingBackgroundProperties() {
        PropertyMaker propertyMaker = new EnumProperty.Maker(8);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("scroll", this.getEnumProperty(126, "SCROLL"));
        propertyMaker.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        propertyMaker.setDefault("scroll");
        FOPropertyMapping.addPropertyMaker("background-attachment", propertyMaker);
        propertyMaker = new ColorProperty.Maker(9){

            protected Property convertPropertyDatatype(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
                String string = property.getNCname();
                if (string != null) {
                    FObj fObj2 = fObj == null ? propertyList.getFObj() : fObj;
                    FOUserAgent fOUserAgent = fObj2 == null ? null : fObj2.getUserAgent();
                    return ColorProperty.getInstance(fOUserAgent, string);
                }
                return super.convertPropertyDatatype(property, propertyList, fObj);
            }
        };
        propertyMaker.useGeneric(this.genericColor);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("transparent");
        FOPropertyMapping.addPropertyMaker("background-color", propertyMaker);
        propertyMaker = new StringProperty.Maker(10);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("background-image", propertyMaker);
        propertyMaker = new EnumProperty.Maker(14);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("repeat", this.getEnumProperty(112, "REPEAT"));
        propertyMaker.addEnum("repeat-x", this.getEnumProperty(113, "REPEATX"));
        propertyMaker.addEnum("repeat-y", this.getEnumProperty(114, "REPEATY"));
        propertyMaker.addEnum("no-repeat", this.getEnumProperty(96, "NOREPEAT"));
        propertyMaker.setDefault("repeat");
        FOPropertyMapping.addPropertyMaker("background-repeat", propertyMaker);
        propertyMaker = new LengthProperty.Maker(12);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("0pt");
        propertyMaker.addKeyword("left", "0pt");
        propertyMaker.addKeyword("center", "50%");
        propertyMaker.addKeyword("right", "100%");
        propertyMaker.setPercentBase(9);
        propertyMaker.addShorthand(generics[11]);
        FOPropertyMapping.addPropertyMaker("background-position-horizontal", propertyMaker);
        propertyMaker = new LengthProperty.Maker(13);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("0pt");
        propertyMaker.addKeyword("top", "0pt");
        propertyMaker.addKeyword("center", "50%");
        propertyMaker.addKeyword("bottom", "100%");
        propertyMaker.setPercentBase(10);
        propertyMaker.addShorthand(generics[11]);
        FOPropertyMapping.addPropertyMaker("background-position-vertical", propertyMaker);
        propertyMaker = new ColorProperty.Maker(23);
        propertyMaker.useGeneric(this.genericColor);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("black");
        CorrespondingPropertyMaker correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(53, 53, 42, 38);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-color", propertyMaker);
        propertyMaker = new EnumProperty.Maker(25);
        propertyMaker.useGeneric(this.genericBorderStyle);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(54, 54, 43, 39);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-style", propertyMaker);
        propertyMaker = new CondLengthProperty.Maker(26);
        propertyMaker.useGeneric(this.genericCondBorderWidth);
        propertyMaker.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(55, 55, 44, 40);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-width", propertyMaker);
        propertyMaker = new ColorProperty.Maker(19);
        propertyMaker.useGeneric(this.genericColor);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("black");
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(28, 28, 38, 42);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-color", propertyMaker);
        propertyMaker = new EnumProperty.Maker(21);
        propertyMaker.useGeneric(this.genericBorderStyle);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(29, 29, 39, 43);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-style", propertyMaker);
        propertyMaker = new CondLengthProperty.Maker(22);
        propertyMaker.useGeneric(this.genericCondBorderWidth);
        propertyMaker.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(30, 30, 40, 40);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-width", propertyMaker);
        propertyMaker = new ColorProperty.Maker(47);
        propertyMaker.useGeneric(this.genericColor);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("black");
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(38, 42, 53, 53);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-color", propertyMaker);
        propertyMaker = new EnumProperty.Maker(49);
        propertyMaker.useGeneric(this.genericBorderStyle);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(39, 43, 54, 54);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-style", propertyMaker);
        propertyMaker = new CondLengthProperty.Maker(50);
        propertyMaker.useGeneric(this.genericCondBorderWidth);
        propertyMaker.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(40, 44, 55, 55);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-width", propertyMaker);
        propertyMaker = new ColorProperty.Maker(33);
        propertyMaker.useGeneric(this.genericColor);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("black");
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(42, 38, 28, 28);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-color", propertyMaker);
        propertyMaker = new EnumProperty.Maker(35);
        propertyMaker.useGeneric(this.genericBorderStyle);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(43, 39, 29, 29);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-style", propertyMaker);
        propertyMaker = new CondLengthProperty.Maker(36);
        propertyMaker.useGeneric(this.genericCondBorderWidth);
        propertyMaker.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(44, 40, 30, 30);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-width", propertyMaker);
        propertyMaker = new ColorProperty.Maker(53);
        propertyMaker.useGeneric(this.genericColor);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("black");
        propertyMaker.addShorthand(generics[52]);
        propertyMaker.addShorthand(generics[32]);
        propertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(23, 23, 47, 47);
        FOPropertyMapping.addPropertyMaker("border-top-color", propertyMaker);
        propertyMaker = new EnumProperty.Maker(54);
        propertyMaker.useGeneric(this.genericBorderStyle);
        propertyMaker.addShorthand(generics[52]);
        propertyMaker.addShorthand(generics[51]);
        propertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(25, 25, 49, 49);
        FOPropertyMapping.addPropertyMaker("border-top-style", propertyMaker);
        BorderWidthPropertyMaker borderWidthPropertyMaker = new BorderWidthPropertyMaker(55);
        borderWidthPropertyMaker.useGeneric(this.genericBorderWidth);
        borderWidthPropertyMaker.setBorderStyleId(54);
        borderWidthPropertyMaker.addShorthand(generics[52]);
        borderWidthPropertyMaker.addShorthand(generics[56]);
        borderWidthPropertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(borderWidthPropertyMaker);
        correspondingPropertyMaker.setCorresponding(26, 26, 50, 50);
        FOPropertyMapping.addPropertyMaker("border-top-width", borderWidthPropertyMaker);
        propertyMaker = new ColorProperty.Maker(28);
        propertyMaker.useGeneric(this.genericColor);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("black");
        propertyMaker.addShorthand(generics[27]);
        propertyMaker.addShorthand(generics[32]);
        propertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(19, 19, 33, 33);
        FOPropertyMapping.addPropertyMaker("border-bottom-color", propertyMaker);
        propertyMaker = new EnumProperty.Maker(29);
        propertyMaker.useGeneric(this.genericBorderStyle);
        propertyMaker.addShorthand(generics[27]);
        propertyMaker.addShorthand(generics[51]);
        propertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(21, 21, 35, 35);
        FOPropertyMapping.addPropertyMaker("border-bottom-style", propertyMaker);
        borderWidthPropertyMaker = new BorderWidthPropertyMaker(30);
        borderWidthPropertyMaker.useGeneric(this.genericBorderWidth);
        borderWidthPropertyMaker.setBorderStyleId(29);
        borderWidthPropertyMaker.addShorthand(generics[27]);
        borderWidthPropertyMaker.addShorthand(generics[56]);
        borderWidthPropertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(borderWidthPropertyMaker);
        correspondingPropertyMaker.setCorresponding(22, 22, 36, 36);
        FOPropertyMapping.addPropertyMaker("border-bottom-width", borderWidthPropertyMaker);
        propertyMaker = new ColorProperty.Maker(38);
        propertyMaker.useGeneric(this.genericColor);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("black");
        propertyMaker.addShorthand(generics[37]);
        propertyMaker.addShorthand(generics[32]);
        propertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(47, 33, 19, 23);
        FOPropertyMapping.addPropertyMaker("border-left-color", propertyMaker);
        propertyMaker = new EnumProperty.Maker(39);
        propertyMaker.useGeneric(this.genericBorderStyle);
        propertyMaker.addShorthand(generics[37]);
        propertyMaker.addShorthand(generics[51]);
        propertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(49, 35, 21, 25);
        FOPropertyMapping.addPropertyMaker("border-left-style", propertyMaker);
        borderWidthPropertyMaker = new BorderWidthPropertyMaker(40);
        borderWidthPropertyMaker.useGeneric(this.genericBorderWidth);
        borderWidthPropertyMaker.setBorderStyleId(39);
        borderWidthPropertyMaker.addShorthand(generics[37]);
        borderWidthPropertyMaker.addShorthand(generics[56]);
        borderWidthPropertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(borderWidthPropertyMaker);
        correspondingPropertyMaker.setCorresponding(50, 36, 22, 26);
        FOPropertyMapping.addPropertyMaker("border-left-width", borderWidthPropertyMaker);
        propertyMaker = new ColorProperty.Maker(42);
        propertyMaker.useGeneric(this.genericColor);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("black");
        propertyMaker.addShorthand(generics[41]);
        propertyMaker.addShorthand(generics[32]);
        propertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(33, 47, 23, 19);
        FOPropertyMapping.addPropertyMaker("border-right-color", propertyMaker);
        propertyMaker = new EnumProperty.Maker(43);
        propertyMaker.useGeneric(this.genericBorderStyle);
        propertyMaker.addShorthand(generics[41]);
        propertyMaker.addShorthand(generics[51]);
        propertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(35, 49, 25, 21);
        FOPropertyMapping.addPropertyMaker("border-right-style", propertyMaker);
        borderWidthPropertyMaker = new BorderWidthPropertyMaker(44);
        borderWidthPropertyMaker.useGeneric(this.genericBorderWidth);
        borderWidthPropertyMaker.setBorderStyleId(43);
        borderWidthPropertyMaker.addShorthand(generics[41]);
        borderWidthPropertyMaker.addShorthand(generics[56]);
        borderWidthPropertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(borderWidthPropertyMaker);
        correspondingPropertyMaker.setCorresponding(36, 50, 26, 22);
        FOPropertyMapping.addPropertyMaker("border-right-width", borderWidthPropertyMaker);
        propertyMaker = new CondLengthProperty.Maker(172);
        propertyMaker.useGeneric(this.genericCondPadding);
        propertyMaker.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(178, 178, 176, 175);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-before", propertyMaker);
        propertyMaker = new CondLengthProperty.Maker(171);
        propertyMaker.useGeneric(this.genericCondPadding);
        propertyMaker.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(173, 173, 175, 176);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-after", propertyMaker);
        propertyMaker = new CondLengthProperty.Maker(177);
        propertyMaker.useGeneric(this.genericCondPadding);
        propertyMaker.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(175, 176, 178, 178);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-start", propertyMaker);
        propertyMaker = new CondLengthProperty.Maker(174);
        propertyMaker.useGeneric(this.genericCondPadding);
        propertyMaker.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(176, 175, 173, 173);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-end", propertyMaker);
        propertyMaker = new LengthProperty.Maker(178);
        propertyMaker.useGeneric(this.genericPadding);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(172, 172, 177, 177);
        FOPropertyMapping.addPropertyMaker("padding-top", propertyMaker);
        propertyMaker = new LengthProperty.Maker(173);
        propertyMaker.useGeneric(this.genericPadding);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(171, 171, 174, 174);
        FOPropertyMapping.addPropertyMaker("padding-bottom", propertyMaker);
        propertyMaker = new LengthProperty.Maker(175);
        propertyMaker.useGeneric(this.genericPadding);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(177, 174, 171, 172);
        FOPropertyMapping.addPropertyMaker("padding-left", propertyMaker);
        propertyMaker = new LengthProperty.Maker(176);
        propertyMaker.useGeneric(this.genericPadding);
        correspondingPropertyMaker = new CorrespondingPropertyMaker(propertyMaker);
        correspondingPropertyMaker.setCorresponding(174, 177, 172, 171);
        FOPropertyMapping.addPropertyMaker("padding-right", propertyMaker);
    }

    private void createFontProperties() {
        PropertyMaker propertyMaker = new FontFamilyProperty.Maker(101);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("sans-serif,Symbol,ZapfDingbats");
        propertyMaker.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-family", propertyMaker);
        propertyMaker = new EnumProperty.Maker(102);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("character-by-character", this.getEnumProperty(25, "CHARACTER_BY_CHARACTER"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("font-selection-strategy", propertyMaker);
        propertyMaker = new FontSizePropertyMaker(103);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("12pt");
        propertyMaker.addKeyword("xx-small", "6.944pt");
        propertyMaker.addKeyword("x-small", "8.333pt");
        propertyMaker.addKeyword("small", "10pt");
        propertyMaker.addKeyword("medium", "12pt");
        propertyMaker.addKeyword("large", "14.4pt");
        propertyMaker.addKeyword("x-large", "17.28pt");
        propertyMaker.addKeyword("xx-large", "20.736pt");
        propertyMaker.addEnum("larger", this.getEnumProperty(71, "LARGER"));
        propertyMaker.addEnum("smaller", this.getEnumProperty(132, "SMALLER"));
        propertyMaker.setPercentBase(2);
        propertyMaker.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-size", propertyMaker);
        propertyMaker = new FontStretchPropertyMaker(105);
        propertyMaker.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        propertyMaker.addEnum("wider", this.getEnumProperty(160, "WIDER"));
        propertyMaker.addEnum("narrower", this.getEnumProperty(85, "NARROWER"));
        propertyMaker.addEnum("ultra-condensed", this.getEnumProperty(150, "ULTRA_CONDENSED"));
        propertyMaker.addEnum("extra-condensed", this.getEnumProperty(46, "EXTRA_CONDENSED"));
        propertyMaker.addEnum("condensed", this.getEnumProperty(29, "CONDENSED"));
        propertyMaker.addEnum("semi-condensed", this.getEnumProperty(127, "SEMI_CONDENSED"));
        propertyMaker.addEnum("semi-expanded", this.getEnumProperty(128, "SEMI_EXPANDED"));
        propertyMaker.addEnum("expanded", this.getEnumProperty(45, "EXPANDED"));
        propertyMaker.addEnum("extra-expanded", this.getEnumProperty(47, "EXTRA_EXPANDED"));
        propertyMaker.addEnum("ultra-expanded", this.getEnumProperty(151, "ULTRA_EXPANDED"));
        propertyMaker.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("font-stretch", propertyMaker);
        propertyMaker = new NumberProperty.Maker(104);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("none", this.getEnumProperty(95, "NONE"));
        propertyMaker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("font-size-adjust", propertyMaker);
        propertyMaker = new EnumProperty.Maker(106);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        propertyMaker.addEnum("italic", this.getEnumProperty(164, "ITALIC"));
        propertyMaker.addEnum("oblique", this.getEnumProperty(165, "OBLIQUE"));
        propertyMaker.addEnum("backslant", this.getEnumProperty(166, "BACKSLANT"));
        propertyMaker.setDefault("normal");
        propertyMaker.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-style", propertyMaker);
        propertyMaker = new EnumProperty.Maker(107);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        propertyMaker.addEnum("small-caps", this.getEnumProperty(131, "SMALL_CAPS"));
        propertyMaker.setDefault("normal");
        propertyMaker.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-variant", propertyMaker);
        propertyMaker = new FontWeightPropertyMaker(108);
        propertyMaker.setInherited(true);
        propertyMaker.addKeyword("normal", "400");
        propertyMaker.addKeyword("bold", "700");
        propertyMaker.addEnum("bolder", this.getEnumProperty(167, "BOLDER"));
        propertyMaker.addEnum("lighter", this.getEnumProperty(168, "LIGHTER"));
        propertyMaker.addEnum("100", this.getEnumProperty(169, "100"));
        propertyMaker.addEnum("200", this.getEnumProperty(170, "200"));
        propertyMaker.addEnum("300", this.getEnumProperty(171, "300"));
        propertyMaker.addEnum("400", this.getEnumProperty(172, "400"));
        propertyMaker.addEnum("500", this.getEnumProperty(173, "500"));
        propertyMaker.addEnum("600", this.getEnumProperty(174, "600"));
        propertyMaker.addEnum("700", this.getEnumProperty(175, "700"));
        propertyMaker.addEnum("800", this.getEnumProperty(176, "800"));
        propertyMaker.addEnum("900", this.getEnumProperty(177, "900"));
        propertyMaker.setDefault("400");
        propertyMaker.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-weight", propertyMaker);
    }

    private void createHyphenationProperties() {
        PropertyMaker propertyMaker = new StringProperty.Maker(81);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("none");
        propertyMaker.addShorthand(generics[268]);
        FOPropertyMapping.addPropertyMaker("country", propertyMaker);
        propertyMaker = new StringProperty.Maker(134);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("none");
        propertyMaker.addShorthand(generics[268]);
        FOPropertyMapping.addPropertyMaker("language", propertyMaker);
        propertyMaker = new StringProperty.Maker(218);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("script", propertyMaker);
        propertyMaker = new EnumProperty.Maker(116);
        propertyMaker.useGeneric(this.genericBoolean);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("hyphenate", propertyMaker);
        propertyMaker = new CharacterProperty.Maker(117);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("-");
        FOPropertyMapping.addPropertyMaker("hyphenation-character", propertyMaker);
        propertyMaker = new NumberProperty.PositiveIntegerMaker(120);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("2");
        FOPropertyMapping.addPropertyMaker("hyphenation-push-character-count", propertyMaker);
        propertyMaker = new NumberProperty.PositiveIntegerMaker(121);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("2");
        FOPropertyMapping.addPropertyMaker("hyphenation-remain-character-count", propertyMaker);
    }

    private void createMarginBlockProperties() {
        PropertyMaker propertyMaker = new LengthProperty.Maker(151);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("0pt");
        propertyMaker.addShorthand(generics[147]);
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-top", propertyMaker);
        propertyMaker = new LengthProperty.Maker(148);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("0pt");
        propertyMaker.addShorthand(generics[147]);
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-bottom", propertyMaker);
        propertyMaker = new LengthProperty.Maker(149);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("0pt");
        propertyMaker.addShorthand(generics[147]);
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-left", propertyMaker);
        propertyMaker = new LengthProperty.Maker(150);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("0pt");
        propertyMaker.addShorthand(generics[147]);
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-right", propertyMaker);
        propertyMaker = new SpaceProperty.Maker(223);
        propertyMaker.useGeneric(this.genericSpace);
        SpacePropertyMaker spacePropertyMaker = new SpacePropertyMaker(propertyMaker);
        spacePropertyMaker.setCorresponding(151, 151, 150, 149);
        spacePropertyMaker.setUseParent(false);
        spacePropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("space-before", propertyMaker);
        propertyMaker = new SpaceProperty.Maker(222);
        propertyMaker.useGeneric(this.genericSpace);
        spacePropertyMaker = new SpacePropertyMaker(propertyMaker);
        spacePropertyMaker.setCorresponding(148, 148, 149, 150);
        spacePropertyMaker.setUseParent(false);
        spacePropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("space-after", propertyMaker);
        propertyMaker = new LengthProperty.Maker(233);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("0pt");
        propertyMaker.setPercentBase(4);
        IndentPropertyMaker indentPropertyMaker = new IndentPropertyMaker(propertyMaker);
        indentPropertyMaker.setCorresponding(149, 150, 151, 151);
        indentPropertyMaker.setUseParent(false);
        indentPropertyMaker.setRelative(true);
        indentPropertyMaker.setPaddingCorresponding(new int[]{175, 176, 178, 178});
        indentPropertyMaker.setBorderWidthCorresponding(new int[]{40, 44, 55, 55});
        FOPropertyMapping.addPropertyMaker("start-indent", propertyMaker);
        propertyMaker = new LengthProperty.Maker(91);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("0pt");
        propertyMaker.setPercentBase(4);
        IndentPropertyMaker indentPropertyMaker2 = new IndentPropertyMaker(propertyMaker);
        indentPropertyMaker2.setCorresponding(150, 149, 148, 148);
        indentPropertyMaker2.setUseParent(false);
        indentPropertyMaker2.setRelative(true);
        indentPropertyMaker2.setPaddingCorresponding(new int[]{176, 175, 173, 173});
        indentPropertyMaker2.setBorderWidthCorresponding(new int[]{44, 40, 30, 30});
        FOPropertyMapping.addPropertyMaker("end-indent", propertyMaker);
    }

    private void createMarginInlineProperties() {
        SpaceProperty.Maker maker = new SpaceProperty.Maker(224);
        ((PropertyMaker)maker).useGeneric(this.genericSpace);
        FOPropertyMapping.addPropertyMaker("space-end", maker);
        maker = new SpaceProperty.Maker(225);
        ((PropertyMaker)maker).useGeneric(this.genericSpace);
        FOPropertyMapping.addPropertyMaker("space-start", maker);
    }

    private void createRelativePosProperties() {
        EnumProperty.Maker maker = new EnumProperty.Maker(203);
        maker.setInherited(false);
        maker.addEnum("static", this.getEnumProperty(136, "STATIC"));
        maker.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        maker.setDefault("static");
        maker.addShorthand(generics[193]);
        FOPropertyMapping.addPropertyMaker("relative-position", maker);
    }

    private void createAreaAlignmentProperties() {
        PropertyMaker propertyMaker = new LengthProperty.Maker(3);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        propertyMaker.addEnum("before-edge", this.getEnumProperty(14, "BEFORE_EDGE"));
        propertyMaker.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        propertyMaker.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        propertyMaker.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        propertyMaker.addEnum("after-edge", this.getEnumProperty(4, "AFTER_EDGE"));
        propertyMaker.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        propertyMaker.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        propertyMaker.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        propertyMaker.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        propertyMaker.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        propertyMaker.setDefault("auto");
        propertyMaker.setPercentBase(12);
        propertyMaker.addShorthand(generics[256]);
        FOPropertyMapping.addPropertyMaker("alignment-adjust", propertyMaker);
        propertyMaker = new EnumProperty.Maker(4);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        propertyMaker.addEnum("before-edge", this.getEnumProperty(14, "BEFORE_EDGE"));
        propertyMaker.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        propertyMaker.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        propertyMaker.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        propertyMaker.addEnum("after-edge", this.getEnumProperty(4, "AFTER_EDGE"));
        propertyMaker.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        propertyMaker.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        propertyMaker.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        propertyMaker.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        propertyMaker.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        propertyMaker.setDefault("auto");
        propertyMaker.addShorthand(generics[256]);
        FOPropertyMapping.addPropertyMaker("alignment-baseline", propertyMaker);
        propertyMaker = new LengthProperty.Maker(15);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        propertyMaker.addEnum("sub", this.getEnumProperty(137, "SUB"));
        propertyMaker.addEnum("super", this.getEnumProperty(138, "SUPER"));
        propertyMaker.setDefault("baseline");
        propertyMaker.addShorthand(generics[256]);
        propertyMaker.setPercentBase(0);
        FOPropertyMapping.addPropertyMaker("baseline-shift", propertyMaker);
        propertyMaker = new EnumProperty.Maker(87);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        propertyMaker.addEnum("after", this.getEnumProperty(3, "AFTER"));
        propertyMaker.addEnum("center", this.getEnumProperty(23, "CENTER"));
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("distribute", this.getEnumProperty(163, "DISTRIBUTE"));
        propertyMaker.addEnum("fill", this.getEnumProperty(162, "FILL"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("display-align", propertyMaker);
        propertyMaker = new EnumProperty.Maker(88);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("use-script", this.getEnumProperty(157, "USE_SCRIPT"));
        propertyMaker.addEnum("no-change", this.getEnumProperty(87, "NO_CHANGE"));
        propertyMaker.addEnum("reset-size", this.getEnumProperty(116, "RESET_SIZE"));
        propertyMaker.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        propertyMaker.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        propertyMaker.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        propertyMaker.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        propertyMaker.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        propertyMaker.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        propertyMaker.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        propertyMaker.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        propertyMaker.setDefault("auto");
        propertyMaker.addShorthand(generics[256]);
        FOPropertyMapping.addPropertyMaker("dominant-baseline", propertyMaker);
        propertyMaker = new EnumProperty.Maker(202);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        propertyMaker.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        propertyMaker.setDefault("before");
        FOPropertyMapping.addPropertyMaker("relative-align", propertyMaker);
    }

    private void createAreaDimensionProperties() {
        PropertyMaker propertyMaker = new LengthRangeProperty.Maker(17);
        propertyMaker.setInherited(false);
        propertyMaker.setPercentBase(6);
        LengthProperty.Maker maker = new LengthProperty.Maker(3072);
        maker.setDefault("auto");
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setPercentBase(6);
        maker.setByShorthand(true);
        propertyMaker.addSubpropMaker(maker);
        maker = new LengthProperty.Maker(3584);
        maker.setDefault("auto");
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setPercentBase(6);
        maker.setByShorthand(true);
        propertyMaker.addSubpropMaker(maker);
        maker = new LengthProperty.Maker(2560);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setDefault("auto");
        maker.setPercentBase(6);
        maker.setByShorthand(true);
        propertyMaker.addSubpropMaker(maker);
        DimensionPropertyMaker dimensionPropertyMaker = new DimensionPropertyMaker(propertyMaker);
        dimensionPropertyMaker.setCorresponding(115, 115, 264, 264);
        dimensionPropertyMaker.setExtraCorresponding(new int[][]{{162, 162, 163, 163}, {155, 155, 157, 157}});
        dimensionPropertyMaker.setRelative(true);
        propertyMaker.setCorresponding(dimensionPropertyMaker);
        FOPropertyMapping.addPropertyMaker("block-progression-dimension", propertyMaker);
        maker = new LengthProperty.Maker(78);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("scale-to-fit", this.getEnumProperty(125, "SCALE_TO_FIT"));
        maker.addEnum("scale-down-to-fit", this.getEnumProperty(187, "SCALE_DOWN_TO_FIT"));
        maker.addEnum("scale-up-to-fit", this.getEnumProperty(188, "SCALE_UP_TO_FIT"));
        maker.setDefault("auto");
        maker.setPercentBase(8);
        FOPropertyMapping.addPropertyMaker("content-height", maker);
        maker = new LengthProperty.Maker(80);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("scale-to-fit", this.getEnumProperty(125, "SCALE_TO_FIT"));
        maker.addEnum("scale-down-to-fit", this.getEnumProperty(187, "SCALE_DOWN_TO_FIT"));
        maker.addEnum("scale-up-to-fit", this.getEnumProperty(188, "SCALE_UP_TO_FIT"));
        maker.setDefault("auto");
        maker.setPercentBase(7);
        FOPropertyMapping.addPropertyMaker("content-width", maker);
        maker = new LengthProperty.Maker(115);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setPercentBase(6);
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("height", maker);
        propertyMaker = new LengthRangeProperty.Maker(127);
        propertyMaker.setInherited(false);
        propertyMaker.setPercentBase(5);
        maker = new LengthProperty.Maker(3072);
        maker.setDefault("auto");
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setPercentBase(5);
        maker.setByShorthand(true);
        propertyMaker.addSubpropMaker(maker);
        maker = new LengthProperty.Maker(3584);
        maker.setDefault("auto");
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setPercentBase(5);
        maker.setByShorthand(true);
        propertyMaker.addSubpropMaker(maker);
        maker = new LengthProperty.Maker(2560);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setDefault("auto");
        maker.setPercentBase(5);
        maker.setByShorthand(true);
        propertyMaker.addSubpropMaker(maker);
        dimensionPropertyMaker = new DimensionPropertyMaker(propertyMaker);
        dimensionPropertyMaker.setRelative(true);
        dimensionPropertyMaker.setCorresponding(264, 264, 115, 115);
        dimensionPropertyMaker.setExtraCorresponding(new int[][]{{163, 163, 162, 162}, {157, 157, 155, 162}});
        propertyMaker.setCorresponding(dimensionPropertyMaker);
        FOPropertyMapping.addPropertyMaker("inline-progression-dimension", propertyMaker);
        propertyMaker = new LengthProperty.Maker(155);
        propertyMaker.addEnum("NONE", this.getEnumProperty(95, "NONE"));
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("0pt");
        propertyMaker.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("max-height", propertyMaker);
        propertyMaker = new LengthProperty.Maker(157);
        propertyMaker.addEnum("NONE", this.getEnumProperty(95, "NONE"));
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("none");
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("max-width", propertyMaker);
        propertyMaker = new LengthProperty.Maker(162);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("0pt");
        propertyMaker.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("min-height", propertyMaker);
        propertyMaker = new LengthProperty.Maker(163);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("min-width", propertyMaker);
        propertyMaker = new EnumProperty.Maker(215);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("uniform", this.getEnumProperty(154, "UNIFORM"));
        propertyMaker.addEnum("non-uniform", this.getEnumProperty(94, "NON_UNIFORM"));
        propertyMaker.setDefault("uniform");
        FOPropertyMapping.addPropertyMaker("scaling", propertyMaker);
        propertyMaker = new EnumProperty.Maker(216);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("integer-pixels", this.getEnumProperty(69, "INTEGER_PIXELS"));
        propertyMaker.addEnum("resample-any-method", this.getEnumProperty(115, "RESAMPLE_ANY_METHOD"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("scaling-method", propertyMaker);
        maker = new LengthProperty.Maker(264);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setPercentBase(5);
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("width", maker);
        maker = new LengthProperty.Maker(270);
        maker.setInherited(false);
        maker.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:block-progression-unit", maker);
    }

    private Property calcWritingModeDependent(int n, int n2) {
        if (n == 73) {
            n = n2 == 79 ? 135 : (n2 == 121 ? 39 : 135);
        } else if (n == 120) {
            n = n2 == 79 ? 39 : (n2 == 121 ? 135 : 39);
        }
        return this.makeWritingModeDependentEnum(n);
    }

    private Property makeWritingModeDependentEnum(int n) {
        if (n == 135) {
            return this.getEnumProperty(135, "START");
        }
        if (n == 39) {
            return this.getEnumProperty(39, "END");
        }
        return null;
    }

    private void createBlockAndLineProperties() {
        PropertyMaker propertyMaker = new EnumProperty.Maker(118);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("column", this.getEnumProperty(28, "COLUMN"));
        propertyMaker.addEnum("page", this.getEnumProperty(104, "PAGE"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("hyphenation-keep", propertyMaker);
        propertyMaker = new NumberProperty.Maker(119);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("no-limit", this.getEnumProperty(89, "NO_LIMIT"));
        propertyMaker.setDefault("no-limit");
        FOPropertyMapping.addPropertyMaker("hyphenation-ladder-count", propertyMaker);
        propertyMaker = new LengthProperty.Maker(135);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("0pt");
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("last-line-end-indent", propertyMaker);
        propertyMaker = new LineHeightPropertyMaker(144);
        propertyMaker.useGeneric(this.genericSpace);
        propertyMaker.setInherited(true);
        propertyMaker.addKeyword("normal", "1.2");
        propertyMaker.setPercentBase(1);
        propertyMaker.setDefault("normal", true);
        propertyMaker.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("line-height", propertyMaker);
        propertyMaker = new EnumProperty.Maker(145);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("consider-shifts", this.getEnumProperty(30, "CONSIDER_SHIFTS"));
        propertyMaker.addEnum("disregard-shifts", this.getEnumProperty(33, "DISREGARD_SHIFTS"));
        propertyMaker.setDefault("consider-shifts");
        FOPropertyMapping.addPropertyMaker("line-height-shift-adjustment", propertyMaker);
        propertyMaker = new EnumProperty.Maker(146);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("line-height", this.getEnumProperty(76, "LINE_HEIGHT"));
        propertyMaker.addEnum("font-height", this.getEnumProperty(52, "FONT_HEIGHT"));
        propertyMaker.addEnum("max-height", this.getEnumProperty(83, "MAX_HEIGHT"));
        propertyMaker.setDefault("max-height");
        FOPropertyMapping.addPropertyMaker("line-stacking-strategy", propertyMaker);
        propertyMaker = new EnumProperty.Maker(143);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("ignore", this.getEnumProperty(60, "IGNORE"));
        propertyMaker.addEnum("preserve", this.getEnumProperty(108, "PRESERVE"));
        propertyMaker.addEnum("treat-as-space", this.getEnumProperty(147, "TREAT_AS_SPACE"));
        propertyMaker.addEnum("treat-as-zero-width-space", this.getEnumProperty(148, "TREAT_AS_ZERO_WIDTH_SPACE"));
        propertyMaker.setDefault("treat-as-space");
        propertyMaker.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("linefeed-treatment", propertyMaker);
        propertyMaker = new EnumProperty.Maker(262);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("ignore", this.getEnumProperty(60, "IGNORE"));
        propertyMaker.addEnum("preserve", this.getEnumProperty(108, "PRESERVE"));
        propertyMaker.addEnum("ignore-if-before-linefeed", this.getEnumProperty(62, "IGNORE_IF_BEFORE_LINEFEED"));
        propertyMaker.addEnum("ignore-if-after-linefeed", this.getEnumProperty(61, "IGNORE_IF_AFTER_LINEFEED"));
        propertyMaker.addEnum("ignore-if-surrounding-linefeed", this.getEnumProperty(63, "IGNORE_IF_SURROUNDING_LINEFEED"));
        propertyMaker.setDefault("ignore-if-surrounding-linefeed");
        propertyMaker.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("white-space-treatment", propertyMaker);
        propertyMaker = new EnumProperty.Maker(245){

            public Property get(int n, PropertyList propertyList, boolean bl, boolean bl2) throws PropertyException {
                int n2;
                Property property = super.get(n, propertyList, bl, bl2);
                if (property != null && ((n2 = property.getEnum()) == 73 || n2 == 120)) {
                    property = FOPropertyMapping.this.calcWritingModeDependent(n2, propertyList.get(267).getEnum());
                }
                return property;
            }
        };
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("center", this.getEnumProperty(23, "CENTER"));
        propertyMaker.addEnum("end", this.getEnumProperty(39, "END"));
        propertyMaker.addEnum("start", this.getEnumProperty(135, "START"));
        propertyMaker.addEnum("justify", this.getEnumProperty(70, "JUSTIFY"));
        propertyMaker.addEnum("left", this.getEnumProperty(73, "LEFT"));
        propertyMaker.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        propertyMaker.addEnum("inside", this.getEnumProperty(135, "START"));
        propertyMaker.addEnum("outside", this.getEnumProperty(39, "END"));
        propertyMaker.setDefault("start");
        FOPropertyMapping.addPropertyMaker("text-align", propertyMaker);
        propertyMaker = new EnumProperty.Maker(246){

            public Property get(int n, PropertyList propertyList, boolean bl, boolean bl2) throws PropertyException {
                Property property = super.get(n, propertyList, bl, bl2);
                if (property != null && property.getEnum() == 110 && (property = propertyList.getNearestSpecified(246)).getEnum() == 110) {
                    return this.calcRelative(propertyList);
                }
                return property;
            }

            private Property calcRelative(PropertyList propertyList) throws PropertyException {
                Property property = propertyList.get(245);
                if (property == null) {
                    return null;
                }
                int n = property.getEnum();
                if (n == 70) {
                    return FOPropertyMapping.this.getEnumProperty(135, "START");
                }
                if (n == 39) {
                    return FOPropertyMapping.this.getEnumProperty(39, "END");
                }
                if (n == 135) {
                    return FOPropertyMapping.this.getEnumProperty(135, "START");
                }
                if (n == 23) {
                    return FOPropertyMapping.this.getEnumProperty(23, "CENTER");
                }
                if (n == 73) {
                    return FOPropertyMapping.this.calcWritingModeDependent(73, propertyList.get(267).getEnum());
                }
                if (n == 120) {
                    return FOPropertyMapping.this.calcWritingModeDependent(120, propertyList.get(267).getEnum());
                }
                return null;
            }
        };
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        propertyMaker.addEnum("center", this.getEnumProperty(23, "CENTER"));
        propertyMaker.addEnum("end", this.getEnumProperty(39, "END"));
        propertyMaker.addEnum("right", this.getEnumProperty(39, "END"));
        propertyMaker.addEnum("start", this.getEnumProperty(135, "START"));
        propertyMaker.addEnum("left", this.getEnumProperty(135, "START"));
        propertyMaker.addEnum("justify", this.getEnumProperty(70, "JUSTIFY"));
        propertyMaker.addEnum("inside", this.getEnumProperty(135, "START"));
        propertyMaker.addEnum("outside", this.getEnumProperty(39, "END"));
        propertyMaker.setDefault("relative", true);
        FOPropertyMapping.addPropertyMaker("text-align-last", propertyMaker);
        propertyMaker = new LengthProperty.Maker(250);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("0pt");
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("text-indent", propertyMaker);
        propertyMaker = new EnumProperty.Maker(261);
        propertyMaker.useGeneric(this.genericBoolean);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("true");
        propertyMaker.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("white-space-collapse", propertyMaker);
        propertyMaker = new EnumProperty.Maker(266);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("wrap", this.getEnumProperty(161, "WRAP"));
        propertyMaker.addEnum("no-wrap", this.getEnumProperty(93, "NO_WRAP"));
        propertyMaker.setDefault("wrap");
        propertyMaker.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("wrap-option", propertyMaker);
    }

    private void createCharacterProperties() {
        PropertyMaker propertyMaker = new CharacterProperty.Maker(69);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("character", propertyMaker);
        propertyMaker = new SpacingPropertyMaker(141);
        propertyMaker.useGeneric(this.genericSpace);
        propertyMaker.setInherited(true);
        propertyMaker.getSubpropMaker(4096).setDefault("force");
        propertyMaker.getSubpropMaker(1024).setDefault("discard");
        propertyMaker.setDefault("normal");
        propertyMaker.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        FOPropertyMapping.addPropertyMaker("letter-spacing", propertyMaker);
        propertyMaker = new EnumProperty.Maker(237);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("suppress", this.getEnumProperty(139, "SUPPRESS"));
        propertyMaker.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("suppress-at-line-break", propertyMaker);
        propertyMaker = new TextDecorationMaker(248);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("none", this.getEnumProperty(95, "NONE"));
        propertyMaker.addEnum("underline", this.getEnumProperty(153, "UNDERLINE"));
        propertyMaker.addEnum("overline", this.getEnumProperty(103, "OVERLINE"));
        propertyMaker.addEnum("line-through", this.getEnumProperty(77, "LINE_THROUGH"));
        propertyMaker.addEnum("blink", this.getEnumProperty(17, "BLINK"));
        propertyMaker.addEnum("no-underline", this.getEnumProperty(92, "NO_UNDERLINE"));
        propertyMaker.addEnum("no-overline", this.getEnumProperty(91, "NO_OVERLINE"));
        propertyMaker.addEnum("no-line-through", this.getEnumProperty(90, "NO_LINE_THROUGH"));
        propertyMaker.addEnum("no-blink", this.getEnumProperty(86, "NO_BLINK"));
        propertyMaker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-decoration", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(251);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-shadow", propertyMaker);
        propertyMaker = new EnumProperty.Maker(252);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("none", this.getEnumProperty(95, "NONE"));
        propertyMaker.addEnum("capitalize", this.getEnumProperty(22, "CAPITALIZE"));
        propertyMaker.addEnum("uppercase", this.getEnumProperty(155, "UPPERCASE"));
        propertyMaker.addEnum("lowercase", this.getEnumProperty(78, "LOWERCASE"));
        propertyMaker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-transform", propertyMaker);
        propertyMaker = new EnumProperty.Maker(254);
        propertyMaker.useGeneric(this.genericBoolean);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("treat-as-word-space", propertyMaker);
        propertyMaker = new SpacingPropertyMaker(265);
        propertyMaker.useGeneric(this.genericSpace);
        propertyMaker.setInherited(true);
        propertyMaker.getSubpropMaker(4096).setDefault("force");
        propertyMaker.getSubpropMaker(1024).setDefault("discard");
        propertyMaker.setDefault("normal");
        propertyMaker.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        FOPropertyMapping.addPropertyMaker("word-spacing", propertyMaker);
    }

    private void createColorProperties() {
        PropertyMaker propertyMaker = new ColorProperty.Maker(72);
        propertyMaker.useGeneric(this.genericColor);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("black");
        FOPropertyMapping.addPropertyMaker("color", propertyMaker);
        propertyMaker = new StringProperty.Maker(73);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("color-profile-name", propertyMaker);
        propertyMaker = new EnumProperty.Maker(204);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("perceptual", this.getEnumProperty(107, "PERCEPTUAL"));
        propertyMaker.addEnum("relative-colorimetric", this.getEnumProperty(111, "RELATIVE_COLOMETRIC"));
        propertyMaker.addEnum("saturation", this.getEnumProperty(124, "SATURATION"));
        propertyMaker.addEnum("absolute-colorimetric", this.getEnumProperty(2, "ABSOLUTE_COLORMETRIC"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("rendering-intent", propertyMaker);
    }

    private void createFloatProperties() {
        EnumProperty.Maker maker = new EnumProperty.Maker(70);
        maker.setInherited(false);
        maker.addEnum("start", this.getEnumProperty(135, "START"));
        maker.addEnum("end", this.getEnumProperty(39, "END"));
        maker.addEnum("left", this.getEnumProperty(135, "START"));
        maker.addEnum("right", this.getEnumProperty(39, "END"));
        maker.addEnum("both", this.getEnumProperty(19, "BOTH"));
        maker.addEnum("none", this.getEnumProperty(95, "NONE"));
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("clear", maker);
        maker = new EnumProperty.Maker(95);
        maker.setInherited(false);
        maker.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        maker.addEnum("start", this.getEnumProperty(135, "START"));
        maker.addEnum("end", this.getEnumProperty(39, "END"));
        maker.addEnum("left", this.getEnumProperty(135, "START"));
        maker.addEnum("right", this.getEnumProperty(39, "END"));
        maker.addEnum("none", this.getEnumProperty(95, "NONE"));
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("float", maker);
        maker = new EnumProperty.Maker(130);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("none", this.getEnumProperty(95, "NONE"));
        maker.addEnum("line", this.getEnumProperty(75, "LINE"));
        maker.addEnum("indent", this.getEnumProperty(65, "INDENT"));
        maker.addEnum("block", this.getEnumProperty(18, "BLOCK"));
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("intrusion-displace", maker);
    }

    private void createKeepsAndBreaksProperties() {
        PropertyMaker propertyMaker = new EnumProperty.Maker(58);
        propertyMaker.useGeneric(this.genericBreak);
        propertyMaker.addShorthand(generics[179]);
        FOPropertyMapping.addPropertyMaker("break-after", propertyMaker);
        propertyMaker = new EnumProperty.Maker(59);
        propertyMaker.useGeneric(this.genericBreak);
        propertyMaker.addShorthand(generics[180]);
        FOPropertyMapping.addPropertyMaker("break-before", propertyMaker);
        propertyMaker = new KeepProperty.Maker(131);
        propertyMaker.useGeneric(this.genericKeep);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("auto");
        propertyMaker.addShorthand(generics[181]);
        FOPropertyMapping.addPropertyMaker("keep-together", propertyMaker);
        propertyMaker = new KeepProperty.Maker(132);
        propertyMaker.useGeneric(this.genericKeep);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("auto");
        propertyMaker.addShorthand(generics[179]);
        FOPropertyMapping.addPropertyMaker("keep-with-next", propertyMaker);
        propertyMaker = new KeepProperty.Maker(133);
        propertyMaker.useGeneric(this.genericKeep);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("auto");
        propertyMaker.addShorthand(generics[180]);
        FOPropertyMapping.addPropertyMaker("keep-with-previous", propertyMaker);
        propertyMaker = new NumberProperty.Maker(168);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("2");
        FOPropertyMapping.addPropertyMaker("orphans", propertyMaker);
        propertyMaker = new NumberProperty.Maker(263);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("2");
        FOPropertyMapping.addPropertyMaker("widows", propertyMaker);
        propertyMaker = new LengthProperty.Maker(271);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:widow-content-limit", propertyMaker);
        propertyMaker = new LengthProperty.Maker(272);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:orphan-content-limit", propertyMaker);
    }

    private void createLayoutProperties() {
        PropertyMaker propertyMaker = new ToBeImplementedProperty.Maker(71);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("clip", propertyMaker);
        propertyMaker = new EnumProperty.Maker(169);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("visible", this.getEnumProperty(159, "VISIBLE"));
        propertyMaker.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        propertyMaker.addEnum("scroll", this.getEnumProperty(126, "SCROLL"));
        propertyMaker.addEnum("error-if-overflow", this.getEnumProperty(42, "ERROR_IF_OVERFLOW"));
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("overflow", propertyMaker);
        propertyMaker = new ReferenceOrientationMaker(197);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("0");
        FOPropertyMapping.addPropertyMaker("reference-orientation", propertyMaker);
        propertyMaker = new EnumProperty.Maker(226);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("none", this.getEnumProperty(95, "NONE"));
        propertyMaker.addEnum("all", this.getEnumProperty(5, "ALL"));
        propertyMaker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("span", propertyMaker);
        propertyMaker = new EnumProperty.Maker(273);
        propertyMaker.useGeneric(this.genericBoolean);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("fox:disable-column-balancing", propertyMaker);
    }

    private void createLeaderAndRuleProperties() {
        PropertyMaker propertyMaker = new EnumProperty.Maker(136);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("none", this.getEnumProperty(95, "NONE"));
        propertyMaker.addEnum("reference-area", this.getEnumProperty(109, "REFERENCE_AREA"));
        propertyMaker.addEnum("page", this.getEnumProperty(104, "PAGE"));
        propertyMaker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("leader-alignment", propertyMaker);
        propertyMaker = new EnumProperty.Maker(138);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("space", this.getEnumProperty(134, "SPACE"));
        propertyMaker.addEnum("rule", this.getEnumProperty(123, "RULE"));
        propertyMaker.addEnum("dots", this.getEnumProperty(35, "DOTS"));
        propertyMaker.addEnum("use-content", this.getEnumProperty(158, "USECONTENT"));
        propertyMaker.setDefault("space");
        FOPropertyMapping.addPropertyMaker("leader-pattern", propertyMaker);
        propertyMaker = new LengthProperty.Maker(139);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("use-font-metrics", true);
        propertyMaker.addKeyword("use-font-metrics", "0pt");
        propertyMaker.setPercentBase(3);
        FOPropertyMapping.addPropertyMaker("leader-pattern-width", propertyMaker);
        propertyMaker = new LengthRangeProperty.Maker(137);
        propertyMaker.setInherited(true);
        propertyMaker.setPercentBase(3);
        LengthProperty.Maker maker = new LengthProperty.Maker(3072);
        maker.setDefault("0pt");
        maker.setPercentBase(5);
        maker.setByShorthand(true);
        propertyMaker.addSubpropMaker(maker);
        maker = new LengthProperty.Maker(3584);
        maker.setDefault("12.0pt");
        maker.setPercentBase(5);
        maker.setByShorthand(true);
        propertyMaker.addSubpropMaker(maker);
        maker = new LengthProperty.Maker(2560);
        maker.setDefault("100%", true);
        maker.setPercentBase(5);
        maker.setByShorthand(true);
        propertyMaker.addSubpropMaker(maker);
        FOPropertyMapping.addPropertyMaker("leader-length", propertyMaker);
        propertyMaker = new EnumProperty.Maker(213);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("none", this.getEnumProperty(95, "NONE"));
        propertyMaker.addEnum("dotted", this.getEnumProperty(36, "DOTTED"));
        propertyMaker.addEnum("dashed", this.getEnumProperty(31, "DASHED"));
        propertyMaker.addEnum("solid", this.getEnumProperty(133, "SOLID"));
        propertyMaker.addEnum("double", this.getEnumProperty(37, "DOUBLE"));
        propertyMaker.addEnum("groove", this.getEnumProperty(55, "GROOVE"));
        propertyMaker.addEnum("ridge", this.getEnumProperty(119, "RIDGE"));
        propertyMaker.setDefault("solid");
        FOPropertyMapping.addPropertyMaker("rule-style", propertyMaker);
        propertyMaker = new LengthProperty.Maker(214);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("1.0pt");
        FOPropertyMapping.addPropertyMaker("rule-thickness", propertyMaker);
    }

    private void createDynamicProperties() {
        PropertyMaker propertyMaker = new ToBeImplementedProperty.Maker(2);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("active-state", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(5);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("auto-restore", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(61);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("case-name", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(62);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("case-title", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(85);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("destination-placement-offset", propertyMaker);
        propertyMaker = new StringProperty.Maker(94);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("external-destination", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(123);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("indicate-destination", propertyMaker);
        propertyMaker = new StringProperty.Maker(128);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("internal-destination", propertyMaker);
        propertyMaker = new EnumProperty.Maker(219);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("new", this.getEnumProperty(190, "NEW"));
        propertyMaker.addEnum("replace", this.getEnumProperty(189, "REPLACE"));
        propertyMaker.setDefault("replace");
        FOPropertyMapping.addPropertyMaker("show-destination", propertyMaker);
        propertyMaker = new EnumProperty.Maker(234);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("show", this.getEnumProperty(130, "SHOW"));
        propertyMaker.addEnum("hide", this.getEnumProperty(58, "HIDE"));
        propertyMaker.setDefault("show");
        FOPropertyMapping.addPropertyMaker("starting-state", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(238);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("xsl-any");
        FOPropertyMapping.addPropertyMaker("switch-to", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(242);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("use-target-processing-context");
        FOPropertyMapping.addPropertyMaker("target-presentation-context", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(243);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("document-root");
        FOPropertyMapping.addPropertyMaker("target-processing-context", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(244);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("use-normal-stylesheet");
        FOPropertyMapping.addPropertyMaker("target-stylesheet", propertyMaker);
    }

    private void createMarkersProperties() {
        PropertyMaker propertyMaker = new StringProperty.Maker(152);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("marker-class-name", propertyMaker);
        propertyMaker = new StringProperty.Maker(207);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("retrieve-class-name", propertyMaker);
        propertyMaker = new EnumProperty.Maker(208);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("first-starting-within-page", this.getEnumProperty(54, "FSWP"));
        propertyMaker.addEnum("first-including-carryover", this.getEnumProperty(49, "FIC"));
        propertyMaker.addEnum("last-starting-within-page", this.getEnumProperty(81, "LSWP"));
        propertyMaker.addEnum("last-ending-within-page", this.getEnumProperty(74, "LEWP"));
        propertyMaker.setDefault("first-starting-within-page");
        FOPropertyMapping.addPropertyMaker("retrieve-position", propertyMaker);
        propertyMaker = new EnumProperty.Maker(205);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("page", this.getEnumProperty(104, "PAGE"));
        propertyMaker.addEnum("page-sequence", this.getEnumProperty(105, "PAGE_SEQUENCE"));
        propertyMaker.addEnum("document", this.getEnumProperty(34, "DOCUMENT"));
        propertyMaker.setDefault("page-sequence");
        FOPropertyMapping.addPropertyMaker("retrieve-boundary", propertyMaker);
        propertyMaker = new EnumProperty.Maker(209);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("first-starting", this.getEnumProperty(191, "FIRST_STARTING"));
        propertyMaker.addEnum("first-including-carryover", this.getEnumProperty(49, "FIC"));
        propertyMaker.addEnum("last-starting", this.getEnumProperty(192, "LAST_STARTING"));
        propertyMaker.addEnum("last-ending", this.getEnumProperty(193, "LAST_ENDING"));
        propertyMaker.setDefault("first-starting");
        FOPropertyMapping.addPropertyMaker("retrieve-position-within-table", propertyMaker);
        propertyMaker = new EnumProperty.Maker(206);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("table", this.getEnumProperty(194, "TABLE"));
        propertyMaker.addEnum("table-fragment", this.getEnumProperty(195, "TABLE_FRAGMENT"));
        propertyMaker.addEnum("page", this.getEnumProperty(34, "PAGE"));
        propertyMaker.setDefault("table");
        FOPropertyMapping.addPropertyMaker("retrieve-boundary-within-table", propertyMaker);
    }

    private void createNumberToStringProperties() {
        PropertyMaker propertyMaker = new StringProperty.Maker(110);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("1");
        FOPropertyMapping.addPropertyMaker("format", propertyMaker);
        propertyMaker = new CharacterProperty.Maker(113);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("grouping-separator", propertyMaker);
        propertyMaker = new NumberProperty.Maker(114);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("0");
        FOPropertyMapping.addPropertyMaker("grouping-size", propertyMaker);
        propertyMaker = new EnumProperty.Maker(142);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        propertyMaker.addEnum("traditional", this.getEnumProperty(146, "TRADITIONAL"));
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("letter-value", propertyMaker);
        propertyMaker = new StringProperty.Maker(276);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("fox:number-conversion-features", propertyMaker);
    }

    private void createPaginationAndLayoutProperties() {
        PropertyMaker propertyMaker = new EnumProperty.Maker(16);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("blank", this.getEnumProperty(16, "BLANK"));
        propertyMaker.addEnum("not-blank", this.getEnumProperty(98, "NOT_BLANK"));
        propertyMaker.addEnum("any", this.getEnumProperty(8, "ANY"));
        propertyMaker.setDefault("any");
        FOPropertyMapping.addPropertyMaker("blank-or-not-blank", propertyMaker);
        propertyMaker = new NumberProperty.PositiveIntegerMaker(74);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("1");
        FOPropertyMapping.addPropertyMaker("column-count", propertyMaker);
        LengthProperty.Maker maker = new LengthProperty.Maker(75);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setDefault("0.25in");
        FOPropertyMapping.addPropertyMaker("column-gap", maker);
        propertyMaker = new LengthProperty.Maker(93);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("0pt");
        propertyMaker.setPercentBase(0);
        FOPropertyMapping.addPropertyMaker("extent", propertyMaker);
        propertyMaker = new StringProperty.Maker(98);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("flow-name", propertyMaker);
        propertyMaker = new EnumProperty.Maker(109);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("even", this.getEnumProperty(43, "EVEN"));
        propertyMaker.addEnum("odd", this.getEnumProperty(99, "ODD"));
        propertyMaker.addEnum("end-on-even", this.getEnumProperty(40, "END_ON_EVEN"));
        propertyMaker.addEnum("end-on-odd", this.getEnumProperty(41, "END_ON_ODD"));
        propertyMaker.addEnum("no-force", this.getEnumProperty(88, "NO_FORCE"));
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("force-page-count", propertyMaker);
        propertyMaker = new NumberProperty.PositiveIntegerMaker(126);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("auto-odd", this.getEnumProperty(11, "AUTO_ODD"));
        propertyMaker.addEnum("auto-even", this.getEnumProperty(10, "AUTO_EVEN"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("initial-page-number", propertyMaker);
        propertyMaker = new StringProperty.Maker(153);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("master-name", propertyMaker);
        propertyMaker = new StringProperty.Maker(154);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("master-reference", propertyMaker);
        propertyMaker = new NumberProperty.Maker(156);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("no-limit", this.getEnumProperty(89, "NO_LIMIT"));
        propertyMaker.setDefault("no-limit");
        FOPropertyMapping.addPropertyMaker("maximum-repeats", propertyMaker);
        propertyMaker = new EnumProperty.Maker(161);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("paginate", this.getEnumProperty(106, "PAGINATE"));
        propertyMaker.addEnum("bounded-in-one-dimension", this.getEnumProperty(21, "BOUNDED_IN_ONE_DIMENSION"));
        propertyMaker.addEnum("unbounded", this.getEnumProperty(152, "UNBOUNDED"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("media-usage", propertyMaker);
        propertyMaker = new EnumProperty.Maker(167);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("odd", this.getEnumProperty(99, "ODD"));
        propertyMaker.addEnum("even", this.getEnumProperty(43, "EVEN"));
        propertyMaker.addEnum("any", this.getEnumProperty(8, "ANY"));
        propertyMaker.setDefault("any");
        FOPropertyMapping.addPropertyMaker("odd-or-even", propertyMaker);
        maker = new PageDimensionMaker(183);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("indefinite", this.getEnumProperty(64, "INDEFINITE"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("page-height", maker);
        propertyMaker = new EnumProperty.Maker(185);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("first", this.getEnumProperty(50, "FIRST"));
        propertyMaker.addEnum("last", this.getEnumProperty(72, "LAST"));
        propertyMaker.addEnum("rest", this.getEnumProperty(117, "REST"));
        propertyMaker.addEnum("any", this.getEnumProperty(8, "ANY"));
        propertyMaker.addEnum("only", this.getEnumProperty(186, "ONLY"));
        propertyMaker.setDefault("any");
        FOPropertyMapping.addPropertyMaker("page-position", propertyMaker);
        maker = new PageDimensionMaker(186);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("indefinite", this.getEnumProperty(64, "INDEFINITE"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("page-width", maker);
        propertyMaker = new EnumProperty.Maker(194);
        propertyMaker.useGeneric(this.genericBoolean);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("precedence", propertyMaker);
        propertyMaker = new StringProperty.Maker(199);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("region-name", propertyMaker);
    }

    private void createTableProperties() {
        PropertyMaker propertyMaker = new TableBorderPrecedence(20);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-after-precedence", propertyMaker);
        propertyMaker = new TableBorderPrecedence(24);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-before-precedence", propertyMaker);
        propertyMaker = new EnumProperty.Maker(31);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("collapse");
        propertyMaker.addEnum("separate", this.getEnumProperty(129, "SEPARATE"));
        propertyMaker.addEnum("collapse-with-precedence", this.getEnumProperty(27, "COLLAPSE_WITH_PRECEDENCE"));
        propertyMaker.addEnum("collapse", this.getEnumProperty(26, "COLLAPSE"));
        FOPropertyMapping.addPropertyMaker("border-collapse", propertyMaker);
        propertyMaker = new TableBorderPrecedence(34);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-end-precedence", propertyMaker);
        propertyMaker = new LengthPairProperty.Maker(45);
        propertyMaker.setInherited(true);
        propertyMaker.addShorthand(generics[46]);
        LengthProperty.Maker maker = new LengthProperty.Maker(512);
        maker.setDefault("0pt");
        maker.setByShorthand(true);
        propertyMaker.addSubpropMaker(maker);
        maker = new LengthProperty.Maker(1536);
        maker.setDefault("0pt");
        maker.setByShorthand(true);
        propertyMaker.addSubpropMaker(maker);
        FOPropertyMapping.addPropertyMaker("border-separation", propertyMaker);
        propertyMaker = new TableBorderPrecedence(48);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-start-precedence", propertyMaker);
        propertyMaker = new EnumProperty.Maker(60);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        propertyMaker.addEnum("after", this.getEnumProperty(3, "AFTER"));
        propertyMaker.addEnum("start", this.getEnumProperty(135, "START"));
        propertyMaker.addEnum("end", this.getEnumProperty(39, "END"));
        propertyMaker.addEnum("top", this.getEnumProperty(145, "TOP"));
        propertyMaker.addEnum("bottom", this.getEnumProperty(20, "BOTTOM"));
        propertyMaker.addEnum("left", this.getEnumProperty(73, "LEFT"));
        propertyMaker.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        propertyMaker.setDefault("before");
        FOPropertyMapping.addPropertyMaker("caption-side", propertyMaker);
        propertyMaker = new TableFObj.ColumnNumberPropertyMaker(76);
        propertyMaker.setInherited(false);
        FOPropertyMapping.addPropertyMaker("column-number", propertyMaker);
        propertyMaker = new LengthProperty.Maker(77);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.setDefault("auto");
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("column-width", propertyMaker);
        propertyMaker = new EnumProperty.Maker(90);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("show", this.getEnumProperty(130, "SHOW"));
        propertyMaker.addEnum("hide", this.getEnumProperty(58, "HIDE"));
        propertyMaker.setDefault("show");
        FOPropertyMapping.addPropertyMaker("empty-cells", propertyMaker);
        propertyMaker = new EnumProperty.Maker(92);
        propertyMaker.setInherited(false);
        propertyMaker.useGeneric(this.genericBoolean);
        propertyMaker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("ends-row", propertyMaker);
        propertyMaker = new NumberProperty.PositiveIntegerMaker(164);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-columns-repeated", propertyMaker);
        propertyMaker = new NumberProperty.PositiveIntegerMaker(165);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-columns-spanned", propertyMaker);
        propertyMaker = new NumberProperty.PositiveIntegerMaker(166);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-rows-spanned", propertyMaker);
        propertyMaker = new EnumProperty.Maker(235);
        propertyMaker.useGeneric(this.genericBoolean);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("starts-row", propertyMaker);
        propertyMaker = new EnumProperty.Maker(239);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("auto");
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        FOPropertyMapping.addPropertyMaker("table-layout", propertyMaker);
        propertyMaker = new EnumProperty.Maker(240);
        propertyMaker.useGeneric(this.genericBoolean);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("table-omit-footer-at-break", propertyMaker);
        propertyMaker = new EnumProperty.Maker(241);
        propertyMaker.useGeneric(this.genericBoolean);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("table-omit-header-at-break", propertyMaker);
    }

    private void createWritingModeProperties() {
        PropertyMaker propertyMaker = new EnumProperty.Maker(86);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("ltr", this.getEnumProperty(80, "LTR"));
        propertyMaker.addEnum("rtl", this.getEnumProperty(122, "RTL"));
        propertyMaker.setDefault("ltr");
        FOPropertyMapping.addPropertyMaker("direction", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(111);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("0deg");
        FOPropertyMapping.addPropertyMaker("glyph-orientation-horizontal", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(112);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("glyph-orientation-vertical", propertyMaker);
        propertyMaker = new LengthProperty.Maker(247);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("use-font-metrics", this.getEnumProperty(156, "USE_FONT_METRICS"));
        propertyMaker.setDefault("use-font-metrics");
        propertyMaker.setPercentBase(1);
        FOPropertyMapping.addPropertyMaker("text-altitude", propertyMaker);
        propertyMaker = new LengthProperty.Maker(249);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("use-font-metrics", this.getEnumProperty(156, "USE_FONT_METRICS"));
        propertyMaker.setDefault("use-font-metrics");
        propertyMaker.setPercentBase(1);
        FOPropertyMapping.addPropertyMaker("text-depth", propertyMaker);
        propertyMaker = new EnumProperty.Maker(255);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        propertyMaker.addEnum("embed", this.getEnumProperty(38, "EMBED"));
        propertyMaker.addEnum("bidi-override", this.getEnumProperty(15, "BIDI_OVERRIDE"));
        propertyMaker.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("unicode-bidi", propertyMaker);
        propertyMaker = new EnumProperty.Maker(267);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("lr-tb");
        propertyMaker.addEnum("lr-tb", this.getEnumProperty(79, "LR_TB"));
        propertyMaker.addEnum("rl-tb", this.getEnumProperty(121, "RL_TB"));
        propertyMaker.addEnum("tb-rl", this.getEnumProperty(140, "TB_RL"));
        propertyMaker.addEnum("tb-lr", this.getEnumProperty(205, "TB_LR"));
        propertyMaker.addKeyword("lr", "lr-tb");
        propertyMaker.addKeyword("rl", "rl-tb");
        propertyMaker.addKeyword("tb", "tb-rl");
        FOPropertyMapping.addPropertyMaker("writing-mode", propertyMaker);
    }

    private void createMiscProperties() {
        PropertyMaker propertyMaker = new StringProperty.Maker(79);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("content-type", propertyMaker);
        propertyMaker = new StringProperty.Maker(122);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("id", propertyMaker);
        propertyMaker = new StringProperty.Maker(274);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("fox:alt-text", propertyMaker);
        propertyMaker = new LengthProperty.Maker(196);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("6pt");
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("provisional-label-separation", propertyMaker);
        propertyMaker = new LengthProperty.Maker(195);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("24pt");
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("provisional-distance-between-starts", propertyMaker);
        propertyMaker = new StringProperty.Maker(198);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("ref-id", propertyMaker);
        propertyMaker = new EnumProperty.Maker(217);
        propertyMaker.useGeneric(this.genericBoolean);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("true");
        FOPropertyMapping.addPropertyMaker("score-spaces", propertyMaker);
        propertyMaker = new URIProperty.Maker(232);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("src", propertyMaker);
        propertyMaker = new EnumProperty.Maker(257);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("visible", this.getEnumProperty(159, "VISIBLE"));
        propertyMaker.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        propertyMaker.addEnum("collapse", this.getEnumProperty(26, "COLLAPSE"));
        propertyMaker.setDefault("visible");
        FOPropertyMapping.addPropertyMaker("visibility", propertyMaker);
        propertyMaker = new NumberProperty.Maker(269);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("z-index", propertyMaker);
    }

    private void createShorthandProperties() {
        PropertyMaker propertyMaker = new ToBeImplementedProperty.Maker(7);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("background", propertyMaker);
        propertyMaker = new BackgroundPositionShorthand.Maker(11);
        propertyMaker.setInherited(false);
        propertyMaker.addKeyword("left", "0pt 50%");
        propertyMaker.addKeyword("left center", "0pt 50%");
        propertyMaker.addKeyword("center left", "0pt 50%");
        propertyMaker.addKeyword("right", "100% 50%");
        propertyMaker.addKeyword("right center", "100% 50%");
        propertyMaker.addKeyword("center right", "100% 50%");
        propertyMaker.addKeyword("center", "50% 50%");
        propertyMaker.addKeyword("center center", "50% 50%");
        propertyMaker.addKeyword("top", "50% 0pt");
        propertyMaker.addKeyword("top center", "50% 0pt");
        propertyMaker.addKeyword("center top", "50% 0pt");
        propertyMaker.addKeyword("bottom", "50% 100%");
        propertyMaker.addKeyword("bottom center", "50% 100%");
        propertyMaker.addKeyword("center bottom", "50% 100%");
        propertyMaker.addKeyword("top left", "0pt 0pt");
        propertyMaker.addKeyword("left top", "0pt 0pt");
        propertyMaker.addKeyword("top right", "100% 0pt");
        propertyMaker.addKeyword("right top", "100% 0pt");
        propertyMaker.addKeyword("bottom left", "0pt 100%");
        propertyMaker.addKeyword("left bottom", "0pt 100%");
        propertyMaker.addKeyword("bottom right", "100% 100%");
        propertyMaker.addKeyword("right bottom", "100% 100%");
        propertyMaker.setDefault("0pt 0pt");
        propertyMaker.setPercentBase(0);
        propertyMaker.setDatatypeParser(new BackgroundPositionShorthand.Parser());
        FOPropertyMapping.addPropertyMaker("background-position", propertyMaker);
        propertyMaker = new ListProperty.Maker(18);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        propertyMaker.setDatatypeParser(new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border", propertyMaker);
        propertyMaker = new ListProperty.Maker(27);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        propertyMaker.setDatatypeParser(new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-bottom", propertyMaker);
        propertyMaker = new ListProperty.Maker(32);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        propertyMaker.setDatatypeParser(new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-color", propertyMaker);
        propertyMaker = new ListProperty.Maker(37);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        propertyMaker.setDatatypeParser(new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-left", propertyMaker);
        propertyMaker = new ListProperty.Maker(41);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        propertyMaker.setDatatypeParser(new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-right", propertyMaker);
        propertyMaker = new ListProperty.Maker(51);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        propertyMaker.setDatatypeParser(new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-style", propertyMaker);
        propertyMaker = new ListProperty.Maker(46);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("0pt");
        propertyMaker.setDatatypeParser(new BorderSpacingShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-spacing", propertyMaker);
        propertyMaker = new ListProperty.Maker(52);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        propertyMaker.setDatatypeParser(new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-top", propertyMaker);
        propertyMaker = new ListProperty.Maker(56);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        propertyMaker.setDatatypeParser(new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-width", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(82);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("cue", propertyMaker);
        propertyMaker = new FontShorthandProperty.Maker(100);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("caption", this.getEnumProperty(180, "CAPTION"));
        propertyMaker.addEnum("icon", this.getEnumProperty(181, "ICON"));
        propertyMaker.addEnum("message-box", this.getEnumProperty(183, "MESSAGE_BOX"));
        propertyMaker.addEnum("menu", this.getEnumProperty(182, "MENU"));
        propertyMaker.addEnum("small-caption", this.getEnumProperty(184, "SMALL_CAPTION"));
        propertyMaker.addEnum("status-bar", this.getEnumProperty(185, "STATUS_BAR"));
        propertyMaker.setDefault("");
        propertyMaker.setDatatypeParser(new FontShorthandParser());
        FOPropertyMapping.addPropertyMaker("font", propertyMaker);
        propertyMaker = new ListProperty.Maker(147);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        propertyMaker.setDatatypeParser(new BoxPropShorthandParser());
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin", propertyMaker);
        propertyMaker = new ListProperty.Maker(170);
        propertyMaker.setInherited(false);
        propertyMaker.setDatatypeParser(new BoxPropShorthandParser());
        propertyMaker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("padding", propertyMaker);
        propertyMaker = new EnumProperty.Maker(179);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        propertyMaker.addEnum("avoid", this.getEnumProperty(178, "AVOID"));
        propertyMaker.addEnum("left", this.getEnumProperty(73, "LEFT"));
        propertyMaker.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        propertyMaker.setDefault("auto");
        propertyMaker.setDatatypeParser(new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-after", propertyMaker);
        propertyMaker = new EnumProperty.Maker(180);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        propertyMaker.addEnum("avoid", this.getEnumProperty(178, "AVOID"));
        propertyMaker.addEnum("left", this.getEnumProperty(73, "LEFT"));
        propertyMaker.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        propertyMaker.setDefault("auto");
        propertyMaker.setDatatypeParser(new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-before", propertyMaker);
        propertyMaker = new EnumProperty.Maker(181);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        propertyMaker.addEnum("avoid", this.getEnumProperty(178, "AVOID"));
        propertyMaker.setDefault("auto");
        propertyMaker.setDatatypeParser(new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-inside", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(187);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause", propertyMaker);
        propertyMaker = new EnumProperty.Maker(193);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("static", this.getEnumProperty(136, "STATIC"));
        propertyMaker.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        propertyMaker.addEnum("absolute", this.getEnumProperty(1, "ABSOLUTE"));
        propertyMaker.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        propertyMaker.setDefault("static");
        propertyMaker.setDatatypeParser(new PositionShorthandParser());
        FOPropertyMapping.addPropertyMaker("position", propertyMaker);
        propertyMaker = new ToBeImplementedProperty.Maker(220);
        propertyMaker.setInherited(false);
        propertyMaker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("size", propertyMaker);
        propertyMaker = new LengthProperty.Maker(256);
        propertyMaker.setInherited(false);
        propertyMaker.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        propertyMaker.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        propertyMaker.addEnum("sub", this.getEnumProperty(137, "SUB"));
        propertyMaker.addEnum("super", this.getEnumProperty(138, "SUPER"));
        propertyMaker.addEnum("text-top", this.getEnumProperty(144, "TEXT_TOP"));
        propertyMaker.addEnum("text-bottom", this.getEnumProperty(143, "TEXT_BOTTOM"));
        propertyMaker.addEnum("top", this.getEnumProperty(145, "TOP"));
        propertyMaker.addEnum("bottom", this.getEnumProperty(20, "BOTTOM"));
        propertyMaker.setDatatypeParser(new VerticalAlignShorthandParser());
        propertyMaker.setDefault("baseline");
        propertyMaker.setPercentBase(12);
        FOPropertyMapping.addPropertyMaker("vertical-align", propertyMaker);
        propertyMaker = new EnumProperty.Maker(260);
        propertyMaker.setInherited(true);
        propertyMaker.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        propertyMaker.addEnum("pre", this.getEnumProperty(179, "PRE"));
        propertyMaker.addEnum("nowrap", this.getEnumProperty(93, "NO_WRAP"));
        propertyMaker.setDefault("normal");
        propertyMaker.setDatatypeParser(new WhiteSpaceShorthandParser());
        FOPropertyMapping.addPropertyMaker("white-space", propertyMaker);
        propertyMaker = new StringProperty.Maker(268);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("");
        propertyMaker.setDatatypeParser(new XMLLangShorthandParser());
        FOPropertyMapping.addPropertyMaker("xml:lang", propertyMaker);
        propertyMaker = new URIProperty.Maker(275);
        propertyMaker.setInherited(true);
        propertyMaker.setDefault("");
        FOPropertyMapping.addPropertyMaker("xml:base", propertyMaker);
    }
}

