/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.awt.Color;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.SpaceProperty;
import org.xml.sax.Locator;

public class FOText
extends FONode
implements CharSequence {
    private CharBuffer charBuffer;
    private CommonFont commonFont;
    private CommonHyphenation commonHyphenation;
    private Color color;
    private KeepProperty keepTogether;
    private Property letterSpacing;
    private SpaceProperty lineHeight;
    private int whiteSpaceTreatment;
    private int whiteSpaceCollapse;
    private int textTransform;
    private Property wordSpacing;
    private int wrapOption;
    private Length baselineShift;
    private String country;
    private String language;
    private String script;
    private FOText prevFOTextThisBlock = null;
    private FOText nextFOTextThisBlock = null;
    private Block ancestorBlock = null;
    private CommonTextDecoration textDecoration;
    private StructureTreeElement structureTreeElement;
    private int[] bidiLevels;
    private Map mappings;
    private static final int IS_WORD_CHAR_FALSE = 0;
    private static final int IS_WORD_CHAR_TRUE = 1;
    private static final int IS_WORD_CHAR_MAYBE = 2;

    public FOText(FONode fONode) {
        super(fONode);
    }

    protected void characters(char[] cArray, int n, int n2, PropertyList propertyList, Locator locator) throws FOPException {
        if (this.charBuffer == null) {
            int n3 = n2 < 16 ? 16 : n2;
            this.charBuffer = CharBuffer.allocate(n3);
        } else {
            int n4;
            int n5 = this.charBuffer.position() + n2;
            if (n5 > (n4 = this.charBuffer.capacity())) {
                int n6 = n4 * 2;
                if (n5 > n6) {
                    n6 = n5;
                }
                CharBuffer charBuffer = CharBuffer.allocate(n6);
                this.charBuffer.rewind();
                charBuffer.put(this.charBuffer);
                this.charBuffer = charBuffer;
            }
        }
        this.charBuffer.limit(this.charBuffer.capacity());
        this.charBuffer.put(cArray, n, n2);
        this.charBuffer.limit(this.charBuffer.position());
    }

    public CharSequence getCharSequence() {
        if (this.charBuffer == null) {
            return null;
        }
        this.charBuffer.rewind();
        return this.charBuffer.asReadOnlyBuffer().subSequence(0, this.charBuffer.limit());
    }

    public FONode clone(FONode fONode, boolean bl) throws FOPException {
        FOText fOText = (FOText)super.clone(fONode, bl);
        if (bl && this.charBuffer != null) {
            fOText.charBuffer = CharBuffer.allocate(this.charBuffer.limit());
            this.charBuffer.rewind();
            fOText.charBuffer.put(this.charBuffer);
            fOText.charBuffer.rewind();
        }
        fOText.prevFOTextThisBlock = null;
        fOText.nextFOTextThisBlock = null;
        fOText.ancestorBlock = null;
        return fOText;
    }

    public void bind(PropertyList propertyList) throws FOPException {
        this.commonFont = propertyList.getFontProps();
        this.commonHyphenation = propertyList.getHyphenationProps();
        this.color = propertyList.get(72).getColor(this.getUserAgent());
        this.keepTogether = propertyList.get(131).getKeep();
        this.lineHeight = propertyList.get(144).getSpace();
        this.letterSpacing = propertyList.get(141);
        this.whiteSpaceCollapse = propertyList.get(261).getEnum();
        this.whiteSpaceTreatment = propertyList.get(262).getEnum();
        this.textTransform = propertyList.get(252).getEnum();
        this.wordSpacing = propertyList.get(265);
        this.wrapOption = propertyList.get(266).getEnum();
        this.textDecoration = propertyList.getTextDecorationProps();
        this.baselineShift = propertyList.get(15).getLength();
        this.country = propertyList.get(81).getString();
        this.language = propertyList.get(134).getString();
        this.script = propertyList.get(218).getString();
    }

    protected void endOfNode() throws FOPException {
        if (this.charBuffer != null) {
            this.charBuffer.rewind();
        }
        super.endOfNode();
        this.getFOEventHandler().characters(this);
    }

    public void finalizeNode() {
        this.textTransform();
    }

    public boolean willCreateArea() {
        if (this.whiteSpaceCollapse == 48 && this.charBuffer.limit() > 0) {
            return true;
        }
        this.charBuffer.rewind();
        while (this.charBuffer.hasRemaining()) {
            char c = this.charBuffer.get();
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            this.charBuffer.rewind();
            return true;
        }
        return false;
    }

    public CharIterator charIterator() {
        return new TextCharIterator();
    }

    protected void createBlockPointers(Block block) {
        this.ancestorBlock = block;
        if (block.lastFOTextProcessed != null) {
            if (block.lastFOTextProcessed.ancestorBlock == this.ancestorBlock) {
                this.prevFOTextThisBlock = block.lastFOTextProcessed;
                this.prevFOTextThisBlock.nextFOTextThisBlock = this;
            } else {
                this.prevFOTextThisBlock = null;
            }
        }
    }

    private void textTransform() {
        if (this.getBuilderContext().inMarker() || this.textTransform == 95) {
            return;
        }
        this.charBuffer.rewind();
        CharBuffer charBuffer = this.charBuffer.slice();
        int n = this.charBuffer.limit();
        int n2 = -1;
        block5: while (++n2 < n) {
            char c = this.charBuffer.get();
            switch (this.textTransform) {
                case 155: {
                    charBuffer.put(Character.toUpperCase(c));
                    continue block5;
                }
                case 78: {
                    charBuffer.put(Character.toLowerCase(c));
                    continue block5;
                }
                case 22: {
                    if (this.isStartOfWord(n2)) {
                        charBuffer.put(Character.toTitleCase(c));
                        continue block5;
                    }
                    charBuffer.put(c);
                    continue block5;
                }
            }
            assert (false);
        }
    }

    private boolean isStartOfWord(int n) {
        char c = this.getRelativeCharInBlock(n, -1);
        switch (FOText.isWordChar(c)) {
            case 1: {
                return false;
            }
            case 0: {
                return true;
            }
            case 2: {
                char c2 = this.getRelativeCharInBlock(n, -2);
                switch (FOText.isWordChar(c2)) {
                    case 1: {
                        return false;
                    }
                    case 0: {
                        return true;
                    }
                    case 2: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private char getRelativeCharInBlock(int n, int n2) {
        int n3 = n + n2;
        if (n3 >= 0 && n3 < this.length()) {
            return this.charAt(n + n2);
        }
        if (n2 > 0) {
            return '\u0000';
        }
        boolean bl = false;
        char c = '\u0000';
        FOText fOText = this;
        int n4 = n2 + n;
        while (!bl && fOText.prevFOTextThisBlock != null) {
            fOText = fOText.prevFOTextThisBlock;
            int n5 = fOText.length() + n4 - 1;
            if (n5 >= 0) {
                c = fOText.charAt(n5);
                bl = true;
                continue;
            }
            n4 += n5;
        }
        return c;
    }

    private static int isWordChar(char c) {
        switch (Character.getType(c)) {
            case 8: {
                return 1;
            }
            case 23: {
                return 1;
            }
            case 15: {
                return 0;
            }
            case 26: {
                return 1;
            }
            case 20: {
                if (c == '-') {
                    return 1;
                }
                return 0;
            }
            case 9: {
                return 1;
            }
            case 7: {
                return 0;
            }
            case 22: {
                if (c == '\u2019') {
                    return 2;
                }
                return 0;
            }
            case 16: {
                return 0;
            }
            case 10: {
                return 1;
            }
            case 13: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 25: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 27: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 11: {
                return 1;
            }
            case 24: {
                if (c == '\'') {
                    return 2;
                }
                return 0;
            }
            case 28: {
                return 1;
            }
            case 14: {
                return 0;
            }
            case 18: {
                return 0;
            }
            case 12: {
                return 0;
            }
            case 21: {
                return 0;
            }
            case 19: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public CommonFont getCommonFont() {
        return this.commonFont;
    }

    public CommonHyphenation getCommonHyphenation() {
        return this.commonHyphenation;
    }

    public Color getColor() {
        return this.color;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public Property getLetterSpacing() {
        return this.letterSpacing;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public int getWhitespaceTreatment() {
        return this.whiteSpaceTreatment;
    }

    public Property getWordSpacing() {
        return this.wordSpacing;
    }

    public int getWrapOption() {
        return this.wrapOption;
    }

    public CommonTextDecoration getTextDecoration() {
        return this.textDecoration;
    }

    public Length getBaseLineShift() {
        return this.baselineShift;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScript() {
        return this.script;
    }

    public String toString() {
        if (this.charBuffer == null) {
            return "";
        }
        CharBuffer charBuffer = this.charBuffer.duplicate();
        charBuffer.rewind();
        return charBuffer.toString();
    }

    public String getLocalName() {
        return "#PCDATA";
    }

    public String getNormalNamespacePrefix() {
        return null;
    }

    protected String gatherContextInfo() {
        if (this.locator != null) {
            return super.gatherContextInfo();
        }
        return this.toString();
    }

    public char charAt(int n) {
        return this.charBuffer.get(n);
    }

    public CharSequence subSequence(int n, int n2) {
        return this.charBuffer.subSequence(n, n2);
    }

    public int length() {
        return this.charBuffer.limit();
    }

    public void resetBuffer() {
        if (this.charBuffer != null) {
            this.charBuffer.rewind();
        }
    }

    public boolean isDelimitedTextRangeBoundary(int n) {
        return false;
    }

    public void setStructureTreeElement(StructureTreeElement structureTreeElement) {
        this.structureTreeElement = structureTreeElement;
    }

    public StructureTreeElement getStructureTreeElement() {
        return this.structureTreeElement;
    }

    public void setBidiLevel(int n, int n2, int n3) {
        if (n2 < n3) {
            if (this.bidiLevels == null) {
                this.bidiLevels = new int[this.length()];
            }
            int n4 = n3;
            for (int i = n2; i < n4; ++i) {
                this.bidiLevels[i] = n;
            }
            if (this.parent != null) {
                ((FObj)this.parent).setBidiLevel(n);
            }
        } else assert (n2 < n3);
    }

    public int[] getBidiLevels() {
        return this.bidiLevels;
    }

    public int[] getBidiLevels(int n, int n2) {
        if (this.bidiLevels != null) {
            assert (n <= n2);
            int n3 = n2 - n;
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = this.bidiLevels[n + i];
            }
            return nArray;
        }
        return null;
    }

    public int bidiLevelAt(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.bidiLevels != null) {
            return this.bidiLevels[n];
        }
        return -1;
    }

    public void addMapping(int n, int n2, CharSequence charSequence) {
        if (this.mappings == null) {
            this.mappings = new HashMap();
        }
        this.mappings.put(new MapRange(n, n2), charSequence.toString());
    }

    public boolean hasMapping(int n, int n2) {
        return this.mappings != null && this.mappings.containsKey(new MapRange(n, n2));
    }

    public String getMapping(int n, int n2) {
        if (this.mappings != null) {
            return (String)this.mappings.get(new MapRange(n, n2));
        }
        return null;
    }

    public int getMappingLength(int n, int n2) {
        if (this.mappings != null) {
            return ((String)this.mappings.get(new MapRange(n, n2))).length();
        }
        return 0;
    }

    public int[] getMappingBidiLevels(int n, int n2) {
        if (this.hasMapping(n, n2)) {
            int n3 = n2 - n;
            int n4 = this.getMappingLength(n, n2);
            int[] nArray = this.getBidiLevels(n, n2);
            if (nArray == null) {
                return null;
            }
            if (n4 == n3) {
                return nArray;
            }
            if (n4 > n3) {
                int n5;
                int n6;
                int[] nArray2 = new int[n4];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                int n7 = nArray2.length;
                int n8 = n6 = n5 > 0 ? nArray[n5 - 1] : 0;
                for (n5 = nArray.length; n5 < n7; ++n5) {
                    nArray2[n5] = n6;
                }
                return nArray2;
            }
            int[] nArray3 = new int[n4];
            System.arraycopy(nArray, 0, nArray3, 0, nArray3.length);
            return nArray3;
        }
        return this.getBidiLevels(n, n2);
    }

    protected Stack collectDelimitedTextRanges(Stack stack, DelimitedTextRange delimitedTextRange) {
        if (delimitedTextRange != null) {
            delimitedTextRange.append(this.charIterator(), (FONode)this);
        }
        return stack;
    }

    private static class MapRange {
        private int start;
        private int end;

        MapRange(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int hashCode() {
            return this.start * 31 + this.end;
        }

        public boolean equals(Object object) {
            if (object instanceof MapRange) {
                MapRange mapRange = (MapRange)object;
                return mapRange.start == this.start && mapRange.end == this.end;
            }
            return false;
        }
    }

    private class TextCharIterator
    extends CharIterator {
        private int currentPosition = 0;
        private boolean canRemove = false;
        private boolean canReplace = false;

        public boolean hasNext() {
            return this.currentPosition < FOText.this.charBuffer.limit();
        }

        public char nextChar() {
            if (this.currentPosition < FOText.this.charBuffer.limit()) {
                this.canRemove = true;
                this.canReplace = true;
                return FOText.this.charBuffer.get(this.currentPosition++);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.canRemove) {
                FOText.this.charBuffer.position(this.currentPosition);
                CharBuffer charBuffer = FOText.this.charBuffer.slice();
                FOText.this.charBuffer.position(--this.currentPosition);
                if (charBuffer.hasRemaining()) {
                    FOText.this.charBuffer.mark();
                    FOText.this.charBuffer.put(charBuffer);
                    FOText.this.charBuffer.reset();
                }
            } else {
                throw new IllegalStateException();
            }
            FOText.this.charBuffer.limit(FOText.this.charBuffer.limit() - 1);
            this.canRemove = false;
        }

        public void replaceChar(char c) {
            if (!this.canReplace) {
                throw new IllegalStateException();
            }
            FOText.this.charBuffer.put(this.currentPosition - 1, c);
        }
    }
}

