/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.Property;

class CIELabColorFunction
extends FunctionBase {
    CIELabColorFunction() {
    }

    public int getRequiredArgsCount() {
        return 6;
    }

    public PercentBase getPercentBase() {
        return new CIELabPercentBase();
    }

    public Property eval(Property[] propertyArray, PropertyInfo propertyInfo) throws PropertyException {
        float f = propertyArray[0].getNumber().floatValue();
        float f2 = propertyArray[1].getNumber().floatValue();
        float f3 = propertyArray[2].getNumber().floatValue();
        if (f < 0.0f || f > 255.0f || f2 < 0.0f || f2 > 255.0f || f3 < 0.0f || f3 > 255.0f) {
            throw new PropertyException("sRGB color values out of range. Arguments to cie-lab-color() must be [0..255] or [0%..100%]");
        }
        float f4 = propertyArray[3].getNumber().floatValue();
        float f5 = propertyArray[4].getNumber().floatValue();
        float f6 = propertyArray[5].getNumber().floatValue();
        if (f4 < 0.0f || f4 > 100.0f) {
            throw new PropertyException("L* value out of range. Valid range: [0..100]");
        }
        if (f5 < -127.0f || f5 > 127.0f || f6 < -127.0f || f6 > 127.0f) {
            throw new PropertyException("a* and b* values out of range. Valid range: [-127..+127]");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cie-lab-color(" + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + ")");
        FOUserAgent fOUserAgent = propertyInfo == null ? null : (propertyInfo.getFO() == null ? null : propertyInfo.getFO().getUserAgent());
        return ColorProperty.getInstance(fOUserAgent, stringBuffer.toString());
    }

    private static class CIELabPercentBase
    implements PercentBase {
        private CIELabPercentBase() {
        }

        public int getDimension() {
            return 0;
        }

        public double getBaseValue() {
            return 1.0;
        }

        public int getBaseLength(PercentBaseContext percentBaseContext) {
            return 0;
        }
    }
}

