/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.LengthBase;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.expr.AbsFunction;
import org.apache.fop.fo.expr.BodyStartFunction;
import org.apache.fop.fo.expr.CIELabColorFunction;
import org.apache.fop.fo.expr.CMYKColorFunction;
import org.apache.fop.fo.expr.CeilingFunction;
import org.apache.fop.fo.expr.FloorFunction;
import org.apache.fop.fo.expr.FromNearestSpecifiedValueFunction;
import org.apache.fop.fo.expr.FromParentFunction;
import org.apache.fop.fo.expr.FromTableColumnFunction;
import org.apache.fop.fo.expr.Function;
import org.apache.fop.fo.expr.InheritedPropFunction;
import org.apache.fop.fo.expr.LabelEndFunction;
import org.apache.fop.fo.expr.MaxFunction;
import org.apache.fop.fo.expr.MinFunction;
import org.apache.fop.fo.expr.NCnameProperty;
import org.apache.fop.fo.expr.NumericOp;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.expr.PropertyTokenizer;
import org.apache.fop.fo.expr.ProportionalColumnWidthFunction;
import org.apache.fop.fo.expr.RGBColorFunction;
import org.apache.fop.fo.expr.RGBICCColorFunction;
import org.apache.fop.fo.expr.RGBNamedColorFunction;
import org.apache.fop.fo.expr.RoundFunction;
import org.apache.fop.fo.expr.SystemColorFunction;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.StringProperty;

public final class PropertyParser
extends PropertyTokenizer {
    private PropertyInfo propInfo;
    private static final String RELUNIT = "em";
    private static final HashMap FUNCTION_TABLE = new HashMap();

    public static Property parse(String string, PropertyInfo propertyInfo) throws PropertyException {
        try {
            return new PropertyParser(string, propertyInfo).parseProperty();
        }
        catch (PropertyException propertyException) {
            propertyException.setPropertyInfo(propertyInfo);
            throw propertyException;
        }
    }

    private PropertyParser(String string, PropertyInfo propertyInfo) {
        super(string);
        this.propInfo = propertyInfo;
    }

    private Property parseProperty() throws PropertyException {
        this.next();
        if (this.currentToken == 0) {
            return StringProperty.getInstance("");
        }
        ListProperty listProperty = null;
        while (true) {
            Property property = this.parseAdditiveExpr();
            if (this.currentToken == 0) {
                if (listProperty != null) {
                    listProperty.addProperty(property);
                    return listProperty;
                }
                return property;
            }
            if (listProperty == null) {
                listProperty = new ListProperty(property);
                continue;
            }
            listProperty.addProperty(property);
        }
    }

    private Property parseAdditiveExpr() throws PropertyException {
        Property property = this.parseMultiplicativeExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 8: {
                    this.next();
                    property = this.evalAddition(property.getNumeric(), this.parseMultiplicativeExpr().getNumeric());
                    continue block4;
                }
                case 9: {
                    this.next();
                    property = this.evalSubtraction(property.getNumeric(), this.parseMultiplicativeExpr().getNumeric());
                    continue block4;
                }
            }
            break;
        }
        return property;
    }

    private Property parseMultiplicativeExpr() throws PropertyException {
        Property property = this.parseUnaryExpr();
        block5: while (true) {
            switch (this.currentToken) {
                case 11: {
                    this.next();
                    property = this.evalDivide(property.getNumeric(), this.parseUnaryExpr().getNumeric());
                    continue block5;
                }
                case 10: {
                    this.next();
                    property = this.evalModulo(property.getNumber(), this.parseUnaryExpr().getNumber());
                    continue block5;
                }
                case 2: {
                    this.next();
                    property = this.evalMultiply(property.getNumeric(), this.parseUnaryExpr().getNumeric());
                    continue block5;
                }
            }
            break;
        }
        return property;
    }

    private Property parseUnaryExpr() throws PropertyException {
        if (this.currentToken == 9) {
            this.next();
            return this.evalNegate(this.parseUnaryExpr().getNumeric());
        }
        return this.parsePrimaryExpr();
    }

    private void expectRpar() throws PropertyException {
        if (this.currentToken != 4) {
            throw new PropertyException("expected )");
        }
        this.next();
    }

    private Property parsePrimaryExpr() throws PropertyException {
        Property property;
        if (this.currentToken == 13) {
            this.next();
        }
        switch (this.currentToken) {
            case 3: {
                this.next();
                Property property2 = this.parseAdditiveExpr();
                this.expectRpar();
                return property2;
            }
            case 5: {
                property = StringProperty.getInstance(this.currentTokenValue);
                break;
            }
            case 1: {
                property = new NCnameProperty(this.currentTokenValue);
                break;
            }
            case 16: {
                property = NumberProperty.getInstance(new Double(this.currentTokenValue));
                break;
            }
            case 17: {
                property = NumberProperty.getInstance(new Integer(this.currentTokenValue));
                break;
            }
            case 14: {
                double d = Double.parseDouble(this.currentTokenValue.substring(0, this.currentTokenValue.length() - 1)) / 100.0;
                PercentBase percentBase = this.propInfo.getPercentBase();
                if (percentBase != null) {
                    if (percentBase.getDimension() == 0) {
                        property = NumberProperty.getInstance(d * percentBase.getBaseValue());
                        break;
                    }
                    if (percentBase.getDimension() == 1) {
                        if (percentBase instanceof LengthBase) {
                            if (d == 0.0) {
                                property = FixedLength.ZERO_FIXED_LENGTH;
                                break;
                            }
                            Length length = ((LengthBase)percentBase).getBaseLength();
                            if (length != null && length.isAbsolute()) {
                                property = FixedLength.getInstance(d * (double)length.getValue());
                                break;
                            }
                        }
                        property = new PercentLength(d, percentBase);
                        break;
                    }
                    throw new PropertyException("Illegal percent dimension value");
                }
                property = NumberProperty.getInstance(d);
                break;
            }
            case 12: {
                int n = this.currentTokenValue.length() - this.currentUnitLength;
                String string = this.currentTokenValue.substring(n);
                double d = Double.parseDouble(this.currentTokenValue.substring(0, n));
                if (RELUNIT.equals(string)) {
                    property = (Property)((Object)NumericOp.multiply(NumberProperty.getInstance(d), this.propInfo.currentFontSize()));
                    break;
                }
                if ("px".equals(string)) {
                    float f = this.propInfo.getPropertyList().getFObj().getUserAgent().getSourceResolution();
                    property = FixedLength.getInstance(d, string, 72.0f / f);
                    break;
                }
                property = FixedLength.getInstance(d, string);
                break;
            }
            case 15: {
                property = ColorProperty.getInstance(this.propInfo.getUserAgent(), this.currentTokenValue);
                break;
            }
            case 7: {
                Function function = (Function)FUNCTION_TABLE.get(this.currentTokenValue);
                if (function == null) {
                    throw new PropertyException("no such function: " + this.currentTokenValue);
                }
                this.next();
                this.propInfo.pushFunction(function);
                Property property3 = function.eval(this.parseArgs(function), this.propInfo);
                this.propInfo.popFunction();
                return property3;
            }
            default: {
                throw new PropertyException("syntax error");
            }
        }
        this.next();
        return property;
    }

    Property[] parseArgs(Function function) throws PropertyException {
        int n;
        int n2 = function.getRequiredArgsCount();
        int n3 = function.getOptionalArgsCount();
        boolean bl = function.hasVariableArgs();
        ArrayList<Property> arrayList = new ArrayList<Property>(n2 + n3);
        if (this.currentToken == 4) {
            this.next();
        } else {
            while (true) {
                Property property = this.parseAdditiveExpr();
                n = arrayList.size();
                if (n >= n2 && n - n2 >= n3 && !bl) {
                    throw new PropertyException("Unexpected function argument at index " + n);
                }
                arrayList.add(property);
                if (this.currentToken != 13) break;
                this.next();
            }
            this.expectRpar();
        }
        int n4 = arrayList.size();
        if (n4 < n2) {
            throw new PropertyException("Expected " + n2 + " required arguments, but only " + n4 + " specified");
        }
        for (n = 0; n < n3; ++n) {
            if (arrayList.size() >= n2 + n + 1) continue;
            arrayList.add(function.getOptionalArgDefault(n, this.propInfo));
        }
        return arrayList.toArray(new Property[arrayList.size()]);
    }

    private Property evalAddition(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in addition");
        }
        return (Property)((Object)NumericOp.addition(numeric, numeric2));
    }

    private Property evalSubtraction(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in subtraction");
        }
        return (Property)((Object)NumericOp.subtraction(numeric, numeric2));
    }

    private Property evalNegate(Numeric numeric) throws PropertyException {
        if (numeric == null) {
            throw new PropertyException("Non numeric operand to unary minus");
        }
        return (Property)((Object)NumericOp.negate(numeric));
    }

    private Property evalMultiply(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in multiplication");
        }
        return (Property)((Object)NumericOp.multiply(numeric, numeric2));
    }

    private Property evalDivide(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in division");
        }
        return (Property)((Object)NumericOp.divide(numeric, numeric2));
    }

    private Property evalModulo(Number number, Number number2) throws PropertyException {
        if (number == null || number2 == null) {
            throw new PropertyException("Non number operand to modulo");
        }
        return NumberProperty.getInstance(number.doubleValue() % number2.doubleValue());
    }

    static {
        FUNCTION_TABLE.put("ceiling", new CeilingFunction());
        FUNCTION_TABLE.put("floor", new FloorFunction());
        FUNCTION_TABLE.put("round", new RoundFunction());
        FUNCTION_TABLE.put("min", new MinFunction());
        FUNCTION_TABLE.put("max", new MaxFunction());
        FUNCTION_TABLE.put("abs", new AbsFunction());
        FUNCTION_TABLE.put("rgb", new RGBColorFunction());
        FUNCTION_TABLE.put("system-color", new SystemColorFunction());
        FUNCTION_TABLE.put("from-table-column", new FromTableColumnFunction());
        FUNCTION_TABLE.put("inherited-property-value", new InheritedPropFunction());
        FUNCTION_TABLE.put("from-nearest-specified-value", new FromNearestSpecifiedValueFunction());
        FUNCTION_TABLE.put("from-parent", new FromParentFunction());
        FUNCTION_TABLE.put("proportional-column-width", new ProportionalColumnWidthFunction());
        FUNCTION_TABLE.put("label-end", new LabelEndFunction());
        FUNCTION_TABLE.put("body-start", new BodyStartFunction());
        FUNCTION_TABLE.put("rgb-icc", new RGBICCColorFunction());
        FUNCTION_TABLE.put("rgb-named-color", new RGBNamedColorFunction());
        FUNCTION_TABLE.put("cie-lab-color", new CIELabColorFunction());
        FUNCTION_TABLE.put("cmyk", new CMYKColorFunction());
    }
}

