/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.NumericOp;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.TableColLength;
import org.apache.fop.util.CompareUtil;

public class RelativeNumericProperty
extends Property
implements Length {
    public static final int ADDITION = 1;
    public static final int SUBTRACTION = 2;
    public static final int MULTIPLY = 3;
    public static final int DIVIDE = 4;
    public static final int MODULO = 5;
    public static final int NEGATE = 6;
    public static final int ABS = 7;
    public static final int MAX = 8;
    public static final int MIN = 9;
    private static String operations = " +-*/%";
    private int operation;
    private Numeric op1;
    private Numeric op2 = null;
    private int dimension;

    public RelativeNumericProperty(int n, Numeric numeric, Numeric numeric2) {
        this.operation = n;
        this.op1 = numeric;
        this.op2 = numeric2;
        switch (n) {
            case 3: {
                this.dimension = numeric.getDimension() + numeric2.getDimension();
                break;
            }
            case 4: {
                this.dimension = numeric.getDimension() - numeric2.getDimension();
                break;
            }
            default: {
                this.dimension = numeric.getDimension();
            }
        }
    }

    public RelativeNumericProperty(int n, Numeric numeric) {
        this.operation = n;
        this.op1 = numeric;
        this.dimension = numeric.getDimension();
    }

    private Numeric getResolved(PercentBaseContext percentBaseContext) throws PropertyException {
        switch (this.operation) {
            case 1: {
                return NumericOp.addition2(this.op1, this.op2, percentBaseContext);
            }
            case 2: {
                return NumericOp.subtraction2(this.op1, this.op2, percentBaseContext);
            }
            case 3: {
                return NumericOp.multiply2(this.op1, this.op2, percentBaseContext);
            }
            case 4: {
                return NumericOp.divide2(this.op1, this.op2, percentBaseContext);
            }
            case 5: {
                return NumericOp.modulo2(this.op1, this.op2, percentBaseContext);
            }
            case 6: {
                return NumericOp.negate2(this.op1, percentBaseContext);
            }
            case 7: {
                return NumericOp.abs2(this.op1, percentBaseContext);
            }
            case 8: {
                return NumericOp.max2(this.op1, this.op2, percentBaseContext);
            }
            case 9: {
                return NumericOp.min2(this.op1, this.op2, percentBaseContext);
            }
        }
        throw new PropertyException("Unknown expr operation " + this.operation);
    }

    public double getNumericValue() throws PropertyException {
        return this.getResolved(null).getNumericValue(null);
    }

    public double getNumericValue(PercentBaseContext percentBaseContext) throws PropertyException {
        return this.getResolved(percentBaseContext).getNumericValue(percentBaseContext);
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isAbsolute() {
        return false;
    }

    public Length getLength() {
        if (this.dimension == 1) {
            return this;
        }
        log.error((Object)("Can't create length with dimension " + this.dimension));
        return null;
    }

    public Numeric getNumeric() {
        return this;
    }

    public int getValue() {
        try {
            return (int)this.getNumericValue();
        }
        catch (PropertyException propertyException) {
            log.error((Object)propertyException);
            return 0;
        }
    }

    public int getValue(PercentBaseContext percentBaseContext) {
        try {
            return (int)this.getNumericValue(percentBaseContext);
        }
        catch (PropertyException propertyException) {
            log.error((Object)propertyException);
            return 0;
        }
    }

    public double getTableUnits() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.op1 instanceof RelativeNumericProperty) {
            d = ((RelativeNumericProperty)this.op1).getTableUnits();
        } else if (this.op1 instanceof TableColLength) {
            d = ((TableColLength)this.op1).getTableUnits();
        }
        if (this.op2 instanceof RelativeNumericProperty) {
            d2 = ((RelativeNumericProperty)this.op2).getTableUnits();
        } else if (this.op2 instanceof TableColLength) {
            d2 = ((TableColLength)this.op2).getTableUnits();
        }
        if (d != 0.0 && d2 != 0.0) {
            switch (this.operation) {
                case 1: {
                    return d + d2;
                }
                case 2: {
                    return d - d2;
                }
                case 3: {
                    return d * d2;
                }
                case 4: {
                    return d / d2;
                }
                case 5: {
                    return d % d2;
                }
                case 9: {
                    return Math.min(d, d2);
                }
                case 8: {
                    return Math.max(d, d2);
                }
            }
            assert (false);
        } else {
            if (d != 0.0) {
                switch (this.operation) {
                    case 6: {
                        return -d;
                    }
                    case 7: {
                        return Math.abs(d);
                    }
                }
                return d;
            }
            if (d2 != 0.0) {
                return d2;
            }
        }
        return 0.0;
    }

    public String toString() {
        switch (this.operation) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return "(" + this.op1 + " " + operations.charAt(this.operation) + this.op2 + ")";
            }
            case 6: {
                return "-" + this.op1;
            }
            case 8: {
                return "max(" + this.op1 + ", " + this.op2 + ")";
            }
            case 9: {
                return "min(" + this.op1 + ", " + this.op2 + ")";
            }
            case 7: {
                return "abs(" + this.op1 + ")";
            }
        }
        return "unknown operation " + this.operation;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.dimension;
        n = 31 * n + CompareUtil.getHashCode(this.op1);
        n = 31 * n + CompareUtil.getHashCode(this.op2);
        n = 31 * n + this.operation;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RelativeNumericProperty)) {
            return false;
        }
        RelativeNumericProperty relativeNumericProperty = (RelativeNumericProperty)object;
        return this.dimension == relativeNumericProperty.dimension && CompareUtil.equal(this.op1, relativeNumericProperty.op1) && CompareUtil.equal(this.op2, relativeNumericProperty.op2) && this.operation == relativeNumericProperty.operation;
    }
}

