/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.awt.Color;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fo.properties.StructureTreeElementHolder;
import org.xml.sax.Locator;

public class Character
extends FObj
implements StructureTreeElementHolder {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonFont commonFont;
    private CommonHyphenation commonHyphenation;
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private char character;
    private Color color;
    private int dominantBaseline;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private Property letterSpacing;
    private SpaceProperty lineHeight;
    private CommonTextDecoration textDecoration;
    private Property wordSpacing;
    private StructureTreeElement structureTreeElement;
    public static final int OK = 0;
    public static final int DOESNOT_FIT = 1;

    public Character(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.commonFont = propertyList.getFontProps();
        this.commonHyphenation = propertyList.getHyphenationProps();
        this.alignmentAdjust = propertyList.get(3).getLength();
        this.alignmentBaseline = propertyList.get(4).getEnum();
        this.baselineShift = propertyList.get(15).getLength();
        this.character = propertyList.get(69).getCharacter();
        this.color = propertyList.get(72).getColor(this.getUserAgent());
        this.dominantBaseline = propertyList.get(88).getEnum();
        this.keepWithNext = propertyList.get(132).getKeep();
        this.keepWithPrevious = propertyList.get(133).getKeep();
        this.letterSpacing = propertyList.get(141);
        this.lineHeight = propertyList.get(144).getSpace();
        this.textDecoration = propertyList.getTextDecorationProps();
        this.wordSpacing = propertyList.get(265);
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().character(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            this.invalidChildError(locator, string, string2);
        }
    }

    public CharIterator charIterator() {
        return new FOCharIterator(this);
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public CommonFont getCommonFont() {
        return this.commonFont;
    }

    public CommonHyphenation getCommonHyphenation() {
        return this.commonHyphenation;
    }

    public char getCharacter() {
        return this.character;
    }

    public Color getColor() {
        return this.color;
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public Property getLetterSpacing() {
        return this.letterSpacing;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public CommonTextDecoration getTextDecoration() {
        return this.textDecoration;
    }

    public Property getWordSpacing() {
        return this.wordSpacing;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public void setStructureTreeElement(StructureTreeElement structureTreeElement) {
        this.structureTreeElement = structureTreeElement;
    }

    public StructureTreeElement getStructureTreeElement() {
        return this.structureTreeElement;
    }

    public String getLocalName() {
        return "character";
    }

    public int getNameId() {
        return 10;
    }

    public boolean isDelimitedTextRangeBoundary(int n) {
        return false;
    }

    protected Stack collectDelimitedTextRanges(Stack stack, DelimitedTextRange delimitedTextRange) {
        if (delimitedTextRange != null) {
            delimitedTextRange.append(this.charIterator(), (FONode)this);
        }
        return stack;
    }

    private class FOCharIterator
    extends CharIterator {
        private boolean bFirst = true;
        private Character foChar;

        FOCharIterator(Character character2) {
            this.foChar = character2;
        }

        public boolean hasNext() {
            return this.bFirst;
        }

        public char nextChar() {
            if (this.bFirst) {
                this.bFirst = false;
                return this.foChar.character;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            this.foChar.parent.removeChild(this.foChar);
        }

        public void replaceChar(char c) {
            this.foChar.character = c;
        }
    }
}

