/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.ValidationPercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.StaticPropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.ColumnNumberManager;
import org.apache.fop.fo.flow.table.ColumnNumberManagerHolder;
import org.apache.fop.fo.flow.table.FixedColRowGroupBuilder;
import org.apache.fop.fo.flow.table.RowGroupBuilder;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableEventProducer;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.VariableColRowGroupBuilder;
import org.apache.fop.fo.properties.BreakPropertySet;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthPairProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.TableColLength;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.WritingMode;
import org.apache.fop.traits.WritingModeTraits;
import org.apache.fop.traits.WritingModeTraitsGetter;
import org.xml.sax.Locator;

public class Table
extends TableFObj
implements ColumnNumberManagerHolder,
BreakPropertySet,
WritingModeTraitsGetter,
CommonAccessibilityHolder {
    private CommonAccessibility commonAccessibility;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginBlock commonMarginBlock;
    private LengthRangeProperty blockProgressionDimension;
    private int borderCollapse;
    private LengthPairProperty borderSeparation;
    private int breakAfter;
    private int breakBefore;
    private LengthRangeProperty inlineProgressionDimension;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private int tableLayout;
    private int tableOmitFooterAtBreak;
    private int tableOmitHeaderAtBreak;
    private WritingModeTraits writingModeTraits;
    private Length widowContentLimit;
    private Length orphanContentLimit;
    private List columns = new ArrayList();
    private ColumnNumberManager columnNumberManager = new ColumnNumberManager();
    private TableHeader tableHeader = null;
    private TableFooter tableFooter = null;
    private boolean tableColumnFound = false;
    private boolean tableHeaderFound = false;
    private boolean tableFooterFound = false;
    private boolean tableBodyFound = false;
    private boolean hasExplicitColumns = false;
    private boolean columnsFinalized = false;
    private RowGroupBuilder rowGroupBuilder;
    private PropertyList propList;

    public Table(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        TableEventProducer tableEventProducer;
        super.bind(propertyList);
        this.commonAccessibility = CommonAccessibility.getInstance(propertyList);
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.commonMarginBlock = propertyList.getMarginBlockProps();
        this.blockProgressionDimension = propertyList.get(17).getLengthRange();
        this.borderCollapse = propertyList.get(31).getEnum();
        this.borderSeparation = propertyList.get(45).getLengthPair();
        this.breakAfter = propertyList.get(58).getEnum();
        this.breakBefore = propertyList.get(59).getEnum();
        this.inlineProgressionDimension = propertyList.get(127).getLengthRange();
        this.keepTogether = propertyList.get(131).getKeep();
        this.keepWithNext = propertyList.get(132).getKeep();
        this.keepWithPrevious = propertyList.get(133).getKeep();
        this.tableLayout = propertyList.get(239).getEnum();
        this.tableOmitFooterAtBreak = propertyList.get(240).getEnum();
        this.tableOmitHeaderAtBreak = propertyList.get(241).getEnum();
        this.writingModeTraits = new WritingModeTraits(WritingMode.valueOf(propertyList.get(267).getEnum()));
        this.widowContentLimit = propertyList.get(271).getLength();
        this.orphanContentLimit = propertyList.get(272).getLength();
        if (!this.blockProgressionDimension.getOptimum(null).isAuto()) {
            tableEventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            tableEventProducer.nonAutoBPDOnTable(this, this.getLocator());
        }
        if (this.tableLayout == 9) {
            this.getFOValidationEventProducer().unimplementedFeature(this, this.getName(), "table-layout=\"auto\"", this.getLocator());
        }
        if (!this.isSeparateBorderModel()) {
            if (this.borderCollapse == 27) {
                this.getFOValidationEventProducer().unimplementedFeature(this, this.getName(), "border-collapse=\"collapse-with-precedence\"; defaulting to \"collapse\"", this.getLocator());
                this.borderCollapse = 26;
            }
            if (this.getCommonBorderPaddingBackground().hasPadding(ValidationPercentBaseContext.getPseudoContext())) {
                tableEventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                tableEventProducer.noTablePaddingWithCollapsingBorderModel(this, this.getLocator());
            }
        }
        this.propList = propertyList;
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startTable(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if ("marker".equals(string2)) {
                if (this.tableColumnFound || this.tableHeaderFound || this.tableFooterFound || this.tableBodyFound) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "(table-column*,table-header?,table-footer?,table-body+)");
                }
            } else if ("table-column".equals(string2)) {
                this.tableColumnFound = true;
                if (this.tableHeaderFound || this.tableFooterFound || this.tableBodyFound) {
                    this.nodesOutOfOrderError(locator, "fo:table-column", "(table-header?,table-footer?,table-body+)");
                }
            } else if ("table-header".equals(string2)) {
                if (this.tableHeaderFound) {
                    this.tooManyNodesError(locator, "table-header");
                } else {
                    this.tableHeaderFound = true;
                    if (this.tableFooterFound || this.tableBodyFound) {
                        this.nodesOutOfOrderError(locator, "fo:table-header", "(table-footer?,table-body+)");
                    }
                }
            } else if ("table-footer".equals(string2)) {
                if (this.tableFooterFound) {
                    this.tooManyNodesError(locator, "table-footer");
                } else {
                    this.tableFooterFound = true;
                    if (this.tableBodyFound) {
                        if (this.getUserAgent().validateStrictly()) {
                            this.nodesOutOfOrderError(locator, "fo:table-footer", "(table-body+)", true);
                        }
                        if (!this.isSeparateBorderModel()) {
                            TableEventProducer tableEventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                            tableEventProducer.footerOrderCannotRecover(this, this.getName(), this.getLocator());
                        }
                    }
                }
            } else if ("table-body".equals(string2)) {
                this.tableBodyFound = true;
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endTable(this);
    }

    public void finalizeNode() throws FOPException {
        if (!this.tableBodyFound) {
            this.missingChildElementError("(marker*,table-column*,table-header?,table-footer?,table-body+)");
        }
        if (!this.hasChildren()) {
            this.getParent().removeChild(this);
            return;
        }
        if (!this.inMarker()) {
            this.rowGroupBuilder.endTable();
            int n = this.columns.size();
            while (--n >= 0) {
                TableColumn tableColumn = (TableColumn)this.columns.get(n);
                if (tableColumn == null) continue;
                tableColumn.releasePropertyList();
            }
            this.propList = null;
            this.rowGroupBuilder = null;
        }
    }

    protected void addChildNode(FONode fONode) throws FOPException {
        int n = fONode.getNameId();
        block0 : switch (n) {
            case 76: {
                this.hasExplicitColumns = true;
                if (!this.inMarker()) {
                    this.addColumnNode((TableColumn)fONode);
                    break;
                }
                this.columns.add(fONode);
                break;
            }
            case 73: 
            case 77: 
            case 78: {
                if (!this.inMarker() && !this.columnsFinalized) {
                    this.columnsFinalized = true;
                    if (this.hasExplicitColumns) {
                        this.finalizeColumns();
                        this.rowGroupBuilder = new FixedColRowGroupBuilder(this);
                    } else {
                        this.rowGroupBuilder = new VariableColRowGroupBuilder(this);
                    }
                }
                switch (n) {
                    case 77: {
                        this.tableFooter = (TableFooter)fONode;
                        break block0;
                    }
                    case 78: {
                        this.tableHeader = (TableHeader)fONode;
                        break block0;
                    }
                }
                super.addChildNode(fONode);
                break;
            }
            default: {
                super.addChildNode(fONode);
            }
        }
    }

    private void finalizeColumns() throws FOPException {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (this.columns.get(i) != null) continue;
            this.columns.set(i, this.createImplicitColumn(i + 1));
        }
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public Table getTable() {
        return this;
    }

    void ensureColumnNumber(int n) throws FOPException {
        assert (!this.hasExplicitColumns);
        for (int i = this.columns.size() + 1; i <= n; ++i) {
            this.columns.add(this.createImplicitColumn(i));
        }
    }

    private TableColumn createImplicitColumn(int n) throws FOPException {
        TableColumn tableColumn = new TableColumn(this, true);
        StaticPropertyList staticPropertyList = new StaticPropertyList(tableColumn, this.propList);
        tableColumn.bind(staticPropertyList);
        tableColumn.setColumnWidth(new TableColLength(1.0, tableColumn));
        tableColumn.setColumnNumber(n);
        if (!this.isSeparateBorderModel()) {
            tableColumn.setCollapsedBorders(this.collapsingBorderModel);
        }
        return tableColumn;
    }

    private void addColumnNode(TableColumn tableColumn) {
        int n = tableColumn.getColumnNumber();
        int n2 = tableColumn.getNumberColumnsRepeated();
        while (this.columns.size() < n + n2 - 1) {
            this.columns.add(null);
        }
        for (int i = n - 1; i < n + n2 - 1; ++i) {
            this.columns.set(i, tableColumn);
        }
        this.columnNumberManager.signalUsedColumnNumbers(n, n + n2 - 1);
    }

    boolean hasExplicitColumns() {
        return this.hasExplicitColumns;
    }

    public boolean isAutoLayout() {
        return this.tableLayout == 9;
    }

    public List getColumns() {
        return this.columns;
    }

    public TableColumn getColumn(int n) {
        return (TableColumn)this.columns.get(n);
    }

    public int getNumberOfColumns() {
        return this.columns.size();
    }

    public TableHeader getTableHeader() {
        return this.tableHeader;
    }

    public TableFooter getTableFooter() {
        return this.tableFooter;
    }

    public boolean omitHeaderAtBreak() {
        return this.tableOmitHeaderAtBreak == 149;
    }

    public boolean omitFooterAtBreak() {
        return this.tableOmitFooterAtBreak == 149;
    }

    public LengthRangeProperty getInlineProgressionDimension() {
        return this.inlineProgressionDimension;
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public boolean mustKeepTogether() {
        return !this.getKeepTogether().getWithinPage().isAuto() || !this.getKeepTogether().getWithinColumn().isAuto();
    }

    public int getBorderCollapse() {
        return this.borderCollapse;
    }

    public boolean isSeparateBorderModel() {
        return this.getBorderCollapse() == 129;
    }

    public LengthPairProperty getBorderSeparation() {
        return this.borderSeparation;
    }

    public Direction getInlineProgressionDirection() {
        return this.writingModeTraits.getInlineProgressionDirection();
    }

    public Direction getBlockProgressionDirection() {
        return this.writingModeTraits.getBlockProgressionDirection();
    }

    public Direction getColumnProgressionDirection() {
        return this.writingModeTraits.getColumnProgressionDirection();
    }

    public Direction getRowProgressionDirection() {
        return this.writingModeTraits.getRowProgressionDirection();
    }

    public Direction getShiftDirection() {
        return this.writingModeTraits.getShiftDirection();
    }

    public WritingMode getWritingMode() {
        return this.writingModeTraits.getWritingMode();
    }

    public Length getWidowContentLimit() {
        return this.widowContentLimit;
    }

    public Length getOrphanContentLimit() {
        return this.orphanContentLimit;
    }

    public String getLocalName() {
        return "table";
    }

    public int getNameId() {
        return 71;
    }

    public FONode clone(FONode fONode, boolean bl) throws FOPException {
        Table table = (Table)super.clone(fONode, bl);
        if (bl) {
            table.columns = new ArrayList();
            table.columnsFinalized = false;
            table.columnNumberManager = new ColumnNumberManager();
            table.tableHeader = null;
            table.tableFooter = null;
            table.rowGroupBuilder = null;
        }
        return table;
    }

    public ColumnNumberManager getColumnNumberManager() {
        return this.columnNumberManager;
    }

    RowGroupBuilder getRowGroupBuilder() {
        return this.rowGroupBuilder;
    }

    protected Stack collectDelimitedTextRanges(Stack stack, DelimitedTextRange delimitedTextRange) {
        TableFooter tableFooter;
        TableHeader tableHeader = this.getTableHeader();
        if (tableHeader != null) {
            stack = tableHeader.collectDelimitedTextRanges(stack);
        }
        if ((tableFooter = this.getTableFooter()) != null) {
            stack = tableFooter.collectDelimitedTextRanges(stack);
        }
        FONode.FONodeIterator fONodeIterator = this.getChildNodes();
        while (fONodeIterator != null && fONodeIterator.hasNext()) {
            stack = ((FONode)fONodeIterator.next()).collectDelimitedTextRanges(stack);
        }
        return stack;
    }
}

